ORCA/M Asm65816 2.1.0

0001 9020                       title 'Control Manager Version 3.2' 
0002 9020              **********************************************************************
0003 9020              *
0004 9020              *                   Control Manager version 3.2
0005 9020              *
0006 9020              *           Copyright Apple Computer, Inc. 1986-90
0007 9020              *                    All rights reserved
0008 9020              *                   Written by Dan Oliver
0009 9020              *
0010 9020              * 08/27/87 Dan - start ROMing.
0011 9020              *
0012 9020              *
0013 9020              *                   Change History:
0014 9020              *
0015 9020              * 22 June 88        Harry Yee
0016 9020              *
0017 9020              * The following APW files were combined into this one file.
0018 9020              *
0019 9020              *          CMAIN.ASM
0020 9020              *          CTRACK.ASM
0021 9020              *          CDEFPROC.ASM
0022 9020              *          CSCROLL.ASM
0023 9020              *          CUTIL.ASM
0024 9020              *          CSTATIC.ASM
0025 9020              *          CDATA.ASM
0026 9020              *
0027 9020              * Converted over to MAX development system.
0028 9020              * (Version 2.5 of control mgr (System Disk 3.2))
0029 9020              *
0030 9020              * 29 June 88        Steven Glass
0031 9020              *
0032 9020              * Changed call table so that DragRect call would link to the window manager
0033 9020              * when in ROM and link to a dummy file when in RAM.  Changed version
0034 9020              * number from 0205 to 8206.
0035 9020              *
0036 9020              * 24 Jul 88         Steven Glass
0037 9020              *
0038 9020              * Changes made to the scroll bar def proc so that the control value
0039 9020              * is validated before it is used.  We could make this an application
0040 9020              * problem (as it was in the past) or fix it once and for all here.
0041 9020              *
0042 9020              * I want to fix it once and for all.  Changes were made to scroll_init
0043 9020              * newview and move_thumb.  In each case the control value is validated
0044 9020              * against the values for maxsize and viewsize.  In scroll_init and move_thumb,
0045 9020              * the value was considered correct and the MaxSize adjusted if necessary.
0046 9020              * In newview, we assume the view and maxsize are correct and adjust the
0047 9020              * value.
0048 9020              *
0049 9020              * If the scrollvalue is greater than MaxSize-ViewSize something is wrong.
0050 9020              * When we assume that the Value is correct, we reset MaxSize to be 
0051 9020              * ScrollValue+ViewSize.  When we assume the view and make an adjustment,
0052 9020              * we set the value to MaxSize-ViewSize or 0, whichever is greater.
0053 9020              *
0054 9020              * 16 Aug 88         Steven Glass
0055 9020              *
0056 9020              * The routine that installs the icon font, does not save, clear and
0057 9020              * restore the text face.  This allowed an application to have itallic
0058 9020              * bold, outlined and shadowed scroll bars.
0059 9020              *
0060 9020              * 14 Sep 88         Steven Glass
0061 9020              *
0062 9020              * Started changes for Super Controls...
0063 9020              *
0064 9020              * 28 Sep 88         Steven Glass
0065 9020              *
0066 9020              * Change in the way that the recsize routines can use the param
0067 9020              * field.  If the routines are called by NewControl, param is zero.
0068 9020              * If the routines are called by NewControl2, param is pointer to
0069 9020              * template.
0070 9020              *
0071 9020              * Added in utilities section:
0072 9020              *
0073 9020              *   PushStringPtr
0074 9020              *   ReadMoreFlags
0075 9020              *   GetColorTableRefFromTemplate
0076 9020              *   CalcColorTableRefForCtl
0077 9020              *
0078 9020              *
0079 9020              * 02 Oct 88         Steven Glass
0080 9020              *
0081 9020              * Changed a bunch of names to avoid conflicts with the window and menu
0082 9020              * managers.  This was necessary because in the past nothing was exported
0083 9020              * Now that the CtlMgr is in several files a number of routine names are
0084 9020              * public.
0085 9020              *
0086 9020              * The names that changed are
0087 9020              *
0088 9020              *    Startup --> CMStartup
0089 9020              *    popXbytes --> CMpopXbytes
0090 9020              *    allocate2 --> CMallocate2
0091 9020              *    allocate3 --> CMallocate3
0092 9020              *    setrect --> CMsetrect
0093 9020              *    setrect2 --> CMsetrect2
0094 9020              *
0095 9020              * 02 Oct 88         Steven Glass
0096 9020              *
0097 9020              * Changed kill controls to see if the control manager is active before
0098 9020              * calling startup.  This way applications that used the
0099 9020              * window mangager without the control manager will still work.
0100 9020              *
0101 9020              * The problem occured when the window manager closes a window, it calls
0102 9020              * KillControls.  When running from a system disk, this was not a problem
0103 9020              * The control manager was not loaded if the app did not want to use it.
0104 9020              * So a dispatch error occured and the window manager knows how to recover
0105 9020              * from this.
0106 9020              *
0107 9020              * KillControls now mimicks the dispatcher error.
0108 9020              *
0109 9020              * 05 Oct 88         Steven Glass
0110 9020              *
0111 9020              * Major changes to the dispatcher code to handle defProcs in resources
0112 9020              * as well as new control 2.
0113 9020              *
0114 9020              *
0115 9020              * 06 Oct 88         Steven Glass
0116 9020              *
0117 9020              * The active flag used by built in defProcs is in the global data
0118 9020              * area rather passed to the defproc.  This made it hard for
0119 9020              * custom defProcs to do the right thing when they draw.  So we also put
0120 9020              * the flag in the hi-word of the param sent with the draw message.
0121 9020              * This is done in Set2DrawCtl
0122 9020              *
0123 9020              * 07 Oct 88         Steven Glass
0124 9020              *
0125 9020              * ReleaseResource grew another paramter.
0126 9020              *
0127 9020              * 12 Oct 88         Steven Glass
0128 9020              *
0129 9020              * Add support for the list manager to the dispatch routine.
0130 9020              *
0131 9020              * 23 Oct 88         Steven Glass
0132 9020              *
0133 9020              * Zeroed ParamPtr in startup.
0134 9020              *
0135 9020              * 24 Oct 88         Steven Glass
0136 9020              *
0137 9020              * Modified some of the dispatcher code.  Added calls to TextEdit and
0138 9020              * MenuMgr to find addr of defPRocs.  Simplified and shortened other 
0139 9020              * dispatching code.
0140 9020              *
0141 9020              * 09 Nov 88         Steven Glass
0142 9020              *
0143 9020              * Added a converter routine for code resources.  This routine is
0144 9020              * installed at control startup time for rCtlDefProc types.  The
0145 9020              * routine can also be used by other code to convert code resources.
0146 9020              * A new control manager call GetCodeResConverter returns the 
0147 9020              * address of this routine.
0148 9020              *
0149 9020              * Removed all references ReleaseCodeResource in the code.  Code
0150 9020              * resources are just regular resources.
0151 9020              *
0152 9020              * Changed LoadCodeResource to call LoadResource and deref the
0153 9020              * resulting handle.
0154 9020              *
0155 9020              * 21 Nov 88         Steven Glass
0156 9020              *
0157 9020              * Change to TrackControl.  The ctlDrag message is different when control has
0158 9020              * part code > $80.  If the control is a super control, the high
0159 9020              * word of the result from defProc call is the part code to return
0160 9020              * to caller.  This allows us to return no part code if the 
0161 9020              * user pulls his mouse out of the control before releasing
0162 9020              * the button.
0163 9020              *
0164 9020              * 01 Dec 88         Steven Glass
0165 9020              *
0166 9020              * Added call to InvalCtls.
0167 9020              *
0168 9020              * 10 Feb 89         Steven Glass
0169 9020              *
0170 9020              * Minor change to routines that dispatch to defProcs in resources.
0171 9020              * These resources now need not have the high bit of their ID's set
0172 9020              * (invalid for current resource manager).
0173 9020              *
0174 9020              * 10 Feb 89         Harry Yee
0175 9020              *
0176 9020              * New control message ctlHideCntl, message #18. HideControl now checks if the
0177 9020              * control being hidden is a supercontrol, if it is then we check to see 
0178 9020              * if the FctlIsMultiPart bit is set in the moreflags field. If it is we let the 
0179 9020              * control's ctlHideCntl defproc take care of hiding the control. This is necesary 
0180 9020              * for controls that have more than one control associated with them (i.e. List Controls)
0181 9020              *
0182 9020              * 13 Feb 89         Steven Glass
0183 9020              *
0184 9020              * Preserved the y-reg in the new code written on 10 Feb to send
0185 9020              * hide/erase message to multipart controls.
0186 9020              *
0187 9020              *
0188 9020              * 28 Mar 89         Dave Good
0189 9020              *
0190 9020              * made the ctlHideCntl into a generic message: ctlNotifyMultiPart. Now the defproc
0191 9020              * gets passed this message by HideControl, EraseControl, ShowControl, and DrawOneCtl
0192 9020              * the low word of the parameter indicates which call sent the message
0193 9020              *
0194 9020              * 28 Mar 89         Steven Glass
0195 9020              *
0196 9020              * Added FutzCtls call.  It uses the new ctlWinStateChange message
0197 9020              * which is now supported by all the built in defProcs.
0198 9020              *
0199 9020              * 09 Apr 89         Steven Glass
0200 9020              *
0201 9020              * Changed CkButton2 (used by TrackControl) so that it does not leave
0202 9020              * mouse up events in the queue.  This could happen when button
0203 9020              * was up before trackControl was called or if button came up after
0204 9020              * get next event and before call to button.  Now we look at the mod
0205 9020              * word in event instead of calling button.
0206 9020              *
0207 9020              **********************************************************************
0208 9020                       Blanks off 
0209 9020                       String asis 
0210 9020
0211 9020                       print push 
0212 9020                       print off 
0213 9020
0214 9020                       INCLUDE 'all.macros' 
0215 9020
0216 9020                       include 'equates.asm' 
0217 9020                       include 'SuperEquates.asm' 
0218 9020                       include '::sys.equs.asm' 
0219 9020                       include 'e16.event' 
0220 9020
0221 9020                       print pop 
0222 9020                       title 'ControlCallTable' 
0223 9020              ;====================================================================
0224 9020              ;
0225 9020              ;          Control Manager Function Table.
0226 9020              ;
0227 9020              ;====================================================================
0228 9020              ControlCallTable PROC EXPORT 
0229 9020                       import WindDragRect 
0230 9020
0231 9020                       import FindActiveControl 
0232 9020                       import MakeNextControlActive 
0233 9020                       import MakeThisCtlActive 
0234 9020                       import SendEventToControl 
0235 9020                       import GetCtlID 
0236 9020                       import SetCtlID 
0237 9020                       import GetCtlMoreFlags 
0238 9020                       import SetCtlMoreFlags 
0239 9020                       import GetHandleFromID 
0240 9020                       import NewControl2 
0241 9020                       import CMReleaseResource 
0242 9020                       import CMLoadResource 
0243 9020                       import InvalCtls 
0244 9020
0245 9020
0246 9020                       ENTRY FPT 
0247 9020 38 00 00 00  FPT      DC L:(ENDFPT-FPT)/4
0248 9024 9A 91 FD 00           DC L:CtlBootInit-1             1
0249 9028 FF 90 FD 00           DC L:CtlStartup-1              2
0250 902C 9F 91 FD 00           DC L:CtlShutDown-1             No longer shuts down (see CtlReset).
0251 9030 CB 91 FD 00           DC L:CtlVersion-1              4
0252 9034 A4 91 FD 00           DC L:CtlReset-1                Shutdown, called from WindShutDown.
0253 9038 8F 91 FD 00           DC L:CtlStatus-1               6
0254 903C 9A 91 FD 00           DC L:Reserved-1                7
0255 9040 9A 91 FD 00           DC L:Reserved-1                8
0256 9044 E1 91 FD 00           DC L:NewControl-1              9
0257 9048 CD 92 FD 00           DC L:DisposeControl-1          A
0258 904C DB 92 FD 00           DC L:KillControls-1            B
0259 9050 80 93 FD 00           DC L:SetCtlTitle-1             C
0260 9054 A7 93 FD 00           DC L:GetCtlTitle-1             D
0261 9058 E1 94 FD 00           DC L:HideControl-1             E
0262 905C 6B 95 FD 00           DC L:ShowControl-1             F
0263 9060 B4 95 FD 00           DC L:DrawControls-1            10
0264 9064 A9 94 FD 00           DC L:HiliteControl-1           11
0265 9068 D5 91 FD 00           DC L:CtlNewRes-1               12
0266 906C 8B 9A FD 00           DC L:FindControl-1             13
0267 9070 10 9B FD 00           DC L:TestControl-1             14
0268 9074 50 98 FD 00           DC L:TrackControl-1            15
0269 9078 19 9A FD 00           DC L:MoveControl-1             16
0270 907C 27 9B FD 00           DC L:DragControl-1             17
0271 9080 65 93 FD 00           DC L:SetCtlIcons-1             18
0272 9084 C2 93 FD 00           DC L:SetCtlValue-1             19
0273 9088 F5 93 FD 00           DC L:GetCtlValue-1             1A
0274 908C 0A 94 FD 00           DC L:SetCtlParam-1             1B
0275 9090 2E 94 FD 00           DC L:GetCtlParam-1             1C
0276 9094
0277 9094                       ENTRY dragPatch 1D
0278 9094 F5 0C FD 00  dragPatch DC L:WindDragRect-1           ;Address may be patched by CtlStartup.
0279 9098
0280 9098 1C 98 FD 00           DC L:GrowSize-1                1E
0281 909C 49 94 FD 00           DC L:GetCtlzpage-1             1F
0282 90A0 59 94 FD 00           DC L:SetCtlAction-1            20
0283 90A4 66 94 FD 00           DC L:GetCtlAction-1            21
0284 90A8 73 94 FD 00           DC L:SetCtlRefCon-1            22
0285 90AC 8E 94 FD 00           DC L:GetCtlRefCon-1            23
0286 90B0 E9 94 FD 00           DC L:EraseControl-1            24
0287 90B4 5E 95 FD 00           DC L:DrawOneCtl-1              25
0288 90B8
0289 90B8              ; new calls added 20 Sep 88
0290 90B8 F3 B8 FD 00           DC L:FindActiveControl-1       $26
0291 90BC 0A B9 FD 00           DC L:MakeNextControlActive-1   $27
0292 90C0 B2 B9 FD 00           DC L:MakeThisCtlActive-1       $28
0293 90C4 2B BA FD 00           DC L:SendEventToControl-1      $29
0294 90C8 00 BB FD 00           DC L:GetCtlID-1                $2A
0295 90CC E4 BA FD 00           DC L:SetCtlID-1                $2B
0296 90D0 D1 9B FD 00           DC L:CallDefProc-1             $2C  (added oct 3 88)
0297 90D4 50 BB FD 00           DC L:NotifyControls-1          $2D  (added oct 3 88)
0298 90D8 16 BB FD 00           DC L:GetCtlMoreFlags-1         $2E
0299 90DC 33 BB FD 00           DC L:SetCtlMoreFlags-1         $2F
0300 90E0 A6 BA FD 00           DC L:GetHandleFromID-1         $30
0301 90E4 2A B6 FD 00           DC L:NewControl2-1             $31
0302 90E8 65 9D FD 00           DC L:CMLoadResource-1          $32  (added Oct 12 88)
0303 90EC 84 9D FD 00           DC L:CMReleaseResource-1       $33  (added Oct 12 88)
0304 90F0 FE 9B FD 00           DC L:SetCtlParamPtr-1          $34  (added Oct 21 88)
0305 90F4 14 9C FD 00           DC L:GetCtlParamPtr-1          $35  (added Oct 21 88)
0306 90F8 55 96 FD 00           DC L:FutzCtls-1                $36  (added Mar 28 89)
0307 90FC E0 95 FD 00           DC L:InvalCtls-1               $37  (added Nov 9 88)
0308 9100 AA D0 03 BB           DC L:CMUnloadSegments-1        $38  (added May 15, 1989)
0309 9104              ENDFPT    
0310 9104
0311 9104                       ENDP 
0312 9104
0313 9104                       title 'Standard Calls' 
0314 9104              ;
0315 9104              ;
0316 9104              ;====================================================================
0317 9104              ;
0318 9104              ;                   CtlStartup
0319 9104              ;
0320 9104              ;                   Initialize Control Manager
0321 9104              ;
0322 9104              ;  IN:     PUSH:WORD - ID to use.
0323 9104              ;          PUSH:WORD - direct page to use.
0324 9104              ;
0325 9104              ; OUT:     Nothing.
0326 9104              ;
0327 9104              ;====================================================================
0328 9104              CtlStartup PROC 
0329 9104
0330 9104              rtl2     equ   1                        Stack inputs offsets.
0331 9104              rtl1     equ   rtl2+3
0332 9104              newZP    equ   rtl1+3
0333 9104              id       equ   newZP+2
0334 9104
0335 9104              directPage equ   inputs                 Offset to direct page (when setup).
0336 9104              memoryID equ   directPage+2
0337 9104
0338 9104                       tax                            Have I already been initialized?
0339 9104                       bne   @1
0340 9104                       tyx   
0341 9104 F0 03                 beq   @2
0342 9106 82 81 00     @1       brl   exit1
0343 9109              @2        
0344 9109              ;
0345 9109 A3 09                 lda   id,s                     ID number to use.
0346 910B A8                    tay   
0347 910C A9 9A 00              lda   #RAMSIZE                 Number of bytes to allocate.
0348 910F 20 FE 9F              jsr   CMAllocate2              Allocate fixed RAM area.
0349 9112 9B                    txy                            Pass data area handle just like Tool Loc.
0350 9113 20 15 A0              jsr   CMStartup
0351 9116              ;
0352 9116 A0 02 00              ldy   #2                       Deference data area handle.
0353 9119 B7 41                 lda   [<data],y
0354 911B A8                    tay   
0355 911C A7 41                 lda   [<data]
0356 911E 85 41                 sta   <data                    Replace handle with pointer.
0357 9120 84 43                 sty   <data+2
0358 9122 20 E6 9F              jsr   setWAP                   Store data area pointer in Tool Locator.
0359 9125              ;
0360 9125              ;
0361 9125              ; --- Remember memory ID number to use ---------------------
0362 9125              ;
0363 9125 A5 50                 lda   <memoryID
0364 9127 A0 36 00              ldy   #MyID
0365 912A 97 41                 sta   [<data],y
0366 912C              ;
0367 912C              ;
0368 912C              ; --- Remember direct page passed by caller -----------------
0369 912C              ;
0370 912C A5 4E                 lda   <directPage
0371 912E A0 38 00              ldy   #MyDPage
0372 9131 97 41                 sta   [<data],y
0373 9133              ;
0374 9133              ;
0375 9133              ; --- Clear given direct page for Dialog Manager ------------
0376 9133              ;
0377 9133 0B                    phd   
0378 9134 5B                    tcd   
0379 9135 A2 FE 00              ldx   #$00FE
0380 9138 74 00        clearDpage stz   <0,x
0381 913A CA                    dex   
0382 913B CA                    dex   
0383 913C 10 FA                 bpl   clearDpage
0384 913E 2B                    pld   
0385 913F              ;
0386 913F              ;
0387 913F              ; --- Do resolution dependent initialization ----------------------------
0388 913F              ;
0389 913F 20 9C 9F              jsr   newResGuts
0390 9142
0391 9142              ;
0392 9142              ;
0393 9142              ; !!!!!!!!!!!! The following code is not ROMable !!!!!!!!!!!!!!!!!!!!!!!
0394 9142              ; !!!!!!!!!!! The patch will be done by linker when ready to ROM !!!!!!!!!
0395 9142              ;
0396 9142              ;
0397 9142              ; --- Patch out DragRect with routine in Window Manager -----------------
0398 9142              ;
0399 9142 48                    pha   
0400 9143 48                    pha   
0401 9144 A2 0E 54              ldx   #14+256*84               ; _GetDragRect
0402 9147 22 00 00 E1           jsl   $E10000
0403 914B 68                    pla   
0404 914C FA                    plx   
0405 914D A0 0C 10              ldy   #NOWIND_ERR
0406 9150 B0 3B                 bcs   exit2
0407 9152              ;
0408 9152 8F 94 90 FD           sta   >DragPatch
0409 9156 8A                    txa   
0410 9157 8F 96 90 FD           sta   >DragPatch+2
0411 915B              ;
0412 915B              ;
0413 915B              ; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
0414 915B              ;
0415 915B              ;
0416 915B
0417 915B
0418 915B              ;-----------------------------------------------------------
0419 915B              ;
0420 915B              ; Init the ParamPtr. (Added 23 Oct 88 SEG)
0421 915B              ;
0422 915B A9 00 00              lda   #0
0423 915E 48                    pha   
0424 915F 48                    pha   
0425 9160 A2 10 34 22           _SetCtlParamPtr 
0426 9167
0427 9167 48                    pha   
0428 9168 48                    pha   
0429 9169 A2 03 34 22           _GetCodeResConverter 
0430 9170 F4 0C 80              PushWord #rCtlDefProc 
0431 9173 F4 03 00              PushWord #%00000011            ; loggin in.  system list.
0432 9176 A2 1E 28 22           _ResourceConverter 
0433 917D 90 0B                 bcc   exit1
0434 917F
0435 917F
0436 917F C9 03 00              cmp   #$0003
0437 9182 B0 06                 bcs   @NotDispatchError
0438 9184
0439 9184 68                    pla                            ; clear the stack
0440 9185 68                    pla   
0441 9186 68                    pla   
0442 9187 68                    pla   
0443 9188 80 00                 bra   exit1
0444 918A
0445 918A              @NotDispatchError  
0446 918A
0447 918A
0448 918A A0 00 00     exit1    ldy   #0                       No error.
0449 918D 82 E7 0E     exit2    brl   CMpop4bytes
0450 9190
0451 9190                       ENDP 
0452 9190
0453 9190
0454 9190              ;====================================================================
0455 9190              ;
0456 9190              ;                   CtlStatus
0457 9190              ;
0458 9190              ;                   Return status of Control Manager.
0459 9190              ;
0460 9190              ;   IN:    None.
0461 9190              ;
0462 9190              ;  OUT:    WORD - 1 if active, 0 if not active.
0463 9190              ;====================================================================
0464 9190              CtlStatus PROC 
0465 9190
0466 9190              rtl2     equ   1                        Stack inputs offsets.
0467 9190              rtl1     equ   rtl2+3
0468 9190              result   equ   rtl1+3
0469 9190
0470 9190 AA                    tax                            Has a data area been allocated?
0471 9191 D0 03                 bne   ok1
0472 9193 BB                    tyx   
0473 9194 F0 03                 beq   store1
0474 9196 A9 06 00     ok1      lda   #6                       Dan O. version number.
0475 9199 83 07        store1   sta   result,s
0476 919B              ;
0477 919B              ;
0478 919B                       ENTRY CtlBootInit 
0479 919B              CtlBootInit                             ;       
0480 919B                       ENTRY Reserved 
0481 919B              Reserved                                ;       
0482 919B                       ENTRY exit_tool 
0483 919B              exit_tool                               ;       
0484 919B              ;
0485 919B A9 00 00              lda   #0                       No error.
0486 919E 18                    clc                            No error.
0487 919F 6B                    rtl   
0488 91A0
0489 91A0                       ENDP 
0490 91A0
0491 91A0
0492 91A0              ;====================================================================
0493 91A0              ;
0494 91A0              ;                   CtlShutDown
0495 91A0              ;
0496 91A0              ;                   Application's call for shutting down the Control Manager.
0497 91A0              ;
0498 91A0              ;   IN:    None.
0499 91A0              ;
0500 91A0              ;  OUT:    None.
0501 91A0              ;====================================================================
0502 91A0              CtlShutDown PROC export 
0503 91A0              ;
0504 91A0              ; Real shut down in CtlReset call.
0505 91A0              ;
0506 91A0 A9 00 00              lda   #0                       No error code.
0507 91A3 18                    clc                            No error flag.
0508 91A4 6B                    rtl                            Do nothing, Window Manager will shutdown.
0509 91A5
0510 91A5                       ENDP 
0511 91A5
0512 91A5
0513 91A5              ;====================================================================
0514 91A5              ;
0515 91A5              ;                   CtlReset
0516 91A5              ;
0517 91A5              ;                   Shut down Control Manager.
0518 91A5              ;
0519 91A5              ;  This call is what really shuts down the Control Manager. This call is
0520 91A5              ;  performed by the Window Manager when it is shut down.  The reason for this
0521 91A5              ;  is because many applications were shuting down the Control Manager before
0522 91A5              ;  shutting down the Window Manager.  An error occurred when the Window Manager
0523 91A5              ;  called the Control Manager, but found it already shutdown.
0524 91A5              ;
0525 91A5              ;   IN:  y/a = pointer to data area, null if Control Manager not initialized.
0526 91A5              ;
0527 91A5              ;  OUT:  None.
0528 91A5              ;
0529 91A5              ;====================================================================
0530 91A5              CtlReset PROC 
0531 91A5
0532 91A5 AA                    tax                            Is Control Manager already shutdown?
0533 91A6 D0 03                 bne   ok1
0534 91A8 BB                    tyx   
0535 91A9 F0 F5                 beq   CtlShutDown              If already off, just return.
0536 91AB
0537 91AB 20 15 A0     ok1      jsr   CMStartup
0538 91AE
0539 91AE              ;
0540 91AE              ; --- Freed data area ---------------------------------------------------
0541 91AE              ;
0542 91AE 48                    pha                            Space for result.
0543 91AF 48                    pha   
0544 91B0 D4 43                 pei   <data+2                  Pass address of data area.
0545 91B2 D4 41                 pei   <data
0546 91B4 A2 02 1A 22           _FindHandle                    Find handle of data area.
0547 91BB A2 02 10 22           _DisposeHandle                 Free handle of data area.
0548 91C2              ;
0549 91C2              ;
0550 91C2              ; --- Set my work area pointer in Tool Locator to zero ------------------
0551 91C2              ;
0552 91C2 A9 00 00              lda   #0                       Clear my saved value in Tool Locator
0553 91C5 A8                    tay                            to show I am not active.
0554 91C6 20 E6 9F              jsr   setWAP
0555 91C9              ;                                       Error code returned from setWAP.
0556 91C9 82 A6 0E              brl   CMpop0bytes
0557 91CC
0558 91CC                       ENDP 
0559 91CC
0560 91CC
0561 91CC              ;====================================================================
0562 91CC              ;
0563 91CC              ;                   CtlVersion
0564 91CC              ;
0565 91CC              ;                   Return Control Manager's Version number.
0566 91CC              ;
0567 91CC              ;   IN:  Nothing.
0568 91CC              ;  OUT:  WORD - version number.
0569 91CC              ;
0570 91CC              ;====================================================================
0571 91CC              CtlVersion PROC 
0572 91CC
0573 91CC              rtl2     equ   1                        Stack inputs offsets.
0574 91CC              rtl1     equ   rtl2+3
0575 91CC              result   equ   rtl1+3
0576 91CC
0577 91CC A9 00 03              lda   #$0300
0578 91CF 83 07                 sta   result,s
0579 91D1
0580 91D1 A9 00 00              lda   #0                       No error.
0581 91D4 18                    clc                            No error.
0582 91D5 6B                    rtl   
0583 91D6
0584 91D6                       ENDP 
0585 91D6
0586 91D6
0587 91D6
0588 91D6                       title 'OtherCalls' 
0589 91D6              ;====================================================================
0590 91D6              ;
0591 91D6              ;                   CtlNewRes
0592 91D6              ;
0593 91D6              ;                   To resolution dependent initialization.
0594 91D6              ;
0595 91D6              ;   IN:    Nothing.
0596 91D6              ;
0597 91D6              ;  OUT:    Nothing.
0598 91D6              ;====================================================================
0599 91D6              CtlNewRes PROC 
0600 91D6
0601 91D6 20 15 A0              jsr   CMStartup                Do setup for tool call.
0602 91D9              ;
0603 91D9 20 9C 9F              jsr   newResGuts               Reinitialize resolution dependents.
0604 91DC              ;
0605 91DC A0 00 00              ldy   #0                       No error.
0606 91DF 82 90 0E              brl   CMpop0bytes
0607 91E2
0608 91E2                       ENDP 
0609 91E2
0610 91E2
0611 91E2
0612 91E2
0613 91E2
0614 91E2              ;====================================================================
0615 91E2              ;
0616 91E2              ;                   NewControl
0617 91E2              ;
0618 91E2              ;                   Add a control to the control list.
0619 91E2              ;
0620 91E2              ;   IN:    PUSH:LONG - window pointer.
0621 91E2              ;          PUSH:LONG - pointer to enclosing RECT.
0622 91E2              ;          PUSH:LONG - pointer to string for title.
0623 91E2              ;          PUSH:WORD - control flag.
0624 91E2              ;          PUSH:WORD - current value.
0625 91E2              ;          PUSH:WORD - minimum value.
0626 91E2              ;          PUSH:WORD - maximum value.
0627 91E2              ;          PUSH:LONG - address of control definition procedure,
0628 91E2              ;                      with variation code in highest byte.
0629 91E2              ;                      For standard controls the variation codes are:
0630 91E2              ;                                     0 = simple button.
0631 91E2              ;                                     2 = check box.
0632 91E2              ;                                     4 = radio button.
0633 91E2              ;                                     6 = scroll bar.
0634 91E2              ;          PUSH:LONG - control's reference value, reserved for application.
0635 91E2              ;          PUSH:LONG - pointer to control's color table, zero for default.
0636 91E2              ;
0637 91E2              ;  OUT:    LONG - handle of control.
0638 91E2              ;
0639 91E2              ;====================================================================
0640 91E2              NewControl PROC 
0641 91E2
0642 91E2              colortable equ   inputs
0643 91E2              refCon   equ   colortable+4
0644 91E2              defProc  equ   refCon+4
0645 91E2              max      equ   defProc+4
0646 91E2              min      equ   max+2
0647 91E2              value    equ   min+2
0648 91E2              cflag    equ   value+2
0649 91E2              title    equ   cflag+2
0650 91E2              boundsRect equ   title+4
0651 91E2              theWindow equ   boundsRect+4
0652 91E2              CtlHandle equ   theWindow+4
0653 91E2              ;
0654 91E2              ;
0655 91E2 20 15 A0              jsr   CMStartup                Do setup for tool function.
0656 91E5              ;
0657 91E5 A6 6C                 ldx   <theWindow+2             Get pointer to control's window.
0658 91E7 A5 6A                 lda   <theWindow
0659 91E9 20 C1 A1              jsr   makeWptr                 windptr = pointer to window.
0660 91EC              ;
0661 91EC              ;
0662 91EC              ; --- Ask control's defProc for the size of the control's record ---------
0663 91EC              ;
0664 91EC 64 29                 stz   <param                   Zero the Param field to indicate
0665 91EE 64 2B                 stz   <param+2                 that this is a call from NewControl
0666 91F0
0667 91F0 A6 57                 ldx   <defProc+1               Get address of defProc.
0668 91F2 A5 56                 lda   <defProc
0669 91F4 D0 0D                 bne   custom                   Is it a custom control?
0670 91F6 9B                    txy   
0671 91F7 D0 0A                 bne   custom
0672 91F9              ;
0673 91F9 A5 58                 lda   <defProc+2               Pass standard control number.
0674 91FB A2 0C 00              ldx   #recSize                 Ask defProc for its required record size.
0675 91FE 20 6D 9C              jsr   standardDispatch         Call standard control defProc.
0676 9201 80 06                 bra   done1
0677 9203              ;
0678 9203 A0 0C 00     custom   ldy   #recSize                 Ask defProc for its required record size.
0679 9206 20 8C 9C              jsr   customDispatch           Call custom control defProc.
0680 9209              ;
0681 9209 48           done1    pha                            Save size.
0682 920A              ;
0683 920A              ;
0684 920A              ; --- Allocate the control --------------------------------------------------
0685 920A              ;
0686 920A 48                    pha                            Space for returned handle.
0687 920B 48                    pha   
0688 920C DA                    phx                            Size of record returned by defProc.
0689 920D 48                    pha   
0690 920E A0 36 00              ldy   #MyID
0691 9211 B7 41                 lda   [<data],y
0692 9213 48                    pha                            Pass ID for control manager.
0693 9214 A9 00 00              lda   #0                       Attributes, anywhere, anyway, baby.
0694 9217 48                    pha   
0695 9218 48                    pha                            Pass required address, none.
0696 9219 48                    pha   
0697 921A A2 02 09 22           _NewHandle                     Allocate record.
0698 9221 A8                    tay                            Put possible error code in Y.
0699 9222 68                    pla   
0700 9223 85 01                 sta   <Ctlhand
0701 9225 85 6E                 sta   <CtlHandle               Return handle of control.
0702 9227 68                    pla   
0703 9228 85 03                 sta   <Ctlhand+2
0704 922A 85 70                 sta   <CtlHandle+2
0705 922C              ;
0706 922C FA                    plx                            Get size of block.
0707 922D 90 03                 bcc   ok1                      Was a block allocated?
0708 922F 82 99 00              brl   exit                     If not, return error.
0709 9232              ;
0710 9232              ;
0711 9232              ; --- Dereference control's handle ----------------------------
0712 9232              ;
0713 9232 DA           ok1      phx                            Save block size.
0714 9233 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
0715 9236 7A                    ply                            Get memory block size.
0716 9237              ;
0717 9237 E2 20                 sep   #$20
0718 9239                       LONGA OFF
0719 9239 88                    dey   
0720 923A A9 00                 lda   #0                       Zero out the block.
0721 923C 88           lop3     dey   
0722 923D 97 05                 sta   [<ctlptr],y
0723 923F D0 FB                 bne   lop3
0724 9241 C2 20                 rep   #$20
0725 9243                       LONGA ON
0726 9243              ;
0727 9243              ;
0728 9243              ; --- Hook control into head of window's control list ------------
0729 9243              ;
0730 9243 A0 CA 00              ldy   #owControls
0731 9246 B7 09                 lda   [<windptr],y
0732 9248 87 05                 sta   [<Ctlptr]
0733 924A A5 01                 lda   <Ctlhand
0734 924C 97 09                 sta   [<windptr],y             New head of list.
0735 924E C8                    iny   
0736 924F C8                    iny   
0737 9250 B7 09                 lda   [<windptr],y
0738 9252 AA                    tax                            Save.
0739 9253 A5 03                 lda   <Ctlhand+2
0740 9255 97 09                 sta   [<windptr],y
0741 9257 A0 02 00              ldy   #2
0742 925A 8A                    txa   
0743 925B 97 05                 sta   [<Ctlptr],y
0744 925D              ;
0745 925D              ;
0746 925D              ; --- Remember mommy window ---------------------------
0747 925D              ;
0748 925D C8                    iny   
0749 925E C8                    iny   
0750 925F A5 6A                 lda   <theWindow
0751 9261 97 05                 sta   [<Ctlptr],y
0752 9263 C8                    iny   
0753 9264 C8                    iny   
0754 9265 A5 6C                 lda   <theWindow+2
0755 9267 97 05                 sta   [<Ctlptr],y
0756 9269              ;
0757 9269              ;
0758 9269              ; --- Set enclosing RECT ------------------------------
0759 9269              ;
0760 9269 A0 06 00              ldy   #x2
0761 926C A2 0E 00              ldx   #CtlRect+x2
0762 926F B7 66        lop1     lda   [<boundsRect],y
0763 9271 5A                    phy   
0764 9272 9B                    txy   
0765 9273 97 05                 sta   [<Ctlptr],y
0766 9275 7A                    ply   
0767 9276 CA                    dex   
0768 9277 CA                    dex   
0769 9278 88                    dey   
0770 9279 88                    dey   
0771 927A 10 F3                 bpl   lop1
0772 927C              ;
0773 927C              ;
0774 927C              ; --- Set control's flag ---------------------------------
0775 927C              ;
0776 927C A5 60                 lda   <cflag
0777 927E A0 10 00              ldy   #CtlFlag
0778 9281 97 05                 sta   [<Ctlptr],y              Store flags and hilited part.
0779 9283              ;
0780 9283              ;
0781 9283              ; --- Set control's value --------------------------------
0782 9283              ;
0783 9283 A5 5E                 lda   <value
0784 9285 A0 12 00              ldy   #CtlValue
0785 9288 97 05                 sta   [<Ctlptr],y
0786 928A              ;
0787 928A              ;
0788 928A              ; --- Set control's defProc address ----------------------
0789 928A              ;
0790 928A A5 56                 lda   <defProc
0791 928C A0 14 00              ldy   #CtlProc
0792 928F 97 05                 sta   [<Ctlptr],y
0793 9291 C8                    iny   
0794 9292 C8                    iny   
0795 9293 A5 58                 lda   <defProc+2
0796 9295 97 05                 sta   [<Ctlptr],y
0797 9297              ;
0798 9297              ;
0799 9297              ; --- Set control's title -----------------------------
0800 9297              ;
0801 9297 A5 62                 lda   <title
0802 9299 A0 1C 00              ldy   #CtlData
0803 929C 97 05                 sta   [<Ctlptr],y
0804 929E C8                    iny   
0805 929F C8                    iny   
0806 92A0 A5 64                 lda   <title+2
0807 92A2 97 05                 sta   [<Ctlptr],y
0808 92A4              ;
0809 92A4              ;
0810 92A4              ; --- Set control's reference value -------------------
0811 92A4              ;
0812 92A4 A5 52                 lda   <refCon
0813 92A6 A0 20 00              ldy   #CtlRefCon
0814 92A9 97 05                 sta   [<Ctlptr],y
0815 92AB C8                    iny   
0816 92AC C8                    iny   
0817 92AD A5 54                 lda   <refCon+2
0818 92AF 97 05                 sta   [<Ctlptr],y
0819 92B1              ;
0820 92B1              ;
0821 92B1              ; --- Set control's color table -------------------------
0822 92B1              ;
0823 92B1 A5 4E                 lda   <colortable
0824 92B3 A0 24 00              ldy   #CtlColor
0825 92B6 97 05                 sta   [<Ctlptr],y
0826 92B8 C8                    iny   
0827 92B9 C8                    iny   
0828 92BA A5 50                 lda   <colortable+2
0829 92BC 97 05                 sta   [<Ctlptr],y
0830 92BE              ;
0831 92BE              ;
0832 92BE              ; --- Ask defProc to do any further initialization ----
0833 92BE              ;
0834 92BE A5 5C                 lda   <min                     Pass min and max as Params.
0835 92C0 A4 5A                 ldy   <max
0836 92C2 A2 03 00              ldx   #initCntl
0837 92C5 20 2B 9C              jsr   CMDispatch
0838 92C8              ;
0839 92C8 A0 00 00              ldy   #0                       No error.
0840 92CB 82 CC 0D     exit     brl   CMpop32bytes
0841 92CE
0842 92CE                       ENDP 
0843 92CE
0844 92CE
0845 92CE              ;====================================================================
0846 92CE              ;
0847 92CE              ;                   DisposeControl
0848 92CE              ;
0849 92CE              ;                   Remove control from control list.
0850 92CE              ;
0851 92CE              ;   IN:    PUSH:LONG - handle of control.
0852 92CE              ;
0853 92CE              ;  OUT:  Nothing.
0854 92CE              ;
0855 92CE              ;====================================================================
0856 92CE              DisposeControl PROC 
0857 92CE
0858 92CE              theControl equ   inputs
0859 92CE
0860 92CE 20 15 A0              jsr   CMStartup                Do set up for function.
0861 92D1              ;
0862 92D1 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
0863 92D4              ;                                       ctlPtr = (ctlHand).
0864 92D4 B0 03                 bcs   exit200                  Null handle passed?
0865 92D6              ;
0866 92D6 20 07 93              jsr   dispose_guts             Dispose of control.
0867 92D9              ;                                       Return error state from dispose_guts.
0868 92D9 82 9B 0D     exit200  brl   CMpop4bytes
0869 92DC
0870 92DC
0871 92DC              ;====================================================================
0872 92DC              ;                   KillControls
0873 92DC              ;                   Remove all controls from window.
0874 92DC              ;
0875 92DC              ;   IN:    PUSH:LONG - pointer to window port.
0876 92DC              ;
0877 92DC              ;  OUT:    Nothing.
0878 92DC              ;====================================================================
0879 92DC                       ENTRY KillControls 
0880 92DC              KillControls                            ;
0881 92DC              ;
0882 92DC              deadWindow equ   inputs
0883 92DC
0884 92DC              ;-----------------------------------------------------------
0885 92DC              ;
0886 92DC              ; The window manager can call this routine when closing
0887 92DC              ; a window even when we are not active.  In the past this
0888 92DC              ; happened only when the control manager was not loaded
0889 92DC              ;
0890 92DC              ; When it is loaded, we go to system death unless this
0891 92DC              ; check is made.
0892 92DC              ;
0893 92DC              ; We return the old ToolNotfound error because the window
0894 92DC              ; manager knows how to handle that.
0895 92DC              ;
0896 92DC C9 00 00              cmp   #0                       ; see if we are active.
0897 92DF D0 0A                 bne   Yup                      ; non-zero means yes
0898 92E1 C0 00 00              cpy   #0                       ; try y-reg
0899 92E4 D0 05                 bne   Yup
0900 92E6 A9 01 00              lda   #1                       ; not active, so return tool not found error
0901 92E9 38                    sec                            ; with carry set
0902 92EA 6B                    rtl                            ; and stack untouched!!!!
0903 92EB
0904 92EB
0905 92EB
0906 92EB              Yup       
0907 92EB
0908 92EB
0909 92EB 20 15 A0              jsr   CMStartup                Do set up for function.
0910 92EE              ;
0911 92EE              ;
0912 92EE              ; --- Dispose of every control in list ---------------------
0913 92EE              ;
0914 92EE 20 82 A1     lop300   jsr   getWindptr               Get window pointer and first control.
0915 92F1 B0 E6                 bcs   exit200                  Any errors?  (y = 0 if end of list)
0916 92F3              ;
0917 92F3 A0 04 00              ldy   #CtlOwner                Force control's owner to be passed window.
0918 92F6 A5 4E                 lda   <deadWindow
0919 92F8 97 05                 sta   [<Ctlptr],y
0920 92FA C8                    iny   
0921 92FB C8                    iny   
0922 92FC A5 50                 lda   <deadWindow+2
0923 92FE 97 05                 sta   [<Ctlptr],y
0924 9300              ;
0925 9300 20 07 93              jsr   dispose_guts             Kill it.
0926 9303 90 E9                 bcc   lop300                   If no error, continue to kill list.
0927 9305 80 D2                 bra   exit200                  Return error.
0928 9307              ;
0929 9307              ;
0930 9307              ; = = = = = = = = = = = = = = = = = = = =
0931 9307              ;          Dispose control guts.
0932 9307              ; = = = = = = = = = = = = = = = = = = = =
0933 9307              ;
0934 9307              ;   IN:    <ctlhand = control's handle.
0935 9307              ;          <ctlptr = pointer to control.
0936 9307              ;
0937 9307              ;  OUT:    Carry set if error, y = error code.
0938 9307              ;          Carry clear if no error, control freed and deleted from list.
0939 9307              ;
0940 9307              dispose_guts  
0941 9307              ;
0942 9307              ;
0943 9307              ; --- Let defProc perform any disposal actions first -------------------
0944 9307              ;
0945 9307 A2 04 00              ldx   #dispCntl
0946 930A 20 2B 9C              jsr   CMDispatch
0947 930D 18                    clc                            OK flag, just in case.
0948 930E AA                    tax                            Abort disposal?
0949 930F D0 51                 bne   exit100                  Did defProc abort disposal?
0950 9311              ;
0951 9311              ;
0952 9311              ; --- Take control out of control list ---------------------------------
0953 9311              ;
0954 9311 D4 03                 pei   <Ctlhand+2               Save control's handle.
0955 9313 D4 01                 pei   <Ctlhand                 It is also passed to _DisposeHandle.
0956 9315              ;
0957 9315 20 E2 A1              jsr   dereference
0958 9318 85 2D                 sta   <work                    Save control's pointer.
0959 931A 86 2F                 stx   <work+2
0960 931C              ;
0961 931C 20 B4 A1              jsr   get_wptr                 Get window pointer from control.
0962 931F 18                    clc   
0963 9320 69 CA 00              adc   #owControls
0964 9323 90 01                 bcc   ok100
0965 9325 E8                    inx   
0966 9326 85 05        ok100    sta   <Ctlptr                  Pointer to first handle in control list.
0967 9328 86 07                 stx   <Ctlptr+2
0968 932A              ;
0969 932A A0 02 00     lop100   ldy   #2                       Get the handle of the next control.
0970 932D B7 05                 lda   [<Ctlptr],y
0971 932F AA                    tax   
0972 9330 A7 05                 lda   [<Ctlptr]
0973 9332 A8                    tay   
0974 9333              ;
0975 9333 C3 01                 cmp   1,s                      Is the next control THEE control?
0976 9335 D0 05                 bne   next100
0977 9337 8A                    txa   
0978 9338 C3 03                 cmp   3,s
0979 933A F0 14                 beq   done100
0980 933C              ;
0981 933C 84 01        next100  sty   <Ctlhand                 Store handle of next control.
0982 933E 86 03                 stx   <Ctlhand+2
0983 9340 05 01                 ora   <Ctlhand
0984 9342 D0 07                 bne   ok101
0985 9344              ;
0986 9344 68                    pla                            Remove handle from stack.
0987 9345 68                    pla   
0988 9346 38                    sec                            Return error flag, control not in list.
0989 9347 A0 03 10              ldy   #NOT_IN_LIST
0990 934A 60                    rts   
0991 934B              ;
0992 934B 20 E2 A1     ok101    jsr   dereference              Ctlptr = (Ctlhand).
0993 934E 80 DA                 bra   lop100
0994 9350              ;
0995 9350              ;
0996 9350              ; work = pointer to control to dispose.
0997 9350              ; Ctlptr = address of control previous to control in 'workptr'.
0998 9350              ;
0999 9350 A7 2D        done100  lda   [<work]                  Take THEE control out of list.
1000 9352 87 05                 sta   [<Ctlptr]
1001 9354 A0 02 00              ldy   #2
1002 9357 B7 2D                 lda   [<work],y
1003 9359 97 05                 sta   [<Ctlptr],y
1004 935B              ;
1005 935B              ;
1006 935B              ; --- Free allocated memory block used for control's record ------------
1007 935B              ;
1008 935B A2 02 10 22           _DisposeHandle                 Handle already on stack.
1009 9362              ;
1010 9362 A0 00 00     exit100  ldy   #0                       No error.
1011 9365 60                    rts   
1012 9366              ;
1013 9366                       ENDP 
1014 9366              ;
1015 9366              ;
1016 9366              ;====================================================================
1017 9366              ;
1018 9366              ;                   SetCtlIcons
1019 9366              ;
1020 9366              ;                   Swap Control Manager Icon Font.
1021 9366              ;
1022 9366              ;   IN:    PUSH:LONG - handle of new icon font, negative for none.
1023 9366              ;
1024 9366              ;  OUT:    LONG - current (before swap) icon font.
1025 9366              ;
1026 9366              ;====================================================================
1027 9366              SetCtlIcons PROC 
1028 9366
1029 9366              newFont  equ   inputs
1030 9366              oldFont  equ   newFont+4
1031 9366              ;
1032 9366              ;
1033 9366 20 15 A0              jsr   CMStartup                Do tool function setup.
1034 9369              ;
1035 9369              ;
1036 9369              ; --- Return font before change --------------------------------------
1037 9369              ;
1038 9369 20 18 A1              jsr   pushVctl_font            Push current font on stack.
1039 936C 68                    pla                            Return current font.
1040 936D 85 52                 sta   <oldFont
1041 936F 68                    pla   
1042 9370 85 54                 sta   <oldFont+2
1043 9372              ;
1044 9372              ;
1045 9372              ; --- Change current font --------------------------------------------
1046 9372              ;
1047 9372 A6 50                 ldx   <newFont+2               Use new font?
1048 9374 30 05                 bmi   exit2
1049 9376              ;
1050 9376 A5 4E                 lda   <newFont
1051 9378 20 69 9F              jsr   SetIconFont
1052 937B              ;
1053 937B A0 00 00     exit2    ldy   #0                       No error flag.
1054 937E 82 F6 0C              brl   CMpop4bytes
1055 9381
1056 9381                       ENDP 
1057 9381
1058 9381
1059 9381              ;====================================================================
1060 9381              ;
1061 9381              ;                   SetCtlTitle
1062 9381              ;
1063 9381              ;                   Set new title in control.
1064 9381              ;
1065 9381              ;   IN:    PUSH:LONG - pointer to title string.
1066 9381              ;          PUSH:LONG - handle of control.
1067 9381              ;
1068 9381              ;  OUT:    Nothing.
1069 9381              ;
1070 9381              ;====================================================================
1071 9381              SetCtlTitle PROC 
1072 9381
1073 9381              CtlHandle equ   inputs
1074 9381              title    equ   CtlHandle+4
1075 9381              ;
1076 9381              ;
1077 9381 20 15 A0              jsr   CMStartup                Do tool function setup.
1078 9384              ;
1079 9384 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1080 9387              ;                                       ctlPtr = (ctlHand).
1081 9387 B0 19                 bcs   exit                     Null handle passed?
1082 9389              ;
1083 9389 A0 1C 00              ldy   #CtlData                 Replace the control's CtlData field.
1084 938C A5 52                 lda   <title
1085 938E 97 05                 sta   [<Ctlptr],y
1086 9390 C8                    iny   
1087 9391 C8                    iny   
1088 9392 A5 54                 lda   <title+2
1089 9394 97 05                 sta   [<Ctlptr],y
1090 9396              ;
1091 9396 20 DF 96              jsr   set2draw                 Setup to draw.
1092 9399              ;
1093 9399 20 AF 9E              jsr   pushPort                 Save the current port.
1094 939C 20 22 97              jsr   drawWholeCtl             Draw the control.
1095 939F 20 C9 9E              jsr   popPort                  Restore the current port.
1096 93A2              ;
1097 93A2 A0 00 00     exit     ldy   #0                       No error flag.
1098 93A5 82 D9 0C              brl   CMpop8bytes
1099 93A8
1100 93A8                       ENDP 
1101 93A8
1102 93A8
1103 93A8              ;====================================================================
1104 93A8              ;
1105 93A8              ;                   GetCtlTitle
1106 93A8              ;
1107 93A8              ;                   Read title from control.
1108 93A8              ;
1109 93A8              ;   IN:    PUSH:LONG - handle of control.
1110 93A8              ;
1111 93A8              ;  OUT:    LONG - value in CtlData field of control record.
1112 93A8              ;
1113 93A8              ;====================================================================
1114 93A8              GetCtlTitle PROC 
1115 93A8
1116 93A8              CtlHandle equ   inputs
1117 93A8              title_des equ   CtlHandle+4
1118 93A8              ;
1119 93A8              ;
1120 93A8 20 15 A0              jsr   CMStartup                Do tool function setup.
1121 93AB              ;
1122 93AB 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1123 93AE              ;                                       ctlPtr = (ctlHand).
1124 93AE B0 0D                 bcs   exit                     Null handle passed?
1125 93B0              ;
1126 93B0 A0 1C 00              ldy   #CtlData                 Get pointer to control's title.
1127 93B3 B7 05                 lda   [<Ctlptr],y
1128 93B5 85 52                 sta   <title_des
1129 93B7 C8                    iny   
1130 93B8 C8                    iny   
1131 93B9 B7 05                 lda   [<Ctlptr],y
1132 93BB 85 54                 sta   <title_des+2
1133 93BD              ;
1134 93BD A0 00 00     exit     ldy   #0                       No error.
1135 93C0 82 B4 0C              brl   CMpop4bytes
1136 93C3
1137 93C3                       ENDP 
1138 93C3
1139 93C3
1140 93C3              ;====================================================================
1141 93C3              ;
1142 93C3              ;                   SetCtlValue
1143 93C3              ;
1144 93C3              ;                   Set control's value.
1145 93C3              ;
1146 93C3              ;   IN:  PUSH:WORD - control's new value, 1 to select buttons and check boxes.
1147 93C3              ;        PUSH:LONG - handle of control.
1148 93C3              ;
1149 93C3              ;  OUT:  Nothing.
1150 93C3              ;
1151 93C3              ;====================================================================
1152 93C3              SetCtlValue PROC 
1153 93C3
1154 93C3              CtlHandle equ   inputs
1155 93C3              NewVal   equ   CtlHandle+4
1156 93C3              ;
1157 93C3              ;
1158 93C3 20 15 A0              jsr   CMStartup                Do tool function setup.
1159 93C6              ;
1160 93C6 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1161 93C9              ;                                       ctlPtr = (ctlHand).
1162 93C9 B0 25                 bcs   exit                     Null handle passed?
1163 93CB              ;
1164 93CB              ;
1165 93CB              ; --- Set the value ----------------------------------
1166 93CB              ;
1167 93CB A0 12 00              ldy   #CtlValue
1168 93CE B7 05                 lda   [<ctlptr],y
1169 93D0 C5 52                 cmp   <NewVal
1170 93D2 F0 1C                 beq   exit                     Nothing to do if already set.
1171 93D4 85 2D                 sta   <work                    Remember old value.
1172 93D6              ;
1173 93D6 A5 52                 lda   <NewVal
1174 93D8 97 05                 sta   [<Ctlptr],y              Set new value.
1175 93DA              ;
1176 93DA              ;
1177 93DA              ; --- Tell defProc there's a new value (draws control) ------------
1178 93DA              ;
1179 93DA 20 DF 96              jsr   set2draw                 Setup to draw standard controls.
1180 93DD 20 AF 9E              jsr   pushPort                 Save the current port.
1181 93E0 20 95 97              jsr   set2drawCtl              Setup to draw the control.
1182 93E3              ;
1183 93E3 A4 2D                 ldy   <work                    Pass old value in param+2.
1184 93E5 A5 52                 lda   <NewVal                  Pass new value in param.
1185 93E7 A2 09 00              ldx   #newValue                Call defProc about new value.
1186 93EA 20 2B 9C              jsr   CMDispatch
1187 93ED 20 C9 9E              jsr   popPort                  Restore the current port.
1188 93F0              ;
1189 93F0 A0 00 00     exit     ldy   #0                       No error flag.
1190 93F3 82 86 0C              brl   CMpop6bytes
1191 93F6
1192 93F6                       ENDP 
1193 93F6
1194 93F6
1195 93F6              ;====================================================================
1196 93F6              ;
1197 93F6              ;                   GetCtlValue
1198 93F6              ;
1199 93F6              ;                   Get control's value.
1200 93F6              ;
1201 93F6              ;   IN:  PUSH:LONG - pointer to control.
1202 93F6              ;
1203 93F6              ;  OUT:  WORD - control's current value.
1204 93F6              ;
1205 93F6              ;====================================================================
1206 93F6              GetCtlValue PROC 
1207 93F6
1208 93F6              CtlHandle equ   inputs
1209 93F6              RetValue equ   CtlHandle+4
1210 93F6              ;
1211 93F6
1212 93F6 20 15 A0              jsr   CMStartup                Do tool function setup.
1213 93F9              ;
1214 93F9 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1215 93FC              ;                                       ctlPtr = (ctlHand).
1216 93FC B0 07                 bcs   exit                     Null handle passed?
1217 93FE              ;
1218 93FE A0 12 00              ldy   #CtlValue
1219 9401 B7 05                 lda   [<Ctlptr],y
1220 9403 85 52                 sta   <RetValue
1221 9405              ;
1222 9405 A0 00 00     exit     ldy   #0                       No error flag.
1223 9408 82 6C 0C              brl   CMpop4bytes
1224 940B
1225 940B                       ENDP 
1226 940B
1227 940B
1228 940B              ;====================================================================
1229 940B              ;
1230 940B              ;                   SetCtlParam
1231 940B              ;
1232 940B              ;                   Set control's minimum and maximum values.
1233 940B              ;
1234 940B              ;   IN:  PUSH:WORD - maximum value, $FFFF don't set.
1235 940B              ;        PUSH:WORD - minimum value, $FFFF don't set.
1236 940B              ;        PUSH:LONG - handle of control.
1237 940B              ;
1238 940B              ;              For scroll bars:         CtlData = minimum.
1239 940B              ;                                       CtlData+2 = maximum.
1240 940B              ;  OUT:  Nothing.
1241 940B              ;
1242 940B              ;====================================================================
1243 940B              SetCtlParam PROC 
1244 940B
1245 940B              CtlHandle equ   inputs
1246 940B              view     equ   CtlHandle+4
1247 940B              dataSize equ   view+2
1248 940B              ;
1249 940B              ;
1250 940B 20 15 A0              jsr   CMStartup                Do tool function setup.
1251 940E              ;
1252 940E 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1253 9411              ;                                       ctlPtr = (ctlHand).
1254 9411 B0 16                 bcs   exit                     Null handle passed?
1255 9413              ;
1256 9413              ;
1257 9413              ; --- Tell defProc there's a new params (may draw control) ------------
1258 9413              ;
1259 9413 20 DF 96              jsr   set2draw                 Setup to draw standard controls.
1260 9416 20 AF 9E              jsr   pushPort                 Save the current port.
1261 9419 20 95 97              jsr   set2drawCtl              Setup to draw the control.
1262 941C              ;
1263 941C A5 52                 lda   <view                    Pass new view and data sizes.
1264 941E A4 54                 ldy   <dataSize
1265 9420 A2 0A 00              ldx   #setParams               Task number.
1266 9423 20 2B 9C              jsr   CMDispatch
1267 9426 20 C9 9E              jsr   popPort                  Restore the current port.
1268 9429              ;
1269 9429 A0 00 00     exit     ldy   #0                       No error flag.
1270 942C 82 52 0C              brl   CMpop8bytes
1271 942F
1272 942F                       ENDP 
1273 942F
1274 942F
1275 942F              ;====================================================================
1276 942F              ;
1277 942F              ;                   GetCtlParam
1278 942F              ;
1279 942F              ;                   Get control's minimum and maximum values.
1280 942F              ;
1281 942F              ;   IN:  PUSH:LONG - pointer to control.
1282 942F              ;
1283 942F              ;  OUT:  LONG - minimum value in high word, maximum value in low word.
1284 942F              ;
1285 942F              ;              For scroll bars:         minimum = ScrollView.
1286 942F              ;                                       maximum = ScrollMax.
1287 942F              ;
1288 942F              ;====================================================================
1289 942F              GetCtlParam PROC 
1290 942F
1291 942F              CtlHandle equ   inputs
1292 942F              RetMax   equ   CtlHandle+4
1293 942F              RetMin   equ   RetMax+2
1294 942F              ;
1295 942F              ;
1296 942F 20 15 A0              jsr   CMStartup                Do tool function setup.
1297 9432              ;
1298 9432 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1299 9435              ;                                       ctlPtr = (ctlHand).
1300 9435 B0 0D                 bcs   exit                     Null handle passed?
1301 9437              ;
1302 9437 A0 1E 00              ldy   #CtlData+2
1303 943A B7 05                 lda   [<Ctlptr],y
1304 943C 85 52                 sta   <RetMax
1305 943E 88                    dey   
1306 943F 88                    dey   
1307 9440 B7 05                 lda   [<Ctlptr],y
1308 9442 85 54                 sta   <RetMin
1309 9444              ;
1310 9444 A0 00 00     exit     ldy   #0                       No error flag.
1311 9447 82 2D 0C              brl   CMpop4bytes
1312 944A
1313 944A                       ENDP 
1314 944A
1315 944A
1316 944A              ;====================================================================
1317 944A              ;
1318 944A              ;                   GetCtlZPage
1319 944A              ;
1320 944A              ;                   Return Control Manager's zero page.
1321 944A              ;
1322 944A              ;   IN:  None.
1323 944A              ;
1324 944A              ;  OUT:  WORD - Control Manager's direct page.
1325 944A              ;
1326 944A              ;====================================================================
1327 944A              GetCtlzpage PROC 
1328 944A
1329 944A              result   equ   inputs
1330 944A              ;
1331 944A              ;
1332 944A 20 15 A0              jsr   CMStartup
1333 944D              ;
1334 944D A0 38 00              ldy   #MyDPage                 Return Control Manager's zero page.
1335 9450 B7 41                 lda   [<data],y
1336 9452 85 4E                 sta   <result
1337 9454              ;
1338 9454 A0 00 00              ldy   #0                       No error flag.
1339 9457 82 18 0C              brl   CMpop0bytes
1340 945A
1341 945A                       ENDP 
1342 945A
1343 945A
1344 945A              ;====================================================================
1345 945A              ;
1346 945A              ;                   SetCtlAction
1347 945A              ;
1348 945A              ;                   Set CtlAction field in control.
1349 945A              ;
1350 945A              ;   IN:    PUSH:LONG - value to place in CtlAction field.
1351 945A              ;          PUSH:LONG - handle of control.
1352 945A              ;
1353 945A              ;  OUT:    Nothing.
1354 945A              ;
1355 945A              ;====================================================================
1356 945A              SetCtlAction PROC 
1357 945A
1358 945A 20 15 A0              jsr   CMStartup                Do tool function setup.
1359 945D              ;
1360 945D 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1361 9460              ;                                       ctlPtr = (ctlHand).
1362 9460 B0 2A                 bcs   errorOut8                Null handle passed?
1363 9462              ;
1364 9462 A0 18 00              ldy   #CtlAction
1365 9465 80 18                 bra   set_long
1366 9467
1367 9467                       ENDP 
1368 9467
1369 9467
1370 9467              ;====================================================================
1371 9467              ;
1372 9467              ;                   GetCtlAction
1373 9467              ;
1374 9467              ;                   Return CtlAction field in control.
1375 9467              ;
1376 9467              ;   IN:    PUSH:LONG - handle of control.
1377 9467              ;
1378 9467              ;  OUT:    PUSH:LONG - value of CtlAction field.
1379 9467              ;
1380 9467              ;550=================================================================
1381 9467              GetCtlAction PROC 
1382 9467
1383 9467 20 15 A0              jsr   CMStartup                Do tool function setup.
1384 946A              ;
1385 946A 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1386 946D              ;                                       ctlPtr = (ctlHand).
1387 946D B0 38                 bcs   errorOut4                Null handle passed?
1388 946F              ;
1389 946F A0 18 00              ldy   #CtlAction
1390 9472 80 26                 bra   get_long
1391 9474
1392 9474                       ENDP 
1393 9474
1394 9474
1395 9474              ;====================================================================
1396 9474              ;
1397 9474              ;                   SetCtlRefCon
1398 9474              ;
1399 9474              ;                   Set CtlRefCon field in control.
1400 9474              ;
1401 9474              ;   IN:    PUSH:LONG - value to place in CtlRefCon field.
1402 9474              ;          PUSH:LONG - handle of control.
1403 9474              ;
1404 9474              ;  OUT:    Nothing.
1405 9474              ;
1406 9474              ;600=================================================================
1407 9474              SetCtlRefCon PROC 
1408 9474
1409 9474 20 15 A0              jsr   CMStartup                Do tool function setup.
1410 9477              ;
1411 9477 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1412 947A              ;                                       ctlPtr = (ctlHand).
1413 947A B0 0D                 bcs   exit                     Null handle passed?
1414 947C              ;
1415 947C A0 20 00              ldy   #CtlRefCon
1416 947F
1417 947F              ;
1418 947F              ; = = = = = = = = = = = = = = = = = = = = = = =
1419 947F              ;          Set a LONG field in
1420 947F              ;          a control record.
1421 947F              ; = = = = = = = = = = = = = = = = = = = = = = =
1422 947F              ;
1423 947F              secondParam equ   inputs+4
1424 947F              ;
1425 947F                       EXPORT set_long 
1426 947F              set_long                                ;
1427 947F              ;
1428 947F A5 52                 lda   <secondParam
1429 9481 97 05                 sta   [<Ctlptr],y
1430 9483 C8                    iny   
1431 9484 C8                    iny   
1432 9485 A5 54                 lda   <secondParam+2
1433 9487 97 05                 sta   [<Ctlptr],y
1434 9489              ;
1435 9489 A0 00 00     exit     ldy   #0                       No error flag.
1436 948C                       ENTRY errorOut8 
1437 948C              errorOut8                               ;       
1438 948C 82 F2 0B              brl   CMpop8bytes
1439 948F
1440 948F                       ENDP 
1441 948F
1442 948F
1443 948F              ;====================================================================
1444 948F              ;
1445 948F              ;                   GetCtlRefCon
1446 948F              ;
1447 948F              ;                   Return CtlRefCon field in control.
1448 948F              ;
1449 948F              ;   IN:    PUSH:LONG - handle of control.
1450 948F              ;
1451 948F              ;  OUT:    PUSH:LONG - value of CtlRefCon field.
1452 948F              ;
1453 948F              ;650=================================================================
1454 948F              GetCtlRefCon PROC 
1455 948F
1456 948F 20 15 A0              jsr   CMStartup                Do tool function setup.
1457 9492              ;
1458 9492 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1459 9495              ;                                       ctlPtr = (ctlHand).
1460 9495 B0 0D                 bcs   exit                     Null handle passed?
1461 9497              ;
1462 9497 A0 20 00              ldy   #CtlRefCon
1463 949A              ;
1464 949A              ;
1465 949A              ; = = = = = = = = = = = = = = = = = = = = = = =
1466 949A              ;          Return a LONG field
1467 949A              ;          from a control record.
1468 949A              ; = = = = = = = = = = = = = = = = = = = = = = =
1469 949A              ;
1470 949A              returnParam equ   inputs+4
1471 949A              ;
1472 949A                       EXPORT get_long 
1473 949A              get_long                                ;       
1474 949A              ;
1475 949A B7 05                 lda   [<Ctlptr],y
1476 949C 85 52                 sta   <returnParam
1477 949E C8                    iny   
1478 949F C8                    iny   
1479 94A0 B7 05                 lda   [<Ctlptr],y
1480 94A2 85 54                 sta   <returnParam+2
1481 94A4              ;
1482 94A4 A0 00 00     exit     ldy   #0                       No error flag.
1483 94A7                       ENTRY errorOut4 
1484 94A7              errorOut4                               ;       
1485 94A7 82 CD 0B              brl   CMpop4bytes
1486 94AA
1487 94AA                       ENDP 
1488 94AA
1489 94AA
1490 94AA              ;====================================================================
1491 94AA              ;
1492 94AA              ;                   HiliteControl
1493 94AA              ;
1494 94AA              ;                   Highlight/Unhighlight a control.
1495 94AA              ;
1496 94AA              ;   IN:    PUSH:WORD -     0 = unhighlight last highlighted part, or draw control.
1497 94AA              ;                      1-253 = part to be highlighted.
1498 94AA              ;                        255 = make control inactive.
1499 94AA              ;          PUSH:LONG - pointer to control.
1500 94AA              ;          Current port must be control's window port.
1501 94AA              ;
1502 94AA              ;  OUT:  Nothing.
1503 94AA              ;
1504 94AA              ;====================================================================
1505 94AA              HiliteControl PROC 
1506 94AA
1507 94AA              control  equ   inputs
1508 94AA              newstate equ   control+4
1509 94AA              ;
1510 94AA              ;
1511 94AA 20 15 A0              jsr   CMStartup                Do tool function setup.
1512 94AD              ;
1513 94AD 20 9F A1              jsr   getCtlHand               ctlHand = passed control handle.
1514 94B0              ;                                       ctlPtr = (ctlHand).
1515 94B0 B0 2A                 bcs   exit                     Null handle passed?
1516 94B2              ;
1517 94B2              ;
1518 94B2              ; --- Set new highlight flag ---------------------
1519 94B2              ;
1520 94B2 A0 11 00              ldy   #CtlHilite
1521 94B5 B7 05                 lda   [<Ctlptr],y
1522 94B7 29 FF 00              and   #$00FF                   Get last highlighted part,
1523 94BA 85 29                 sta   <param                   and store as possible part to draw.
1524 94BC C5 52                 cmp   <newstate                Is old hilite same as new?
1525 94BE F0 1C                 beq   exit                     If the same, no need to draw.
1526 94C0              ;
1527 94C0 C9 FF 00              cmp   #C_HILITE                Was the control inactive?
1528 94C3 D0 02                 bne   ok1
1529 94C5 64 29                 stz   <param                   If yes, draw whole control.
1530 94C7              ;
1531 94C7 B7 05        ok1      lda   [<Ctlptr],y
1532 94C9 29 00 FF              and   #$FF00                   Mask off present flags.
1533 94CC 05 52                 ora   <newstate                Set new highlight flag.
1534 94CE 97 05                 sta   [<Ctlptr],y              Put into control's record.
1535 94D0              ;
1536 94D0              ;
1537 94D0              ; --- Draw new state -----------------------------
1538 94D0              ;
1539 94D0 20 DF 96              jsr   set2draw                 Setup to draw control.
1540 94D3 20 AF 9E              jsr   pushPort                 Save the current port.
1541 94D6 20 24 97              jsr   drawCtl                  Draw the control.
1542 94D9 20 C9 9E              jsr   popPort                  Restore the current port.
1543 94DC              ;
1544 94DC A0 00 00     exit     ldy   #0                       No error flag.
1545 94DF 82 9A 0B              brl   CMpop6bytes
1546 94E2
1547 94E2                       ENDP 
1548 94E2
1549 94E2
1550 94E2              ;====================================================================
1551 94E2              ;
1552 94E2              ;                   HideControl
1553 94E2              ;
1554 94E2              ;                   Make a control invisible.
1555 94E2              ;
1556 94E2              ;   IN:    PUSH:LONG - handle of control to hide.
1557 94E2              ;          Current port must be control's window port.
1558 94E2              ;
1559 94E2              ;  OUT:    Nothing.
1560 94E2              ;
1561 94E2              ;
1562 94E2              ; Change History
1563 94E2              ;
1564 94E2              ; 10 Feb 89         Yee
1565 94E2              ;
1566 94E2              ; Added code to send erase message to multipart controls
1567 94E2              ;
1568 94E2              ; 13 Feb 89         Steven Glass
1569 94E2              ;
1570 94E2              ; Fixed y-reg for old style controls
1571 94E2              ;
1572 94E2              ;
1573 94E2              ; 28 Mar 89         Dave Good
1574 94E2              ;
1575 94E2              ; cleanedup the code a little and saved a few bytes
1576 94E2              ;
1577 94E2              ;====================================================================
1578 94E2              Ctrl12Proc PROC 
1579 94E2
1580 94E2              ;---------------------------------------------------------------
1581 94E2                       ENTRY  HideControl 
1582 94E2                       ENTRY  EraseControl 
1583 94E2              ;---------------------------------------------------------------
1584 94E2
1585 94E2              ;---------------------------------------------------------------
1586 94E2              tempEraseFlag equ    1
1587 94E2              ;---------------------------------------------------------------
1588 94E2
1589 94E2              ;---------------------------------------------------------------
1590 94E2 20 15 A0     HideControl jsr    CMStartup            ;call the common startup routine
1591 94E5
1592 94E5 A9 00 00              lda    #0                      ;add to the update region
1593 94E8 80 06                 bra    common
1594 94EA              ;---------------------------------------------------------------
1595 94EA 20 15 A0     EraseControl jsr    CMStartup           ;call the common startup routine
1596 94ED
1597 94ED A9 01 00              lda    #1                      ;don't add to the update region
1598 94F0              ;---------------------------------------------------------------
1599 94F0 48           common   pha                            ;save the eraseFlag on the stack
1600 94F1
1601 94F1 20 9F A1              jsr    getCtlHand              ;get and deref the passed control handle
1602 94F4 B0 62                 bcs    exit                    ;if a NULL handle was passed, then exit
1603 94F6
1604 94F6 A0 10 00              ldy    #CtlFlag                ;if the control is already invisible, then
1605 94F9 B7 05                 lda    [<Ctlptr],y             ;..exit
1606 94FB 29 80 00              and    #Ctl_INVIS
1607 94FE D0 58                 bne    exit
1608 9500
1609 9500 B7 05                 lda    [<Ctlptr],y             ;mark the control as invisible
1610 9502 09 80 00              ora    #Ctl_INVIS
1611 9505 97 05                 sta    [<Ctlptr],y
1612 9507              ;---------------------------------------------------------------
1613 9507 A0 16 00              ldy    #NewCtlRecord.CtlProc+2 ;is this a super control ? If not, then
1614 950A B7 05                 lda    [<Ctlptr],y             ;..we never need to notify this ctrl
1615 950C 10 15                 bpl    skipNotify
1616 950E
1617 950E A0 3C 00              ldy    #NewCtlRecord.ctlMoreFlags ;does this defProc want this message ?
1618 9511 B7 05                 lda    [<Ctlptr],y
1619 9513 29 00 04              and    #fCtlIsMultiPart
1620 9516 F0 0B                 beq    skipNotify
1621 9518
1622 9518 A3 01                 lda    tempEraseFlag,s
1623 951A A0 00 00              ldy    #0
1624 951D A2 12 00              ldx    #ctlNotifyMultiPart
1625 9520 20 2B 9C              jsr    CMDispatch
1626 9523              skipNotify  
1627 9523              ;---------------------------------------------------------------
1628 9523 20 CD A1              jsr    to_wport                ;switch to control's window port.
1629 9526 20 2C A4              jsr    CMsetrect               ;'rect' = control's enclosing RECT.
1630 9529
1631 9529 A0 14 00              ldy    #ctlProc                ;is the control a simple button ? If not
1632 952C B7 05                 lda    [<ctlptr],y             ;..then don't expand the rect
1633 952E C8                    iny   
1634 952F 17 05                 ora    [<ctlptr],y
1635 9531 D0 0D                 bne    @skipButton
1636 9533 A0 10 00              ldy    #CtlFlag                ;does the button need it's rect expanded ?
1637 9536 B7 05                 lda    [<ctlptr],y             ;..nope = skip expand
1638 9538 29 01 00              and    #1
1639 953B F0 03                 beq    @skipButton
1640 953D
1641 953D 20 4F AB              jsr    expandButt              ;expand 'rect' to include bold.
1642 9540              @skipButton  
1643 9540 20 72 A1              jsr    pushrect                ;erase the control
1644 9543 A2 04 55 22           _EraseRect 
1645 954A
1646 954A A3 01                 lda    tempEraseFlag,s         ;do we need to invalidate the control ?
1647 954C D0 0A                 bne    @skipInval
1648 954E 20 72 A1              jsr    pushrect                ;invalidate the control
1649 9551 A2 0E 3A 22           _InvalRect 
1650 9558              @skipInval  
1651 9558              ;---------------------------------------------------------------
1652 9558 68           exit     pla                            ;pull off the erase flag
1653 9559 A0 00 00              ldy    #0                      ;return no error
1654 955C 82 18 0B              brl    CMpop4bytes
1655 955F              ;---------------------------------------------------------------
1656 955F
1657 955F                       ENDP 
1658 955F
1659 955F
1660 955F              ;====================================================================
1661 955F              ;
1662 955F              ;                   ShowControl & DrawOneCtl
1663 955F              ;
1664 955F              ;                   Make a control visible.
1665 955F              ;
1666 955F              ;   IN:    PUSH:LONG - handle of control to make visible (or draw).
1667 955F              ;          Current port must be control's window port.
1668 955F              ;
1669 955F              ;  OUT:    Nothing.
1670 955F              ;
1671 955F              ;
1672 955F              ; Change History
1673 955F              ;
1674 955F              ; 28 Mar 89         Dave Good
1675 955F              ;
1676 955F              ; Combined show and draw one control to save space. Also made both of them
1677 955F              ; call the defProc for multi part controls.
1678 955F              ;
1679 955F              ;====================================================================
1680 955F              Ctrl2Proc PROC 
1681 955F
1682 955F              ;---------------------------------------------------------------
1683 955F                       ENTRY  DrawOneCtl 
1684 955F                       ENTRY  ShowControl 
1685 955F              ;---------------------------------------------------------------
1686 955F
1687 955F              ;---------------------------------------------------------------
1688 955F 20 15 A0     DrawOneCtl jsr    CMStartup             ;call the common startup routine
1689 9562
1690 9562 20 9F A1              jsr    getCtlHand              ;get and deref the passed control handle
1691 9565 B0 48                 bcs    exit                    ;if a NULL handle was passed, then exit
1692 9567
1693 9567 A2 03 00              ldx    #3
1694 956A 80 1C                 bra    drawIt
1695 956C              ;---------------------------------------------------------------
1696 956C 20 15 A0     ShowControl jsr    CMStartup            ;call the common startup routine
1697 956F
1698 956F 20 9F A1              jsr    getCtlHand              ;get and deref the passed control handle
1699 9572 B0 3B                 bcs    exit                    ;if a NULL handle was passed, then exit
1700 9574
1701 9574 A0 10 00              ldy    #CtlFlag                ;if the control is already visible then
1702 9577 B7 05                 lda    [<Ctlptr],y             ;..exit
1703 9579 29 80 00              and    #Ctl_INVIS
1704 957C F0 31                 beq    exit
1705 957E
1706 957E B7 05                 lda    [<Ctlptr],y             ;it was not visible before, so make it
1707 9580 29 7F FF              and    #$FF7F                  ;..visible
1708 9583 97 05                 sta    [<Ctlptr],y
1709 9585
1710 9585 A2 02 00              ldx    #2                      ;this is what param to send
1711 9588              ;---------------------------------------------------------------
1712 9588 A0 16 00     drawIt   ldy    #NewCtlRecord.CtlProc+2 ;is this a super control ? If not, then
1713 958B B7 05                 lda    [<Ctlptr],y             ;..we never need to notify this ctrl
1714 958D 10 14                 bpl    skipNotify
1715 958F
1716 958F A0 3C 00              ldy    #NewCtlRecord.ctlMoreFlags ;does this defProc want this message ?
1717 9592 B7 05                 lda    [<Ctlptr],y
1718 9594 29 00 04              and    #fCtlIsMultiPart
1719 9597 F0 0A                 beq    skipNotify
1720 9599
1721 9599 8A                    txa                            ;this tells the defproc to show the
1722 959A A0 00 00              ldy    #0                      ;..control
1723 959D A2 12 00              ldx    #ctlNotifyMultiPart
1724 95A0 20 2B 9C              jsr    CMDispatch
1725 95A3              skipNotify  
1726 95A3              ;---------------------------------------------------------------
1727 95A3 20 DF 96              jsr    set2draw                ;setup to draw control.
1728 95A6 20 AF 9E              jsr    pushPort                ;save the current port.
1729 95A9 20 22 97              jsr    drawWholeCtl            ;draw the control.
1730 95AC 20 C9 9E              jsr    popPort                 ;restore the current port.
1731 95AF
1732 95AF A0 00 00     exit     ldy    #0                      ;no error flag.
1733 95B2 82 C2 0A              brl    CMpop4bytes
1734 95B5              ;---------------------------------------------------------------
1735 95B5
1736 95B5                       ENDP 
1737 95B5
1738 95B5
1739 95B5              ;====================================================================
1740 95B5              ;
1741 95B5              ;                   DrawControls
1742 95B5              ;
1743 95B5              ;                   Draw control list.
1744 95B5              ;
1745 95B5              ;   IN:    PUSH:LONG - pointer to window.
1746 95B5              ;
1747 95B5              ;  OUT:    Nothing.
1748 95B5              ;
1749 95B5              ;          Will just exit if a null window pointer passed or no controls
1750 95B5              ;          in window's control list.
1751 95B5              ;
1752 95B5              ;====================================================================
1753 95B5              DrawControls PROC 
1754 95B5
1755 95B5              window   equ   inputs
1756 95B5              count    equ   window+4
1757 95B5              ;
1758 95B5              yoffset  equ   work
1759 95B5              xoffset  equ   yoffset+2
1760 95B5              ;
1761 95B5              ;
1762 95B5 20 15 A0              jsr   CMStartup                Do tool function setup.
1763 95B8              ;
1764 95B8 20 82 A1              jsr   getWindPtr               Get given window pointer.
1765 95BB B0 1E                 bcs   exit                     Any errors?
1766 95BD              ;
1767 95BD A0 D2 00              ldy   #owFrame                 Is window visible?
1768 95C0 B7 09                 lda   [<windptr],y
1769 95C2 29 20 00              and   #F_VIS
1770 95C5 F0 14                 beq   exit                     Nothing to draw if invisible.
1771 95C7              ;
1772 95C7 20 DF 96              jsr   set2draw                 Switch to CtlOwner port, get visBounds.
1773 95CA 20 AF 9E              jsr   pushPort                 Save the current port.
1774 95CD              ;
1775 95CD              ;
1776 95CD              ; --- Draw all the controls in the list --------------
1777 95CD              ;
1778 95CD 20 22 97     lop1     jsr   drawWholeCtl             Do standard setups, and draw control.
1779 95D0              ;
1780 95D0 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1781 95D3              ;
1782 95D3 20 7C A3              jsr   next_Ctl                 Get pointer to next control.
1783 95D6 D0 F5                 bne   lop1                     Any more controls?
1784 95D8              ;
1785 95D8 20 C9 9E              jsr   popPort                  Restore the current port.
1786 95DB              ;
1787 95DB A0 00 00     exit     ldy   #0                       No error flag.
1788 95DE 82 96 0A              brl   CMpop4bytes
1789 95E1
1790 95E1                       ENDP 
1791 95E1
1792 95E1
1793 95E1              ;====================================================================
1794 95E1              ;
1795 95E1              ;                   InvalCtls
1796 95E1              ;
1797 95E1              ;                   Invalidates bound rects of the controls in the window
1798 95E1              ;
1799 95E1              ;   IN:    PUSH:LONG - pointer to window.
1800 95E1              ;
1801 95E1              ;  OUT:    Nothing.
1802 95E1              ;
1803 95E1              ;          Will just exit if a null window pointer passed or no controls
1804 95E1              ;          in window's control list.
1805 95E1              ;
1806 95E1              ;====================================================================
1807 95E1              InvalCtls  PROC 
1808 95E1
1809 95E1              window   equ   inputs
1810 95E1              ;
1811 95E1              ;
1812 95E1 20 15 A0              jsr   CMStartup                Do tool function setup.
1813 95E4              ;
1814 95E4 20 82 A1              jsr   getWindPtr               Get given window pointer.
1815 95E7 B0 67                 bcs   exit                     Any errors?
1816 95E9              ;
1817 95E9 A0 D2 00              ldy   #owFrame                 Is window visible?
1818 95EC B7 09                 lda   [<windptr],y
1819 95EE 29 20 00              and   #F_VIS
1820 95F1 F0 5D                 beq   exit                     Nothing to do if invisible.
1821 95F3
1822 95F3 48                    pha   
1823 95F4 48                    pha   
1824 95F5 A2 04 1C 22           _GetPort 
1825 95FC
1826 95FC D4 50                 pei   Window+2
1827 95FE D4 4E                 pei   Window
1828 9600 A2 04 1B 22           _SetPort 
1829 9607
1830 9607 48                    pha   
1831 9608 48                    pha   
1832 9609 48                    pha   
1833 960A 48                    pha   
1834 960B 3B                    tsc   
1835 960C 1A                    inc   a
1836 960D F4 00 00              pea   0
1837 9610 48                    pha   
1838 9611 A2 04 20 22           _GetPortRect 
1839 9618
1840 9618 D4 50                 pei   Window+2
1841 961A D4 4E                 pei   Window
1842 961C A2 0E 4D 22           _StartDrawing 
1843 9623
1844 9623
1845 9623              ;
1846 9623              ;
1847 9623              ; --- Invalidate all the controls in the list --------------
1848 9623              ;
1849 9623 A5 05        lop1     lda   ctlPtr
1850 9625 18                    clc   
1851 9626 69 08 00              adc   #NewCtlRecord.ctlRect
1852 9629 AA                    tax   
1853 962A A5 07                 lda   ctlPtr+2
1854 962C 69 00 00              adc   #0
1855 962F 48                    pha   
1856 9630 DA                    phx   
1857 9631 A2 0E 3A 22           _InvalRect 
1858 9638              ;
1859 9638 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1860 963B              ;
1861 963B 20 7C A3              jsr   next_Ctl                 Get pointer to next control.
1862 963E D0 E3                 bne   lop1                     Any more controls?
1863 9640
1864 9640 A2 04 23 22           _SetOrigin 
1865 9647 68                    pla   
1866 9648 68                    pla   
1867 9649              ;
1868 9649 A2 04 1B 22           _SetPort                       Restore orig port.
1869 9650              ;
1870 9650 A0 00 00     exit     ldy   #0                       No error flag.
1871 9653 82 21 0A              brl   CMpop4bytes
1872 9656
1873 9656                       ENDP 
1874 9656
1875 9656
1876 9656              ;====================================================================
1877 9656              ;
1878 9656              ;                   FutzCtls
1879 9656              ;
1880 9656              ; Invalidates bound rects of normal controls in the window and
1881 9656              ; sends message to other controls telling that window state has
1882 9656              ; changed.
1883 9656              ;
1884 9656              ; This call is supposed to be made in reponse to a activate event
1885 9656              ; so the state of the controls can be tied to the window state.
1886 9656              ;
1887 9656              ;   IN:    PUSH:LONG - pointer to window.
1888 9656              ;          PUSH:WORD - Window State
1889 9656              ;
1890 9656              ;  OUT:    Nothing.
1891 9656              ;
1892 9656              ;          Will just exit if a null window pointer passed or no controls
1893 9656              ;          in window's control list.
1894 9656              ;
1895 9656              ;====================================================================
1896 9656              FutzCtls PROC 
1897 9656
1898 9656              window   equ   inputs
1899 9656              windowState equ   window+4
1900 9656              ;
1901 9656              ;
1902 9656 20 15 A0              jsr   CMStartup                Do tool function setup.
1903 9659              ;
1904 9659 20 82 A1              jsr   getWindPtr               Get given window pointer.
1905 965C B0 7B                 bcs   exit                     Any errors?
1906 965E              ;
1907 965E A0 D2 00              ldy   #owFrame                 Is window visible?
1908 9661 B7 09                 lda   [<windptr],y
1909 9663 29 20 00              and   #F_VIS
1910 9666 F0 71                 beq   exit                     Nothing to do if invisible.
1911 9668
1912 9668 48                    pha   
1913 9669 48                    pha   
1914 966A A2 04 1C 22           _GetPort 
1915 9671
1916 9671 D4 50                 pei   Window+2
1917 9673 D4 4E                 pei   Window
1918 9675 A2 04 1B 22           _SetPort 
1919 967C
1920 967C 48                    pha   
1921 967D 48                    pha   
1922 967E 48                    pha   
1923 967F 48                    pha   
1924 9680 3B                    tsc   
1925 9681 1A                    inc   a
1926 9682 F4 00 00              pea   0
1927 9685 48                    pha   
1928 9686 A2 04 20 22           _GetPortRect 
1929 968D
1930 968D D4 50                 pei   Window+2
1931 968F D4 4E                 pei   Window
1932 9691 A2 0E 4D 22           _StartDrawing 
1933 9698
1934 9698
1935 9698              ;
1936 9698              ;
1937 9698              ; --- Invalidate all the controls in the list --------------
1938 9698              ;
1939 9698              lop1      
1940 9698 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
1941 969B B7 05                 lda   [<ctlPtr],y
1942 969D 30 17                 bmi   ItsSuper
1943 969F
1944 969F A5 05                 lda   ctlPtr
1945 96A1 18                    clc   
1946 96A2 69 08 00              adc   #NewCtlRecord.ctlRect
1947 96A5 AA                    tax   
1948 96A6 A5 07                 lda   ctlPtr+2
1949 96A8 69 00 00              adc   #0
1950 96AB 48                    pha   
1951 96AC DA                    phx   
1952 96AD A2 0E 3A 22           _InvalRect 
1953 96B4
1954 96B4 80 0B                 bra   JoinUp
1955 96B6              ;
1956 96B6              ItsSuper  
1957 96B6 A5 52                 lda   WindowState              ; notify this def proc.
1958 96B8 A0 00 00              ldy   #0
1959 96BB A2 13 00              ldx   #ctlWinStateChange
1960 96BE 20 2B 9C              jsr   CMDispatch
1961 96C1
1962 96C1              JoinUp    
1963 96C1 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
1964 96C4              ;
1965 96C4 20 7C A3              jsr   next_Ctl                 Get pointer to next control.
1966 96C7 D0 CF                 bne   lop1                     Any more controls?
1967 96C9
1968 96C9 A2 04 23 22           _SetOrigin 
1969 96D0 68                    pla   
1970 96D1 68                    pla   
1971 96D2              ;
1972 96D2 A2 04 1B 22           _SetPort                       Restore orig port.
1973 96D9              ;
1974 96D9 A0 00 00     exit     ldy   #0                       No error flag.
1975 96DC 82 9D 09              brl   CMpop6bytes
1976 96DF
1977 96DF                       ENDP 
1978 96DF
1979 96DF
1980 96DF              ;====================================================================
1981 96DF              ;
1982 96DF              ;                   Set2Draw
1983 96DF              ;
1984 96DF              ;                   Set to draw control.
1985 96DF              ;
1986 96DF              ;   IN:    Ctlhand = handle of control.
1987 96DF              ;          Ctlptr = pointer to control.
1988 96DF              ;
1989 96DF              ;====================================================================
1990 96DF              set2draw PROC EXPORT 
1991 96DF
1992 96DF D4 2F                 pei   <work+2                  Save.
1993 96E1 D4 2D                 pei   <work
1994 96E3              ;
1995 96E3 20 CD A1              jsr   to_wport                 Switch to window's port.
1996 96E6              ;
1997 96E6              ;
1998 96E6              ; --- Get window's vis RECT to not draw controls that aren't visible -------
1999 96E6              ;
2000 96E6 48                    pha                            Space for result.
2001 96E7 48                    pha   
2002 96E8 A2 04 C9 22           _GetVisHandle                  Get handle of window's visRgn.
2003 96EF 68                    pla   
2004 96F0 85 2D                 sta   <work
2005 96F2 68                    pla   
2006 96F3 85 2F                 sta   <work+2
2007 96F5              ;
2008 96F5 A0 02 00              ldy   #2                       Dereference handle,
2009 96F8 B7 2D                 lda   [<work],y
2010 96FA A8                    tay   
2011 96FB A7 2D                 lda   [<work]
2012 96FD 18                    clc   
2013 96FE 69 02 00              adc   #2                       and add offset to bounds RECT.
2014 9701 90 01                 bcc   store1
2015 9703 C8                    iny   
2016 9704 85 2D        store1   sta   <work
2017 9706 84 2F                 sty   <work+2
2018 9708              ;
2019 9708 A0 06 00              ldy   #x2                      Clone visRgn's bounds RECT.
2020 970B A2 40 00              ldx   #visRect+x2
2021 970E B7 2D        lop1     lda   [<work],y
2022 9710 5A                    phy   
2023 9711 9B                    txy   
2024 9712 97 41                 sta   [<data],y
2025 9714 7A                    ply   
2026 9715 CA                    dex   
2027 9716 CA                    dex   
2028 9717 88                    dey   
2029 9718 88                    dey   
2030 9719 10 F3                 bpl   lop1
2031 971B              ;
2032 971B 68                    pla                            Restore.
2033 971C 85 2D                 sta   <work
2034 971E 68                    pla   
2035 971F 85 2F                 sta   <work+2
2036 9721
2037 9721 60                    rts   
2038 9722
2039 9722                       ENDP 
2040 9722
2041 9722
2042 9722              ;====================================================================
2043 9722              ;
2044 9722              ;          DrawWholeCtl
2045 9722              ;
2046 9722              ;====================================================================
2047 9722              drawWholeCtl PROC 
2048 9722
2049 9722 64 29                 stz   <param                   Draw entire control.
2050 9724
2051 9724              ;---------------------------------------------------------------
2052 9724              ;
2053 9724              ;   IN:    param = 0 to draw entire control, or part code to draw.
2054 9724              ;
2055 9724              ;---------------------------------------------------------------
2056 9724                       ENTRY drawCtl 
2057 9724              drawCtl                                 ;
2058 9724
2059 9724 64 2B                 stz   <param+2
2060 9726              ;
2061 9726 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2062 9729              ;
2063 9729 A0 10 00              ldy   #CtlFlag                 Is control visible?
2064 972C B7 05                 lda   [<Ctlptr],y
2065 972E 29 80 00              and   #Ctl_INVIS
2066 9731 D0 58                 bne   exit
2067 9733              ;
2068 9733 20 2C A4              jsr   CMsetrect                Put enclosing RECT into 'rect'.
2069 9736              ;
2070 9736 A0 16 00              ldy   #CtlProc+2               Special case simple buttons.
2071 9739 B7 05                 lda   [<ctlptr],y
2072 973B 29 FF 7F              and   #$7FFF                   Mask off high bit just in case this is a super control
2073 973E 88                    dey   
2074 973F 88                    dey   
2075 9740 17 05                 ora   [<ctlptr],y
2076 9742 D0 0D                 bne   ok1
2077 9744              ;
2078 9744 A0 10 00              ldy   #CtlFlag
2079 9747 B7 05                 lda   [<ctlptr],y
2080 9749 29 01 00              and   #SB_BOLD
2081 974C F0 03                 beq   ok1
2082 974E              ;
2083 974E 20 4F AB              jsr   expandButt               Expand the enclosing RECT.
2084 9751              ;
2085 9751 A5 15        ok1      lda   <rect+y1
2086 9753 30 07                 bmi   skip1
2087 9755 A0 3E 00              ldy   #visRect+y2
2088 9758 D7 41                 cmp   [<data],y
2089 975A B0 2F                 bcs   exit
2090 975C              ;
2091 975C A5 17        skip1    lda   <rect+x1
2092 975E 30 07                 bmi   skip2
2093 9760 A0 40 00              ldy   #visRect+x2
2094 9763 D7 41                 cmp   [<data],y
2095 9765 B0 24                 bcs   exit
2096 9767              ;
2097 9767 A0 3A 00     skip2    ldy   #visRect+y1
2098 976A B7 41                 lda   [<data],y
2099 976C 30 1E                 bmi   ok2
2100 976E A5 19                 lda   <rect+y2
2101 9770 30 19                 bmi   exit
2102 9772 A0 3A 00              ldy   #visRect+y1
2103 9775 D7 41                 cmp   [<data],y
2104 9777 90 12                 bcc   exit
2105 9779              ;
2106 9779 A0 3C 00              ldy   #visRect+x1
2107 977C B7 41                 lda   [<data],y
2108 977E 30 0C                 bmi   ok2
2109 9780 A5 1B                 lda   <rect+x2
2110 9782 30 07                 bmi   exit
2111 9784 A0 3C 00              ldy   #visRect+x1
2112 9787 D7 41                 cmp   [<data],y
2113 9789 B0 01                 bcs   ok2
2114 978B 60           exit     rts   
2115 978C              ;
2116 978C 20 95 97     ok2      jsr   set2drawCtl              Setup to draw the control.
2117 978F              ;
2118 978F A2 00 00              ldx   #drawCntl                Draw task number.
2119 9792 82 9A 04              brl   CMDispatch2              Call definition procedure.
2120 9795
2121 9795                       ENDP 
2122 9795
2123 9795
2124 9795              ;====================================================================
2125 9795              ;
2126 9795              ;                   Set2DrawCtl
2127 9795              ;
2128 9795              ;                   Setup to draw a control.
2129 9795              ;
2130 9795              ;   IN:    <ctlHand = handle of control.
2131 9795              ;
2132 9795              ;  OUT:    <param = 0 to draw entire control, state = 0.
2133 9795              ;                   part code to draw just that part of the control.
2134 9795              ;
2135 9795              ;           state = 0 to draw part in 'param' as unhighlighted.
2136 9795              ;                   2 to draw part in 'param' as highlighted.
2137 9795              ;
2138 9795              ;           active = $0000 if control is active.
2139 9795              ;                    $FFFF if control is inactive, param = 0.
2140 9795              ;
2141 9795              ;
2142 9795              ; Change History
2143 9795              ;
2144 9795              ; 06 Oct 88         Steven Glass
2145 9795              ;
2146 9795              ; The active flag used by built in defProcs is in the global data
2147 9795              ; area rather passed to the defproc.  This made it hard for
2148 9795              ; custom defProcs to do the right thing.  So we also put
2149 9795              ; the flag in the hi-word of the param sent with the draw message
2150 9795              ;
2151 9795              ;====================================================================
2152 9795              set2drawCtl PROC EXPORT 
2153 9795
2154 9795 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2155 9798              ;
2156 9798 A9 00 00              lda   #0
2157 979B A0 4E 00              ldy   #active                  Set active flag.
2158 979E 97 41                 sta   [<data],y
2159 97A0 A0 50 00              ldy   #state                   Set unhighlighted flag.
2160 97A3 97 41                 sta   [<data],y
2161 97A5
2162 97A5 64 2B                 stz   <param+2                 Zero this to indicate that control not inactive
2163 97A7              ;
2164 97A7 20 B4 A1              jsr   get_wptr                 Get control's window pointer.
2165 97AA A0 D2 00              ldy   #owFrame
2166 97AD B7 09                 lda   [<windptr],y
2167 97AF 29 09 00              and   #F_HIGHLT+F_Ctl_TIE      Is owner window active?
2168 97B2 F0 0D                 beq   inactive                 If not, control can't be either.
2169 97B4              ;
2170 97B4 A0 11 00              ldy   #CtlHilite
2171 97B7 B7 05                 lda   [<Ctlptr],y
2172 97B9 29 FF 00              and   #$00FF
2173 97BC C9 FF 00              cmp   #255                     Active?
2174 97BF D0 0E                 bne   skip
2175 97C1              ;
2176 97C1 A0 4E 00     inactive ldy   #active                  Set inactive flag.
2177 97C4 A9 FF FF              lda   #$FFFF
2178 97C7 97 41                 sta   [<data],y
2179 97C9 85 2B                 sta   <param+2
2180 97CB 64 29                 stz   <param                   Draw entire control as inactive.
2181 97CD 80 0D                 bra   ready
2182 97CF              ;
2183 97CF AA           Skip     tax                            Hilite a part?
2184 97D0 F0 0A                 beq   ready
2185 97D2              ;
2186 97D2 85 29                 sta   <param                   Store part to hilite in 'param'.
2187 97D4              ;
2188 97D4 A0 50 00              ldy   #state                   Set highlight flag.
2189 97D7 A9 02 00              lda   #2
2190 97DA 97 41                 sta   [<data],y
2191 97DC              ;
2192 97DC              ;
2193 97DC              ; --- Do some more, common setups ----------------------
2194 97DC              ;
2195 97DC 20 2C A4     Ready    jsr   CMsetrect                Put enclosing RECT into 'rect'.
2196 97DF              ;
2197 97DF
2198 97DF              ;
2199 97DF              ; No longer do we setup the ref to color table!    SEG  19 Feb 89
2200 97DF              ;        jsr   setupColor
2201 97DF              ;
2202 97DF A2 04 36 22           _PenNormal                     ; so call pen normal directly
2203 97E6              ;
2204 97E6              ; End 19 Feb change.
2205 97E6              ;
2206 97E6
2207 97E6 80 00                 bra   setvertpen               Set pen size to vert_pen,1.
2208 97E8
2209 97E8
2210 97E8              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2211 97E8              ;          Set pen size to:
2212 97E8              ;                width = vert_pen.
2213 97E8              ;                height = 1.
2214 97E8              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2215 97E8              ;        ENTRY SetVertPen
2216 97E8              setvertpen proc export 
2217 97E8              ;
2218 97E8 20 64 A1              jsr   pushVvert_pen
2219 97EB F4 01 00              pea   1
2220 97EE A2 04 2C 22           _SetPenSize 
2221 97F5
2222 97F5 60                    rts   
2223 97F6
2224 97F6
2225 97F6              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2226 97F6              ;          Draw a line from the current
2227 97F6              ;          pen position, to the given point.
2228 97F6              ;
2229 97F6              ;   IN:  y = y coordinate.
2230 97F6              ;        x = x coordinate.
2231 97F6              ;
2232 97F6              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2233 97F6              ;        ENTRY drawto
2234 97F6              drawto   proc export 
2235 97F6              ;
2236 97F6 DA                    phx   
2237 97F7 5A                    phy   
2238 97F8 A2 04 3C 22           _LineTo 
2239 97FF
2240 97FF 60                    rts   
2241 9800
2242 9800
2243 9800              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2244 9800              ;        Indent 'rect'.
2245 9800              ;
2246 9800              ;   IN:  a = number of lines to indent.
2247 9800              ;
2248 9800              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2249 9800                       ENTRY indent 
2250 9800              indent                                  ;
2251 9800              ;
2252 9800 48                    pha   
2253 9801              ;
2254 9801 18                    clc   
2255 9802 65 15                 adc   <rect+y1
2256 9804 85 15                 sta   <rect+y1
2257 9806              ;
2258 9806 A3 01                 lda   1,s
2259 9808 18                    clc   
2260 9809 65 17                 adc   <rect+x1
2261 980B 85 17                 sta   <rect+x1
2262 980D              ;
2263 980D A5 19                 lda   <rect+y2
2264 980F 38                    sec   
2265 9810 E3 01                 sbc   1,s
2266 9812 85 19                 sta   <rect+y2
2267 9814              ;
2268 9814 A5 1B                 lda   <rect+x2
2269 9816 38                    sec   
2270 9817 E3 01                 sbc   1,s
2271 9819 85 1B                 sta   <rect+x2
2272 981B              ;
2273 981B 68                    pla   
2274 981C
2275 981C 60                    rts   
2276 981D              ;
2277 981D                       ENDP 
2278 981D
2279 981D
2280 981D              ;====================================================================
2281 981D              ;
2282 981D              ;                   GrowSize
2283 981D              ;
2284 981D              ;                   Return the size of a standard grow box.
2285 981D              ;
2286 981D              ;   IN:    None.
2287 981D              ;
2288 981D              ;  OUT:    LONG - low order = height.
2289 981D              ;                 high-order = width.
2290 981D              ;
2291 981D              ;====================================================================
2292 981D              GrowSize PROC 
2293 981D
2294 981D              grow_h   equ   inputs
2295 981D              grow_w   equ   grow_h+2
2296 981D              ;
2297 981D              ;
2298 981D C9 00 00              cmp   #0                       Special Kludge for people who
2299 9820 D0 0A                 bne   GoOn                     open windows before initing ctlmgr.
2300 9822 C0 00 00              cpy   #0                       Instead of dying, we just return.
2301 9825 D0 05                 bne   GoOn                     (Window mgr calls this even when
2302 9827 A9 02 10              lda   #$1002                   window has no controls.)
2303 982A 38                    sec   
2304 982B
2305 982B 6B                    rtl   
2306 982C              GoOn                                    ; 
2307 982C              ;
2308 982C 20 15 A0              jsr   CMStartup                Do tool function setups.
2309 982F              ;
2310 982F A2 10 00              ldx   #GROW_ICON
2311 9832 20 93 A3              jsr   get_csize                Get height and width of grow icon.
2312 9835              ;
2313 9835 A0 21 00              ldy   #rect2+y2                Icon height,
2314 9838 B7 41                 lda   [<data],y
2315 983A 18                    clc   
2316 983B 69 04 00              adc   #4                       plus leading.
2317 983E 85 4E                 sta   <grow_h                  equals box's height.
2318 9840              ;
2319 9840 A0 23 00              ldy   #rect2+x2                Icon width,
2320 9843 B7 41                 lda   [<data],y
2321 9845 18                    clc   
2322 9846 69 08 00              adc   #8                       plus leading,
2323 9849 85 50                 sta   <grow_w                  equals box's width.
2324 984B              ;
2325 984B A0 00 00     exit     ldy   #0                       No error flag.
2326 984E 82 21 08              brl   CMpop0bytes
2327 9851
2328 9851                       ENDP 
2329 9851
2330 9851              ;
2331 9851              ;            APPEND                     CTRACK.ASM
2332 9851              ;
2333 9851              ;====================================================================
2334 9851              ;
2335 9851              ;                   TrackControl
2336 9851              ;
2337 9851              ;                   Track mouse in a control.
2338 9851              ;
2339 9851              ;   IN:    PUSH:WORD - x starting position, in global.
2340 9851              ;          PUSH:WORD - y starting position, in global.
2341 9851              ;          PUSH:LONG - address of action routine.
2342 9851              ;          PUSH:LONG - handle of control.
2343 9851              ;          Current port is control's window port.
2344 9851              ;
2345 9851              ;  OUT:    WORD - part code selected, or zero if none.
2346 9851              ;
2347 9851              ;
2348 9851              ; Change History
2349 9851              ;
2350 9851              ; 21 Nov 88         Steven Glass
2351 9851              ;
2352 9851              ; Changed the way the ctlDrag message is used when control has
2353 9851              ; part code > $80.  If the control is a super control, the high
2354 9851              ; word of the result from defProc call is the part code to return
2355 9851              ; to caller.  This allows us to return no part code if the 
2356 9851              ; user pulls his mouse out of the control before releasing
2357 9851              ; the button.
2358 9851              ;
2359 9851              ;====================================================================
2360 9851              TrackControl PROC 
2361 9851
2362 9851              match    equ   work                     Place to store part I'll be watching.
2363 9851
2364 9851              control  equ   inputs
2365 9851              action   equ   control+4
2366 9851              starty   equ   action+4
2367 9851              startx   equ   starty+2
2368 9851              RetCode  equ   startx+2                 Place to store current part
2369 9851              ;                                       (either what's in 'match' or zero).
2370 9851              ;
2371 9851              ;
2372 9851 20 15 A0              jsr   CMStartup                Do setup for tool call.
2373 9854              ;
2374 9854 20 9F A1              jsr   getCtlHand               Get passed control handle.
2375 9857 90 03                 bcc   ok1                      Null handle passed?
2376 9859 82 2F 08              brl   CMpop12bytes
2377 985C              ;
2378 985C 64 5A        ok1      stz   <RetCode                 Start with no part found.
2379 985E 64 2D                 stz   <match
2380 9860              ;
2381 9860 20 CD A1              jsr   to_wport                 Save port and switch to window's.
2382 9863 20 AF 9E              jsr   pushPort                 Save the current port.
2383 9866              ;
2384 9866              ;
2385 9866              ; --- Convert starting point to local -----------------------
2386 9866              ;
2387 9866 A6 58                 ldx   <startx
2388 9868 A5 56                 lda   <starty
2389 986A 20 FE 9A              jsr   to_local
2390 986D              ;
2391 986D 20 94 99              jsr   testpart                 We have to start on a part.
2392 9870 85 2D                 sta   <match                   Save starting part.
2393 9872 D0 03                 bne   ck_indic                 Did we start on a part?
2394 9874 82 9B 00              brl   exit                     If not, I'm done.
2395 9877              ;
2396 9877 AA           ck_indic tax                            Save part code in x.
2397 9878 29 80 00              and   #$0080                   Is the part an indicator?
2398 987B D0 29                 bne   indicator                If yes, different tracking method.
2399 987D              ;
2400 987D              ;
2401 987D              ; --- Track LOOP -----------------------------------------------------
2402 987D              ;
2403 987D              ; ------ Find out what part the cursor is currently over -------------
2404 987D              ;
2405 987D 20 1B 99     track_loop jsr   ckhit                  Check hit on part, save state, draw.
2406 9880              ;
2407 9880 A5 5A                 lda   <RetCode                 Is the part currently selected?
2408 9882 F0 07                 beq   skip1
2409 9884              ;
2410 9884 85 29                 sta   <param                   Pass part code.
2411 9886 64 2B                 stz   <param+2
2412 9888 20 42 99              jsr   do_action                Call action procedure.
2413 988B              ;
2414 988B 20 06 9A     skip1    jsr   getratpos                Get current mouse position.
2415 988E              ;
2416 988E 20 D3 99              jsr   ckbutton2                Check if button has been released.
2417 9891 B0 EA                 bcs   track_loop               Continue to track if still down.
2418 9893              ;
2419 9893 85 25                 sta   <yrat
2420 9895 86 27                 stx   <xrat
2421 9897 20 1B 99              jsr   ckhit                    Perform check at position of up event.
2422 989A              ;
2423 989A              ;
2424 989A              ; --- Selection made, unhighlight part if needed -----------
2425 989A              ;
2426 989A A5 5A                 lda   <RetCode                 Not needed if zero.
2427 989C F0 71                 beq   exit1                    Tell action proc it's out of part.
2428 989E              ;
2429 989E A9 00 00              lda   #0                       Unhilite flag.
2430 98A1 20 C4 99              jsr   setstate                 Unhilite the control part.
2431 98A4 80 6C                 bra   exit                     All done, exit TrackControl.
2432 98A6              ;
2433 98A6              ;
2434 98A6              ;
2435 98A6              ;
2436 98A6              ;
2437 98A6              ;
2438 98A6              ;     One-Way Code, we pass through here only once per event.
2439 98A6              ;
2440 98A6              ; --- Track indicator ----------------------------------------------
2441 98A6              ;
2442 98A6              ; ------ Ask control to drag its indicator -------------------------
2443 98A6              ;
2444 98A6 86 5A        indicator stx   <RetCode                Return part code.
2445 98A8              ;
2446 98A8 A0 00 00              ldy   #0                       (High word of LONG parameter.)
2447 98AB 8A                    txa                            Pass part code to drag routine.
2448 98AC A2 07 00              ldx   #dragCntl
2449 98AF 20 2B 9C              jsr   CMDispatch
2450 98B2 48                    pha                            Save low word of return
2451 98B3 C9 00 00              cmp   #0                       If not handled, treat as not super
2452 98B6 F0 09                 beq   @NotSuper
2453 98B8 A0 16 00              ldy   #ctlProc+2               See if this is a super control
2454 98BB B7 05                 lda   [<ctlPtr],y
2455 98BD 10 02                 bpl   @NotSuper                No, not a super control
2456 98BF 86 5A                 stx   <RetCode                 Yes, make this the part code
2457 98C1 68           @NotSuper pla                           Now, check to see if we do default dragging?
2458 98C2 D0 4E                 bne   exit
2459 98C4              ;
2460 98C4              ;
2461 98C4              ; --------- Perform default indicator drag -------------------------
2462 98C4              ;
2463 98C4 20 4E A1              jsr   pushlimit_blk
2464 98C7 68                    pla                            Pass pointer to parameter block
2465 98C8 7A                    ply   
2466 98C9 A2 06 00              ldx   #thumbCntl               Ask defProc to compute parameters.
2467 98CC 20 2B 9C              jsr   CMDispatch               Call control.
2468 98CF AA                    tax                            Execute default setup?
2469 98D0 D0 03                 bne   call_drag
2470 98D2              ;
2471 98D2 20 A5 B4              jsr   setup_drag               Perform default setup for dragging.
2472 98D5              ;
2473 98D5              ;
2474 98D5              ; --- Call DragRect ------------------------------------------------
2475 98D5              ;
2476 98D5 20 98 9B     call_drag jsr   get_dragrect            Compute drag RECT.
2477 98D8              ;
2478 98D8 48                    pha                            Space for return deltas.
2479 98D9 48                    pha   
2480 98DA A9 00 00              lda   #0                       Address of action procedure, none.
2481 98DD 48                    pha   
2482 98DE 48                    pha   
2483 98DF 20 13 A1              jsr   pushVdrag_patt           Pass to drag outline pattern.
2484 98E2 D4 27                 pei   <xrat                    Pass starting point.
2485 98E4 D4 25                 pei   <yrat
2486 98E6 20 3F A1              jsr   pushdrag_rect            Pass pointer to RECT to drag.
2487 98E9 20 44 A1              jsr   pushbound_rect           Pass pointer to bounds RECT.
2488 98EC 20 49 A1              jsr   pushslop_rect            Pass pointer to slop RECT.
2489 98EF 20 5F A1              jsr   pushVaxis_param          Pass movement axis parameter.
2490 98F2 A2 10 1D 22           _DragRect 
2491 98F9 68                    pla                            Get Y delta.
2492 98FA 85 29                 sta   <param
2493 98FC 68                    pla                            Get X delta.
2494 98FD 85 2B                 sta   <param+2
2495 98FF 05 29                 ora   <param                   Was there any change?
2496 9901 F0 0F                 beq   exit                     If not, I'm done.
2497 9903              ;
2498 9903              ;
2499 9903              ; --- Reposition indicator -----------------------------------------
2500 9903              ;
2501 9903 A2 05 00              ldx   #posCntl                 Ask defProc to compute new value,
2502 9906 20 2F 9C              jsr   CMDispatch2              and redraw control.
2503 9909 AA                    tax                            Perform default reposition?
2504 990A D0 03                 bne   exit1
2505 990C              ;
2506 990C 20 44 B5              jsr   reposition               Perform default reposition.
2507 990F              ;
2508 990F 20 42 99     exit1    jsr   do_action                Call action routine about change.
2509 9912              ;
2510 9912 20 C9 9E     exit     jsr   popPort                  Restore the current port.
2511 9915              ;
2512 9915 A0 00 00     exit2    ldy   #0                       No error flag.
2513 9918 82 70 07              brl   CMpop12bytes
2514 991B              ;
2515 991B              ;
2516 991B              ; = = = = = = = = = = = = = = = = = = = = = =
2517 991B              ;          Check hit on part.
2518 991B              ;100= = = = = = = = = = = = = = = = = = = = =
2519 991B              ;
2520 991B              ckhit                                   ;
2521 991B              ;
2522 991B A5 25                 lda   <yrat                    Find part under cursor.
2523 991D A6 27                 ldx   <xrat
2524 991F 20 94 99              jsr   testpart
2525 9922 F0 07                 beq   ck_hilite                Over a part?
2526 9924              ;
2527 9924 C5 2D                 cmp   <match                   Has to be the same as the starting part.
2528 9926 F0 03                 beq   ck_hilite
2529 9928 A9 00 00              lda   #0                       Force it to 'out of part'.
2530 992B              ;
2531 992B              ;
2532 992B              ; ------ Highlight/Unhighlight the part as needed --------------------
2533 992B              ;
2534 992B C5 5A        ck_hilite cmp   <RetCode                As state of part changed?
2535 992D F0 05                 beq   exit100
2536 992F              ;
2537 992F 85 5A                 sta   <RetCode                 Save new state.
2538 9931 82 90 00              brl   setstate                 Draw the part in its new state.
2539 9934              ;
2540 9934 60           exit100  rts   
2541 9935              ;
2542 9935              ;
2543 9935              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2544 9935              ;          Push a pointer to inside a record.
2545 9935              ;110= = = = = = = = = = = = = = = = = = = = = = = = = = =
2546 9935              ;
2547 9935              ;   IN:    Ctlptr = pointer to record.
2548 9935              ;          a = offset into the record.
2549 9935              ;
2550 9935              ;  OUT:    pointer on stack.
2551 9935              ;
2552 9935              ;        export pushrecord
2553 9935              pushrecord proc export 
2554 9935              ;
2555 9935 7A                    ply                            Get return address.
2556 9936              ;
2557 9936 A6 07                 ldx   <Ctlptr+2
2558 9938 18                    clc   
2559 9939 65 05                 adc   <Ctlptr
2560 993B 90 01                 bcc   ok110
2561 993D E8                    inx   
2562 993E DA           ok110    phx   
2563 993F 48                    pha   
2564 9940              ;
2565 9940 5A                    phy                            Return address back.
2566 9941 60                    rts   
2567 9942              ;
2568 9942              ;
2569 9942              ;====================================================================
2570 9942              ;          Call action procedure.
2571 9942              ;
2572 9942              ;          action = value passed to TrackControl.
2573 9942              ;          CtlAction = value in control's record.
2574 9942              ;          autoTrack = control's definition procedure's action command.
2575 9942              ;
2576 9942              ;          If action = 0 then quit, perform no action.
2577 9942              ;          If action = -1 then
2578 9942              ;          {
2579 9942              ;                If CtlAction = 0 then quit, perform no action.
2580 9942              ;                If CtlAction = -1 then
2581 9942              ;                     Call autoTrack in the control's definition procedure.
2582 9942              ;                Else
2583 9942              ;                     Call CtlAction.
2584 9942              ;          }
2585 9942              ;          Else
2586 9942              ;                Call action.
2587 9942              ;
2588 9942              ;120=================================================================
2589 9942              do_action proc export 
2590 9942
2591 9942 A5 52                 lda   <action                  Perform no action?
2592 9944 05 54                 ora   <action+2
2593 9946 F0 4B                 beq   exit120
2594 9948              ;
2595 9948 A5 54                 lda   <action+2
2596 994A 10 23                 bpl   use_action               If negative, call defProc for autoTrack.
2597 994C
2598 994C              ;
2599 994C              ; ------------ Check CtlAction for path to take ---------------------
2600 994C              ;
2601 994C 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2602 994F A0 18 00              ldy   #CtlAction
2603 9952 B7 05                 lda   [<Ctlptr],y
2604 9954 C8                    iny   
2605 9955 C8                    iny   
2606 9956 17 05                 ora   [<Ctlptr],y              Is CtlAction zero?
2607 9958 F0 39                 beq   exit120                  If yes, perform no action.
2608 995A              ;
2609 995A B7 05                 lda   [<Ctlptr],y
2610 995C 10 06                 bpl   use_Ctl
2611 995E              ;
2612 995E              ; ----------------- Call defProc's action routine -------------------
2613 995E              ;
2614 995E A2 08 00              ldx   #autoTrack               Part code already in param.
2615 9961 82 CB 02              brl   CMDispatch2
2616 9964              ;
2617 9964              ;
2618 9964              ; ----------------- Call CtlAction ---------------------------------
2619 9964              ;
2620 9964 88           use_Ctl  dey   
2621 9965 B7 05                 lda   [<Ctlptr],y
2622 9967 AA                    tax   
2623 9968 A0 18 00              ldy   #CtlAction
2624 996B B7 05                 lda   [<Ctlptr],y
2625 996D 80 04                 bra   makecall
2626 996F              ;
2627 996F              ;
2628 996F              ; ----------------- Use action routine passed to TrackControl --------
2629 996F              ;
2630 996F A6 53        use_action ldx   <action+1
2631 9971 A5 52                 lda   <action
2632 9973              ;
2633 9973              ;
2634 9973              ; --------- Call action routine that was passed to _TrackControl -----
2635 9973              ;
2636 9973 A8           makecall tay                            Pass address in X and Y.
2637 9974              ;
2638 9974              ;
2639 9974 D4 03                 pei   <ctlhand+2               Save control's handle.
2640 9976 D4 01                 pei   <ctlhand
2641 9978 0B                    phd                            Save my zero page.
2642 9979              ;
2643 9979              ;
2644 9979 48                    pha                            Space for dummy return value,
2645 997A              ;                                       to make some apps run.
2646 997A D4 5A                 pei   <RetCode                 Pass part code.
2647 997C D4 03                 pei   <Ctlhand+2               Pass handle of control.
2648 997E D4 01                 pei   <Ctlhand
2649 9980              ;
2650 9980 A5 46                 lda   <saveDirect              Restore caller's direct page.
2651 9982 5B                    tcd   
2652 9983              ;
2653 9983 98                    tya                            Pass low byte in A.
2654 9984 22 14 9A FD           jsl   long_call
2655 9988              ;
2656 9988 68                    pla                            Get dummy return value (not used).
2657 9989              ;
2658 9989 2B                    pld                            Restore my zero page.
2659 998A 68                    pla                            Restore control's handle.
2660 998B 85 01                 sta   <ctlhand
2661 998D 68                    pla   
2662 998E 85 03                 sta   <ctlhand+2
2663 9990 82 4F 08              brl   dereference              Ctlptr = (Ctlhand).
2664 9993              ;
2665 9993 60           exit120  rts   
2666 9994
2667 9994
2668 9994              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2669 9994              ;        Find part at given point
2670 9994              ;
2671 9994              ;   IN:  a = y coordinate.
2672 9994              ;        x = x coordinate.
2673 9994              ;        <ctlHand = handle of control.
2674 9994              ;
2675 9994              ;  OUT:    Equal flag TRUE if no part found.
2676 9994              ;          Else
2677 9994              ;                a = part code found at given point, or zero if none found.
2678 9994              ;
2679 9994              ;130= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2680 9994                       ENTRY testpart 
2681 9994              testpart                                ;
2682 9994 85 29                 sta   <param                   Pass y point.
2683 9996 86 2B                 stx   <param+2                 Pass x point.
2684 9998
2685 9998 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2686 999B A0 10 00              ldy   #CtlFlag                 Control has to be active and visible.
2687 999E B7 05                 lda   [<Ctlptr],y
2688 99A0 29 80 00              and   #Ctl_INVIS
2689 99A3 D0 0B                 bne   noPart130                Visible?
2690 99A5              ;
2691 99A5 C8                    iny   
2692 99A6 B7 05                 lda   [<Ctlptr],y
2693 99A8 29 FF 00              and   #$00FF
2694 99AB C9 FF 00              cmp   #C_HILITE                Active?
2695 99AE D0 04                 bne   ok130
2696 99B0 A9 00 00     noPart130 lda   #0                      No part
2697 99B3 60                    rts   
2698 99B4              ;
2699 99B4 A0 08 00     ok130    ldy   #CtlRect                 Is point in enclosing RECT?
2700 99B7 20 1A B1              jsr   check_pt
2701 99BA F0 07                 beq   exit130                  Don't check part if not in control.
2702 99BC              ;
2703 99BC A2 02 00              ldx   #testCntl                Call defProc to test for part.
2704 99BF 20 2F 9C              jsr   CMDispatch2
2705 99C2              ;
2706 99C2 A8                    tay                            Set return flag.
2707 99C3
2708 99C3 60           exit130  rts   
2709 99C4
2710 99C4
2711 99C4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2712 99C4              ;
2713 99C4              ;        Set state of control.
2714 99C4              ;
2715 99C4              ;   IN:    a = part code to highlight, or zero to unhighlight last highlighted.
2716 99C4              ;
2717 99C4              ;150= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2718 99C4                       ENTRY setstate 
2719 99C4              setstate                                ;
2720 99C4 48                    pha                            Pass part code to highlight.
2721 99C5 D4 03                 pei   <Ctlhand+2               Pass handle of control.
2722 99C7 D4 01                 pei   <Ctlhand
2723 99C9 A2 10 11 22           _HiliteControl                 Change control highlight and draw.
2724 99D0              ;
2725 99D0 82 0F 08              brl   dereference
2726 99D3              ;
2727 99D3              ;
2728 99D3              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2729 99D3
2730 99D3              ;;        Check if button is stil down.
2731 99D3              ;
2732 99D3              ;  OUT:  Carry set if button still down.
2733 99D3              ;        Carry clear if button has been released, a=y pos, x=x pos.
2734 99D3              ;
2735 99D3              ;
2736 99D3              ; Change History
2737 99D3              ;
2738 99D3              ; 09 Apr 89         Steven Glass & James P. Mensch
2739 99D3              ;
2740 99D3              ; Simplified check for mouse coming up when we think it 
2741 99D3              ; should be down.  Prevents leaving a mouse up in queue.
2742 99D3              ;
2743 99D3              ;160= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2744 99D3                       ENTRY ckbutton2 
2745 99D3              ckbutton2                               ;
2746 99D3 48                    pha   
2747 99D4 F4 04 00              pea   4                        Looking only for button up.
2748 99D7 20 35 A1              jsr   pushmyevent              Pass pointer to event record.
2749 99DA A2 06 0A 22           _GetNextEvent 
2750 99E1 68                    pla   
2751 99E2 D0 0C                 bne   getevent
2752 99E4              ;
2753 99E4              ;
2754 99E4              ; --- Button has not come up yet, but double check ----------------------
2755 99E4              ;
2756 99E4 A0 2E 00              ldy   #MyEvent+modif           Read modifiers from event
2757 99E7 B7 41                 lda   [<Data],y
2758 99E9 29 80 00              and   #Btn0State               Look only at button 0 state (Sense is weird)
2759 99EC D0 02                 bne   GetEvent                 Button is up, treat like got event.
2760 99EE
2761 99EE 38                    sec                            Return 'still down flag'.
2762 99EF 60                    rts   
2763 99F0
2764 99F0              ;
2765 99F0              ;
2766 99F0              ; --- Button up event, use position of event -------------------------------
2767 99F0              ;
2768 99F0 20 3A A1     getevent jsr   pushmyeventpos
2769 99F3 A2 04 85 22           _GlobalToLocal 
2770 99FA              ;
2771 99FA A0 2C 00     exit160  ldy   #myevent+where+x1        Return position of button up.
2772 99FD B7 41                 lda   [<data],y
2773 99FF AA                    tax   
2774 9A00 88                    dey   
2775 9A01 88                    dey   
2776 9A02 B7 41                 lda   [<data],y
2777 9A04
2778 9A04 18                    clc                            Button up flag.
2779 9A05 60                    rts   
2780 9A06
2781 9A06
2782 9A06              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2783 9A06              ;
2784 9A06              ;        Get current mouse position.
2785 9A06              ;
2786 9A06              ;  OUT:  yrat = mouse y position.
2787 9A06              ;        xrat = mouse x position.
2788 9A06              ;
2789 9A06              ;170= = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2790 9A06                       ENTRY getratpos 
2791 9A06              getratpos                               ;
2792 9A06 A9 25 00              lda   #yrat
2793 9A09              ;
2794 9A09                       ENTRY getratpos2 
2795 9A09              getratpos2                              ;
2796 9A09 20 75 A1              jsr   pushzpage
2797 9A0C A2 06 0C 22           _GetMouse 
2798 9A13
2799 9A13 60                    rts   
2800 9A14              ;
2801 9A14                       ENDP 
2802 9A14
2803 9A14
2804 9A14              ;====================================================================
2805 9A14              ;          Long call.
2806 9A14              ;
2807 9A14              ;   IN:    x = middle WORD (bits 8-23) of address of destination routine.
2808 9A14              ;          a = low WORD of address of destination routine.
2809 9A14              ;
2810 9A14              ;  OUT:    Calling this routine is the same as:
2811 9A14              ;
2812 9A14              ;                jsl   (ax)
2813 9A14              ;
2814 9A14              ;          where the low byte in 'a' is the low byte of the destination
2815 9A14              ;          address, and x = the next 2 bytes of the destination address.
2816 9A14              ;
2817 9A14              ;====================================================================
2818 9A14              long_call PROC EXPORT 
2819 9A14
2820 9A14 DA                    phx                            High and middle byte on stack
2821 9A15 8B                    phb                            extra byte on stack
2822 9A16 3A                    dec   a                        low and middle := xxx -1
2823 9A17 83 01                 sta   1,s                      overstore on stack
2824 9A19 6B                    rtl                            hello
2825 9A1A              ;
2826 9A1A              ;  When the routine called returns, it
2827 9A1A              ;  will return to the routine that called 'longCall', not here.
2828 9A1A              ;
2829 9A1A                       ENDP 
2830 9A1A
2831 9A1A
2832 9A1A              ;====================================================================
2833 9A1A              ;
2834 9A1A              ;          Move a control to a new position.
2835 9A1A              ;
2836 9A1A              ;   IN:    PUSH:WORD - new x origin of control.
2837 9A1A              ;          PUSH:WORD - new y origin of control.
2838 9A1A              ;          PUSH:LONG - handle of control to move.
2839 9A1A              ;
2840 9A1A              ;  OUT:    Nothing.
2841 9A1A              ;
2842 9A1A              ;====================================================================
2843 9A1A              MoveControl PROC 
2844 9A1A
2845 9A1A              CtlHandle equ   inputs
2846 9A1A              new_y    equ   CtlHandle+4
2847 9A1A              new_x    equ   new_y+2
2848 9A1A              ;
2849 9A1A              ;
2850 9A1A 20 15 A0              jsr   CMStartup                Do setup for tool call.
2851 9A1D              ;
2852 9A1D 20 9F A1              jsr   getCtlHand               Get passed control handle.
2853 9A20 B0 5A                 bcs   exit                     Null handle passed?
2854 9A22              ;
2855 9A22 A0 04 00              ldy   #4                       Lock the control.
2856 9A25 B7 01                 lda   [<ctlHand],y
2857 9A27 09 00 80              ora   #$8000
2858 9A2A 97 01                 sta   [<ctlHand],y
2859 9A2C              ;
2860 9A2C              ;
2861 9A2C              ; --- Erase the control if visible ---------------------------
2862 9A2C              ;
2863 9A2C A0 10 00              ldy   #CtlFlag                 Is control visible?
2864 9A2F B7 05                 lda   [<Ctlptr],y
2865 9A31 29 80 00              and   #Ctl_INVIS
2866 9A34 48                    pha                            Save starting state.
2867 9A35 D0 0B                 bne   skip1
2868 9A37              ;
2869 9A37 D4 03                 pei   <Ctlhand+2
2870 9A39 D4 01                 pei   <Ctlhand
2871 9A3B A2 10 0E 22           _HideControl                   Erase the control.
2872 9A42              ;
2873 9A42              ;
2874 9A42              ; --- Move the control --------------------------------------
2875 9A42              ;
2876 9A42 A9 08 00     skip1    lda   #CtlRect                 Pass pointer to enclosing RECT.
2877 9A45 20 35 99              jsr   pushrecord
2878 9A48 A5 54                 lda   <new_x
2879 9A4A A0 0A 00              ldy   #CtlRect+x1
2880 9A4D 38                    sec   
2881 9A4E F7 05                 sbc   [<Ctlptr],y
2882 9A50 85 54                 sta   <new_x                   Save delta x.
2883 9A52 48                    pha   
2884 9A53 A5 52                 lda   <new_y
2885 9A55 88                    dey   
2886 9A56 88                    dey   
2887 9A57 38                    sec   
2888 9A58 F7 05                 sbc   [<Ctlptr],y
2889 9A5A 85 52                 sta   <new_y                   Save delta y.
2890 9A5C 48                    pha   
2891 9A5D A2 04 4B 22           _OffsetRect                    Move the enclosing RECT.
2892 9A64              ;
2893 9A64 A4 54                 ldy   <new_x                   Pass X delta.
2894 9A66 A5 52                 lda   <new_y                   Pass Y delta.
2895 9A68 A2 0B 00              ldx   #moveCntl                Tell defProc that the control has moved.
2896 9A6B 20 2B 9C              jsr   CMDispatch               and redraw control.
2897 9A6E              ;
2898 9A6E              ;
2899 9A6E              ; --- Draw the control at its new position if it was visible -----------
2900 9A6E              ;
2901 9A6E 68                    pla                            Was the control visible?
2902 9A6F D0 0B                 bne   exit
2903 9A71              ;
2904 9A71 D4 03                 pei   <Ctlhand+2
2905 9A73 D4 01                 pei   <Ctlhand
2906 9A75 A2 10 0F 22           _ShowControl 
2907 9A7C              ;
2908 9A7C A0 04 00     exit     ldy   #4                       Unlock control.
2909 9A7F B7 01                 lda   [<ctlHand],y
2910 9A81 29 FF 7F              and   #$7FFF
2911 9A84 97 01                 sta   [<ctlHand],y
2912 9A86              ;
2913 9A86 A0 00 00              ldy   #0                       No error flag.
2914 9A89 82 F5 05              brl   CMpop8bytes
2915 9A8C
2916 9A8C                       ENDP 
2917 9A8C
2918 9A8C
2919 9A8C              ;====================================================================
2920 9A8C              ;
2921 9A8C              ;          Find a control at a given point.
2922 9A8C              ;
2923 9A8C              ;   IN:    PUSH:LONG - address of where to store handle of found control.
2924 9A8C              ;          PUSH:WORD - x point to check.
2925 9A8C              ;          PUSH:WORD - y point to check.
2926 9A8C              ;          PUSH:LONG - pointer to window.
2927 9A8C              ;          Current port is window's port.
2928 9A8C              ;
2929 9A8C              ;  OUT:    WORD - part code found at given point, zero if none found.
2930 9A8C              ;
2931 9A8C              ;====================================================================
2932 9A8C              FindControl PROC 
2933 9A8C
2934 9A8C              window   equ   inputs
2935 9A8C              ypoint   equ   window+4
2936 9A8C              xpoint   equ   ypoint+2
2937 9A8C              storehand equ   xpoint+2
2938 9A8C              RetPart  equ   storehand+4
2939 9A8C              ;
2940 9A8C              ;
2941 9A8C 20 15 A0              jsr   CMStartup                Do setup for tool call.
2942 9A8F              ;
2943 9A8F 64 5A                 stz   <RetPart                 Start with no part found.
2944 9A91              ;
2945 9A91 20 82 A1              jsr   getWindPtr               Get given window pointer.
2946 9A94 B0 34                 bcs   exit2                    Any errors?
2947 9A96              ;
2948 9A96              ;
2949 9A96              ; --- Switch to control's window port --------------------------
2950 9A96              ;
2951 9A96 20 CD A1              jsr   to_wport
2952 9A99              ;
2953 9A99              ;
2954 9A99              ; --- Convert given point to local ------------------------------
2955 9A99              ;
2956 9A99 A6 54                 ldx   <xpoint
2957 9A9B A5 52                 lda   <ypoint
2958 9A9D 20 FE 9A              jsr   to_local
2959 9AA0 85 52                 sta   <ypoint
2960 9AA2 86 54                 stx   <xpoint
2961 9AA4              ;
2962 9AA4              ;
2963 9AA4              ; --- Check all controls in list -----------------------------
2964 9AA4              ;
2965 9AA4 64 01                 stz   <ctlhand                 Start with last control in list.
2966 9AA6 64 03                 stz   <ctlhand+2
2967 9AA8 20 D0 9A              jsr   findPrivCtl              ctlhand = last control in list.
2968 9AAB              ;                                       ctlptr = (ctlhand)
2969 9AAB              ;
2970 9AAB A6 54        lop1     ldx   <xpoint
2971 9AAD A5 52                 lda   <ypoint
2972 9AAF 20 94 99              jsr   testpart                 Ask control's DefProc to find part.
2973 9AB2 85 5A                 sta   <RetPart
2974 9AB4 AA                    tax   
2975 9AB5 D0 08                 bne   exit                     Found a part?
2976 9AB7 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
2977 9ABA              ;
2978 9ABA 20 D0 9A     next1    jsr   findPrivCtl              ctlhand, ctlptr = previous control.
2979 9ABD 90 EC                 bcc   lop1                     At top of list?
2980 9ABF              ;
2981 9ABF              ;
2982 9ABF              ;
2983 9ABF              ; --- Return to caller ----------------------------------
2984 9ABF              ;
2985 9ABF A5 01        exit     lda   <Ctlhand                 Return pointer to control.
2986 9AC1 87 56                 sta   [<storehand]
2987 9AC3 A0 02 00              ldy   #2
2988 9AC6 A5 03                 lda   <Ctlhand+2
2989 9AC8 97 56                 sta   [<storehand],y
2990 9ACA              ;
2991 9ACA A0 00 00     exit2    ldy   #0                       No error flag.
2992 9ACD 82 BB 05              brl   CMpop12bytes
2993 9AD0              ;
2994 9AD0              ;
2995 9AD0              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2996 9AD0              ;          Find previsous control in list.
2997 9AD0              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
2998 9AD0              ;
2999 9AD0              ;   IN:    windPtr = pointer to window that has control list.
3000 9AD0              ;          ctlhand = current control, zero for last in list.
3001 9AD0              ;
3002 9AD0              ;  OUT:    Carry clear if good control found.
3003 9AD0              ;          ctlhand = control previous to given control in control list.
3004 9AD0              ;          ctlptr = (ctlhand)
3005 9AD0              ;
3006 9AD0              findPrivCtl                             ; 
3007 9AD0              ;
3008 9AD0 A5 01                 lda   <ctlhand                 Save control to match.
3009 9AD2 85 2D                 sta   <work
3010 9AD4 A5 03                 lda   <ctlhand+2
3011 9AD6 85 2F                 sta   <work+2
3012 9AD8              ;
3013 9AD8 20 93 A1              jsr   getFirstCtl              ctlhand = first control in window's list.
3014 9ADB              ;                                       ctlptr = (ctlhand).
3015 9ADB              ;
3016 9ADB A5 01                 lda   <ctlhand                 Check if at top of list.
3017 9ADD C5 2D                 cmp   <work
3018 9ADF D0 06                 bne   lop100
3019 9AE1 A5 03                 lda   <ctlHand+2
3020 9AE3 C5 2F                 cmp   <work+2
3021 9AE5 F0 16                 beq   exit100                  Carry set, at top of list.
3022 9AE7              ;
3023 9AE7 A7 05        lop100   lda   [<ctlptr]                Handle of next control.
3024 9AE9 C5 2D                 cmp   <work                    Is the next control the given handle?
3025 9AEB D0 0A                 bne   next100
3026 9AED A0 02 00              ldy   #CtlNext+2
3027 9AF0 B7 05                 lda   [<ctlptr],y
3028 9AF2 C5 2F                 cmp   <work+2
3029 9AF4 18                    clc   
3030 9AF5 F0 06                 beq   exit100                  If yes, then previous control found.
3031 9AF7              ;
3032 9AF7 20 7C A3     next100  jsr   next_ctl                 Check next control in list.
3033 9AFA D0 EB                 bne   lop100                   Any more controls in list?
3034 9AFC 38                    sec                            !!!Should never happen!!!!
3035 9AFD              ;
3036 9AFD 60           exit100  rts   
3037 9AFE              ;
3038 9AFE                       ENDP 
3039 9AFE              ;
3040 9AFE              ;
3041 9AFE              ;====================================================================
3042 9AFE              ;
3043 9AFE              ;          Convert a point to
3044 9AFE              ;          local coordinates.
3045 9AFE              ;
3046 9AFE              ;   IN:    a = y point.
3047 9AFE              ;          x = x point.
3048 9AFE              ;
3049 9AFE              ;  OUT:    a = y point in local.
3050 9AFE              ;          x = x point in local.
3051 9AFE              ;
3052 9AFE              ;====================================================================
3053 9AFE              to_local PROC 
3054 9AFE
3055 9AFE 85 25                 sta   <yrat                    Save point.
3056 9B00 86 27                 stx   <xrat
3057 9B02              ;
3058 9B02 20 6D A1              jsr   pushyrat                 Pass pointer to point.
3059 9B05 A2 04 85 22           _GlobalToLocal 
3060 9B0C              ;
3061 9B0C A5 25                 lda   <yrat                    Return converted point.
3062 9B0E A6 27                 ldx   <xrat
3063 9B10
3064 9B10 60                    rts   
3065 9B11
3066 9B11                       ENDP 
3067 9B11
3068 9B11
3069 9B11              ;====================================================================
3070 9B11              ;
3071 9B11              ;        Find a control part at a given point.
3072 9B11              ;
3073 9B11              ;   IN:  PUSH:WORD - x point, in local coordinates, to check.
3074 9B11              ;        PUSH:WORD - y point, in local coordinates, to check.
3075 9B11              ;        PUSH:LONG - pointer to control (control list).
3076 9B11              ;
3077 9B11              ;  OUT:  WORD - part code found at given point, zero if none found.
3078 9B11              ;
3079 9B11              ; Parts are searched from bottom of list to top, as they appear on screen.
3080 9B11              ;
3081 9B11              ;====================================================================
3082 9B11              TestControl PROC 
3083 9B11
3084 9B11              control  equ   inputs
3085 9B11              ypoint   equ   control+4
3086 9B11              xpoint   equ   ypoint+2
3087 9B11              RetPart  equ   xpoint+2
3088 9B11              ;
3089 9B11              ;
3090 9B11 20 15 A0              jsr   CMStartup                Do setup for tool call.
3091 9B14              ;
3092 9B14 20 9F A1              jsr   getCtlHand               Get passed control handle.
3093 9B17 B0 09                 bcs   exit                     Null handle passed?
3094 9B19              ;
3095 9B19 A6 54                 ldx   <xpoint                  Pass point to check.
3096 9B1B A5 52                 lda   <ypoint
3097 9B1D 20 94 99              jsr   testpart
3098 9B20 85 56                 sta   <RetPart
3099 9B22              ;
3100 9B22 A0 00 00     exit     ldy   #0                       No error flag.
3101 9B25 82 59 05              brl   CMpop8bytes
3102 9B28
3103 9B28                       ENDP 
3104 9B28
3105 9B28
3106 9B28              ;====================================================================
3107 9B28              ;
3108 9B28              ;          Drag a control.
3109 9B28              ;
3110 9B28              ;   IN:    PUSH:WORD - starting x coordinate, in local.
3111 9B28              ;          PUSH:WORD - starting y coordinate, in local.
3112 9B28              ;          PUSH:LONG - pointer to RECT that is bounds of movement, in local.
3113 9B28              ;          PUSH:LONG - pointer to RECT that is cusor limit, in local.
3114 9B28              ;          PUSH:WORD - movement constraint.
3115 9B28              ;          PUSH:LONG - handle of control.
3116 9B28              ;
3117 9B28              ;  OUT:    None.
3118 9B28              ;
3119 9B28              ;====================================================================
3120 9B28              DragControl PROC 
3121 9B28
3122 9B28              theControl equ   inputs
3123 9B28              axis     equ   theControl+4
3124 9B28              slop     equ   axis+2
3125 9B28              limit    equ   slop+4
3126 9B28              starty   equ   limit+4
3127 9B28              startx   equ   starty+2
3128 9B28              ;
3129 9B28              ;
3130 9B28 20 15 A0              jsr   CMStartup                Do setup for tool call.
3131 9B2B              ;
3132 9B2B 20 9F A1              jsr   getCtlHand               Get passed control handle.
3133 9B2E B0 62                 bcs   exit                     Null handle passed?
3134 9B30              ;
3135 9B30              ;
3136 9B30              ; --- Ask control to drag control ---------------------------
3137 9B30              ;
3138 9B30 A0 00 00              ldy   #0                       Drag whole control flag.
3139 9B33 98                    tya   
3140 9B34 A2 07 00              ldx   #dragCntl
3141 9B37 20 2B 9C              jsr   CMDispatch
3142 9B3A AA                    tax                            Do default dragging?
3143 9B3B D0 55                 bne   exit
3144 9B3D              ;
3145 9B3D              ;
3146 9B3D              ; ------ Perform default drag --------------------------------
3147 9B3D              ;
3148 9B3D 64 29                 stz   <param                   Drag whole control flag.
3149 9B3F 20 98 9B              jsr   get_dragrect             Ask control to compute drag RECT.
3150 9B42              ;
3151 9B42              ;
3152 9B42              ; --------- Call drag RECT -----------------------------------------
3153 9B42              ;
3154 9B42 48                    pha                            Space for result.
3155 9B43 48                    pha   
3156 9B44 A9 00 00              lda   #0                       No action routine.
3157 9B47 48                    pha   
3158 9B48 48                    pha   
3159 9B49 A0 F0 00              ldy   #$00F0                   Solid drag pattern.
3160 9B4C 20 5D A2              jsr   set_patt
3161 9B4F DA                    phx   
3162 9B50 5A                    phy   
3163 9B51 D4 5E                 pei   <startx                  Pass starting point.
3164 9B53 D4 5C                 pei   <starty
3165 9B55 20 3F A1              jsr   pushdrag_rect            Pass address of RECT to drag.
3166 9B58 D4 5A                 pei   <limit+2
3167 9B5A D4 58                 pei   <limit
3168 9B5C D4 56                 pei   <slop+2
3169 9B5E D4 54                 pei   <slop
3170 9B60 D4 52                 pei   <axis
3171 9B62 A2 10 1D 22           _DragRect 
3172 9B69 68                    pla                            Get delta y.
3173 9B6A 85 2D                 sta   <work
3174 9B6C 68                    pla                            Get delta x.
3175 9B6D 85 2F                 sta   <work+2
3176 9B6F 05 2D                 ora   <work                    Was there any movement?
3177 9B71 F0 1F                 beq   exit
3178 9B73              ;
3179 9B73              ;
3180 9B73              ; --- Now move control to it's new spot ---------------------
3181 9B73              ;
3182 9B73 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3183 9B76              ;
3184 9B76 A0 0A 00              ldy   #CtlRect+x1              Compute new origin and pass it.
3185 9B79 B7 05                 lda   [<Ctlptr],y
3186 9B7B 18                    clc   
3187 9B7C 65 2F                 adc   <work+2
3188 9B7E 48                    pha   
3189 9B7F 88                    dey   
3190 9B80 88                    dey   
3191 9B81 B7 05                 lda   [<Ctlptr],y
3192 9B83 18                    clc   
3193 9B84 65 2D                 adc   <work
3194 9B86 48                    pha   
3195 9B87 D4 03                 pei   <Ctlhand+2               Pass handle of control.
3196 9B89 D4 01                 pei   <Ctlhand
3197 9B8B A2 10 16 22           _MoveControl 
3198 9B92              ;
3199 9B92              ;
3200 9B92 A0 00 00     exit     ldy   #0                       No error flag.
3201 9B95 82 F8 04              brl   CMpop18bytes
3202 9B98
3203 9B98                       ENDP 
3204 9B98
3205 9B98
3206 9B98              ;====================================================================
3207 9B98              ;
3208 9B98              ;          Ask control to compute drag RECT.
3209 9B98              ;
3210 9B98              ;   IN:    param = zero for whole control, nonzero for part.
3211 9B98              ;
3212 9B98              ;  OUT:    drag_rect = RECT to drag, in local coordinates.
3213 9B98              ;
3214 9B98              ;====================================================================
3215 9B98              get_dragrect PROC 
3216 9B98
3217 9B98 20 3F A1              jsr   pushdrag_rect
3218 9B9B              ;
3219 9B9B A5 29                 lda   <param                   Whole control?
3220 9B9D F0 07                 beq   ok1
3221 9B9F              ;
3222 9B9F A3 03                 lda   3,s                      Get high word of address,
3223 9BA1 09 00 80              ora   #$8000                   Set 'just the part' flag.
3224 9BA4 83 03                 sta   3,s
3225 9BA6              ;
3226 9BA6 68           ok1      pla                            Get pointer to drag_rect with high bit
3227 9BA7 7A                    ply                            set correctly.
3228 9BA8              ;
3229 9BA8              ;
3230 9BA8              ;  a = low word of where to store RECT.
3231 9BA8              ;  y = high word of where to store RECT,
3232 9BA8              ;                                 high bit clear for whole control,
3233 9BA8              ;                                 high bit set for control part.
3234 9BA8              ;
3235 9BA8 A2 01 00              ldx   #calcCRect
3236 9BAB 20 2B 9C              jsr   CMDispatch               Call control.
3237 9BAE AA                    tax   
3238 9BAF D0 20                 bne   exit                     Default?
3239 9BB1              ;
3240 9BB1              ;
3241 9BB1              ; ------ Use default drag RECT -------------------------------------
3242 9BB1              ;
3243 9BB1 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3244 9BB4 A0 08 00              ldy   #CtlRect                 Whole control.
3245 9BB7 A5 2B                 lda   <param+2                 Indicator or whole control?
3246 9BB9 10 03                 bpl   ok2
3247 9BBB A0 28 00              ldy   #Thumb                   Just the indicator.
3248 9BBE A2 7C 00     ok2      ldx   #drag_rect
3249 9BC1 B7 05        lop1     lda   [<Ctlptr],y
3250 9BC3 5A                    phy   
3251 9BC4 9B                    txy   
3252 9BC5 97 41                 sta   [<data],y
3253 9BC7 7A                    ply   
3254 9BC8 C8                    iny   
3255 9BC9 C8                    iny   
3256 9BCA E8                    inx   
3257 9BCB E8                    inx   
3258 9BCC E0 84 00              cpx   #drag_rect+8
3259 9BCF D0 F0                 bne   lop1
3260 9BD1              ;
3261 9BD1 60           exit     rts   
3262 9BD2
3263 9BD2                       ENDP 
3264 9BD2
3265 9BD2
3266 9BD2
3267 9BD2
3268 9BD2              ;====================================================================
3269 9BD2              ;
3270 9BD2              ;                   CallDefProc
3271 9BD2              ;
3272 9BD2              ;                   Calls a controls defproc with the specified inputs.
3273 9BD2              ;
3274 9BD2              ;   IN:  PUSH:LONG - Space for result
3275 9BD2              ;        PUSH:LONG - Control Handle
3276 9BD2              ;        PUSH:WORD - Message to Send
3277 9BD2              ;        PUSH:LONG - Value for Param
3278 9BD2              ;
3279 9BD2              ;  OUT:  PULL:LONG-  Result from DefProc.
3280 9BD2              ;
3281 9BD2              ; Change History
3282 9BD2              ;
3283 9BD2              ; 03 Oct 88         Steven Glass
3284 9BD2              ;
3285 9BD2              ; New today
3286 9BD2              ;
3287 9BD2              ; 06 Oct 88         Steven Glass
3288 9BD2              ;
3289 9BD2              ; Cannot use GetCtlHandle because it expects the handle 
3290 9BD2              ; at Inputs on zero page.
3291 9BD2              ;
3292 9BD2              ;====================================================================
3293 9BD2              CallDefProc PROC 
3294 9BD2
3295 9BD2              TheParam equ   inputs
3296 9BD2              TheMessage equ   TheParam+4
3297 9BD2              TheControl equ   TheMessage+2
3298 9BD2              TheResult equ   TheControl+4
3299 9BD2              ;
3300 9BD2              ;
3301 9BD2 20 15 A0              jsr   CMStartup                Do tool function setup.
3302 9BD5              ;
3303 9BD5 A3 54                 lda   TheControl,s
3304 9BD7 85 01                 sta   ctlHand
3305 9BD9 A3 56                 lda   TheControl+2,s
3306 9BDB 85 03                 sta   ctlHand+2
3307 9BDD 20 E2 A1              jsr   Dereference
3308 9BE0              ;
3309 9BE0 20 DF 96              jsr   set2draw                 Setup to draw standard controls.
3310 9BE3 20 AF 9E              jsr   pushPort                 Save the current port.
3311 9BE6 20 95 97              jsr   set2drawCtl              Setup to draw the control.
3312 9BE9              ;
3313 9BE9 A5 4E                 lda   <TheParam                Pass new view and data sizes.
3314 9BEB A4 50                 ldy   <TheParam+2
3315 9BED A6 52                 ldx   <TheMessage              Task number.
3316 9BEF 20 2B 9C              jsr   CMDispatch
3317 9BF2
3318 9BF2 85 58                 sta   TheResult
3319 9BF4 86 5A                 stx   TheResult+2
3320 9BF6
3321 9BF6 20 C9 9E              jsr   popPort                  Restore the current port.
3322 9BF9              ;
3323 9BF9 A0 00 00     exit     ldy   #0                       No error flag.
3324 9BFC 82 87 04              brl   CMpop10bytes
3325 9BFF
3326 9BFF                       ENDP 
3327 9BFF
3328 9BFF
3329 9BFF                       title 'Param Text Routines' 
3330 9BFF              ;====================================================================
3331 9BFF              ;
3332 9BFF              ;                   SetCtlParamPtr
3333 9BFF              ;
3334 9BFF              ;   Puts the indicated pointer into the global data area.
3335 9BFF              ;
3336 9BFF              ;   IN:  PUSH:LONG - Pointer to sub array
3337 9BFF              ;
3338 9BFF              ;  OUT:  none.
3339 9BFF              ;
3340 9BFF              ; Change History
3341 9BFF              ;
3342 9BFF              ; 21 Oct 88         Steven Glass
3343 9BFF              ;
3344 9BFF              ; New today
3345 9BFF              ;
3346 9BFF              ;====================================================================
3347 9BFF              SetCtlParamPtr PROC 
3348 9BFF
3349 9BFF              ThePtr   equ   inputs
3350 9BFF
3351 9BFF 20 15 A0              jsr   CMStartup                Do tool function setup.
3352 9C02
3353 9C02 A5 4E                 lda   ThePtr
3354 9C04 A0 96 00              ldy   #ParamTextPtr
3355 9C07 97 41                 sta   [<data],y
3356 9C09 C8                    iny   
3357 9C0A C8                    iny   
3358 9C0B A5 50                 lda   ThePtr+2
3359 9C0D 97 41                 sta   [<data],y
3360 9C0F
3361 9C0F A0 00 00              ldy   #0                       No error flag.
3362 9C12 82 62 04              brl   CMpop4bytes
3363 9C15
3364 9C15                       ENDP 
3365 9C15
3366 9C15              ;====================================================================
3367 9C15              ;
3368 9C15              ;                   GetCtlParamPtr
3369 9C15              ;
3370 9C15              ;   Returns the paramtext pointer from the global data area.
3371 9C15              ;
3372 9C15              ;   IN:  PUSH:LONG - space for pointer
3373 9C15              ;
3374 9C15              ;  OUT:  PULL:LONG - pointer to current substitution array.
3375 9C15              ;
3376 9C15              ; Change History
3377 9C15              ;
3378 9C15              ; 21 Oct 88         Steven Glass
3379 9C15              ;
3380 9C15              ; New today
3381 9C15              ;
3382 9C15              ;====================================================================
3383 9C15              GetCtlParamPtr PROC 
3384 9C15
3385 9C15              ThePtr   equ   inputs
3386 9C15
3387 9C15 20 15 A0              jsr   CMStartup                Do tool function setup.
3388 9C18
3389 9C18 A0 96 00              ldy   #ParamTextPtr
3390 9C1B B7 41                 lda   [<data],y
3391 9C1D 85 4E                 sta   ThePtr
3392 9C1F C8                    iny   
3393 9C20 C8                    iny   
3394 9C21 B7 41                 lda   [<data],y
3395 9C23 85 50                 sta   ThePtr+2
3396 9C25
3397 9C25 A0 00 00              ldy   #0                       No error flag.
3398 9C28 82 47 04              brl   CMpop0bytes
3399 9C2B
3400 9C2B                       ENDP 
3401 9C2B
3402 9C2B
3403 9C2B
3404 9C2B
3405 9C2B
3406 9C2B
3407 9C2B
3408 9C2B                       title 'Dispatching Code' 
3409 9C2B              ;====================================================================
3410 9C2B              ;
3411 9C2B              ;          CMDispatch task.
3412 9C2B              ;
3413 9C2B              ;   IN:    x = task.
3414 9C2B              ;          Ctlptr = pointer to control.
3415 9C2B              ;          a = param.
3416 9C2B              ;          y = param+2.
3417 9C2B              ;
3418 9C2B              ;  OUT:    a = low word of returned value.
3419 9C2B              ;          x = high word of returned value.
3420 9C2B              ;
3421 9C2B              ;
3422 9C2B              ; Change History
3423 9C2B              ;
3424 9C2B              ; 05 Oct 88         Steven Glass
3425 9C2B              ;
3426 9C2B              ; Major changes to support super controls.
3427 9C2B              ;
3428 9C2B              ; 11 Oct 88         Steven Glass
3429 9C2B              ;
3430 9C2B              ; Make this routine patchable.
3431 9C2B              ;
3432 9C2B              ; 24 Oct 88         Steven Glass
3433 9C2B              ;
3434 9C2B              ; Added calls to TextEdit and Menu Manager.  Simplified code for
3435 9C2B              ; new builtin procs.
3436 9C2B              ;
3437 9C2B              ; 10 Feb 89         Steven Glass
3438 9C2B              ;
3439 9C2B              ; Changed code that calls load resource so that it will load 
3440 9C2B              ; not use an id with the high bit set (not valid for the resource
3441 9C2B              ; manager.)
3442 9C2B              ;
3443 9C2B              ;====================================================================
3444 9C2B              CMDispatch PROC EXPORT 
3445 9C2B
3446 9C2B 85 29                 sta   <param
3447 9C2D 84 2B                 sty   <param+2
3448 9C2F              ;
3449 9C2F              ;
3450 9C2F                       ENTRY CMDispatch2 
3451 9C2F              CMDispatch2                             ;
3452 9C2F              ;
3453 9C2F              ;   IN:    param = additional parameter.
3454 9C2F              ;
3455 9C2F DA                    phx                            Save.
3456 9C30
3457 9C30
3458 9C30 A2 00 00              ldx   #oCMDispatcher
3459 9C33 5C BC 01 E1           jml   ToolboxPatcher
3460 9C37
3461 9C37
3462 9C37                       EXPORT RealCMDispatcher 
3463 9C37              RealCMDispatcher  
3464 9C37 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
3465 9C3A
3466 9C3A
3467 9C3A              ;-----------------------------------------------------------
3468 9C3A              ;
3469 9C3A              ; See if this is a super control.  If it is, there can 
3470 9C3A              ; be more work to do.  Otherwise, go the old way.
3471 9C3A              ;
3472 9C3A A0 16 00              ldy   #NewCtlRecord.CtlProc+2
3473 9C3D B7 05                 lda   [ctlPtr],y
3474 9C3F 10 1C                 bpl   DoOldWay
3475 9C41
3476 9C41              ;-----------------------------------------------------------
3477 9C41              ;
3478 9C41              ; It is a super control.  Must see if we have pointer to
3479 9C41              ; defproc or an ID.
3480 9C41              ;
3481 9C41 18                    clc                            Assume that it is a pointer
3482 9C42 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags Now, look and see what it really is
3483 9C45 B7 05                 lda   [ctlPtr],y
3484 9C47 29 00 10              and   #FctlProcRefNotPtr
3485 9C4A F0 01                 beq   ItsAPtr
3486 9C4C 38                    sec                            its a resource
3487 9C4D A0 16 00     ItsAPtr  ldy   #NewCtlRecord.CtlProc+2  Get reference into a & y
3488 9C50 B7 05                 lda   [ctlPtr],y               with message in x.
3489 9C52 AA                    tax   
3490 9C53 88                    dey   
3491 9C54 88                    dey   
3492 9C55 B7 05                 lda   [ctlPtr],y
3493 9C57 9B                    txy   
3494 9C58 FA                    plx   
3495 9C59 B0 58                 bcs   CallByThisID
3496 9C5B 80 4B                 bra   CallByThisPtr
3497 9C5D
3498 9C5D              DoOldWay  
3499 9C5D FA                    plx                            Restore.
3500 9C5E A0 14 00              ldy   #CtlProc                 Is this a custom control?
3501 9C61 B7 05                 lda   [<Ctlptr],y
3502 9C63 D0 1C                 bne   do_custom
3503 9C65 C8                    iny   
3504 9C66 B7 05                 lda   [<Ctlptr],y
3505 9C68 D0 17                 bne   do_custom
3506 9C6A              ;
3507 9C6A              ;
3508 9C6A              ; --- Call a standard control definition procedure --------------
3509 9C6A              ;
3510 9C6A C8                    iny   
3511 9C6B B7 05                 lda   [<Ctlptr],y              Get control number.
3512 9C6D              ;
3513 9C6D                       EXPORT standardDispatch 
3514 9C6D              standardDispatch                        ;
3515 9C6D              ;
3516 9C6D DA                    phx                            Save task number.
3517 9C6E 29 FF 7F              and   #$7FFF                   ; Clear off super control bit.
3518 9C71 EB                    xba                            Get standard defProc number into low byte.
3519 9C72 AA                    tax                            Put index into X.
3520 9C73 68                    pla                            Put task number into A.
3521 9C74 7C 77 9C              jmp   (my_procs,x)             Get address of standard procedure.
3522 9C77              ;
3523 9C77 05 A8        my_procs DC W:simp_proc                 Simple button procedure.
3524 9C79 7D AB                 DC W:check_proc                Check box procedure.
3525 9C7B 22 AD                 DC W:radio_proc                Radio button procedure.
3526 9C7D 2C AF                 DC W:scroll_proc               Scroll bar procedure.
3527 9C7F FD AD                 DC W:grow_proc                 Grow box procedure.
3528 9C81              ;
3529 9C81              ;
3530 9C81              ; --- Call a custom control definition procedure ----------------
3531 9C81              ;
3532 9C81 DA           do_custom phx                           Save task number.
3533 9C82 A0 15 00              ldy   #CtlProc+1               Get address of defProc.
3534 9C85 B7 05                 lda   [<Ctlptr],y
3535 9C87 AA                    tax   
3536 9C88 88                    dey   
3537 9C89 B7 05                 lda   [<Ctlptr],y
3538 9C8B 7A                    ply                            Get task number.
3539 9C8C              ;
3540 9C8C              ;
3541 9C8C              ;   IN:    y = task number.
3542 9C8C              ;          a = bytes 0 and 1 of defProc address.
3543 9C8C              ;          x = bytes 1 and 2 of defProc address.
3544 9C8C              ;          param = additional parameters.
3545 9C8C              ;
3546 9C8C                       ENTRY customDispatch 
3547 9C8C              customDispatch                          ;       
3548 9C8C              ;
3549 9C8C D4 03                 pei   <Ctlhand+2               Save current handle of control.
3550 9C8E D4 01                 pei   <Ctlhand
3551 9C90              ;
3552 9C90 48                    pha                            Space for return value.
3553 9C91 48                    pha   
3554 9C92              ;
3555 9C92 5A                    phy                            Pass task number.
3556 9C93              ;
3557 9C93 D4 2B                 pei   <param+2                 Pass additional parameters.
3558 9C95 D4 29                 pei   <param
3559 9C97              ;
3560 9C97 D4 03                 pei   <Ctlhand+2               Pass control's handle.
3561 9C99 D4 01                 pei   <Ctlhand
3562 9C9B              ;
3563 9C9B 22 14 9A FD           jsl   long_call                Call custom defProc.
3564 9C9F 68                    pla                            Get return values.
3565 9CA0 FA                    plx   
3566 9CA1              ;
3567 9CA1 7A                    ply                            Restore Ctlhand.
3568 9CA2 84 01                 sty   <Ctlhand
3569 9CA4 7A                    ply   
3570 9CA5 84 03                 sty   <Ctlhand+2
3571 9CA7              ;
3572 9CA7 60                    rts   
3573 9CA8
3574 9CA8
3575 9CA8
3576 9CA8              ;-----------------------------------------------------------
3577 9CA8              ;
3578 9CA8              ; CallByThisPtr
3579 9CA8              ;
3580 9CA8              ;   Inputs:
3581 9CA8              ;      a-reg  low word of procPtr
3582 9CA8              ;      y-reg  high word of procPtr
3583 9CA8              ;      x-reg  message to send
3584 9CA8              ;
3585 9CA8                       Export CallByThisPtr 
3586 9CA8              CallByThisPtr  
3587 9CA8 DA                    phx                            Put message on stack
3588 9CA9 5A                    phy                            put high word on stack
3589 9CAA 48                    pha                            put low word on stack
3590 9CAB A3 02                 lda   2,s                      get middle and high bytes into x
3591 9CAD AA                    tax   
3592 9CAE 68                    pla                            get low back into a
3593 9CAF 7A                    ply                            ignore high word
3594 9CB0 7A                    ply                            message into y
3595 9CB1 80 D9                 bra   CustomDispatch
3596 9CB3
3597 9CB3              ;-----------------------------------------------------------
3598 9CB3              ;
3599 9CB3              ; CallByThisID
3600 9CB3              ;
3601 9CB3              ;   Inputs:
3602 9CB3              ;      a-reg  low word of ID
3603 9CB3              ;      y-reg  high word of ID
3604 9CB3              ;      x-reg  message to send
3605 9CB3              ;
3606 9CB3              ; this routine has to see if the ID is one of our special
3607 9CB3              ; ID's or if it is a normal resource ID.
3608 9CB3              ;
3609 9CB3              ; The special IDs have the low three bytes set to zero.
3610 9CB3              ; These include the original defprocs as well as 
3611 9CB3              ; new built in defprocs and some new standard non 
3612 9CB3              ; build in defprocs.
3613 9CB3              ;
3614 9CB3                       Export CallByThisID 
3615 9CB3              CallByThisID  
3616 9CB3 DA                    phx                            Save message
3617 9CB4 5A                    phy                            save ID
3618 9CB5 48                    pha   
3619 9CB6 A3 01                 lda   1,s                      Is low word 0
3620 9CB8 D0 2F                 bne   NotSpecial               no
3621 9CBA A3 02                 lda   2,s                      Is middle word 0
3622 9CBC D0 2B                 bne   NotSpecial               no
3623 9CBE A3 04                 lda   4,s                      Yes
3624 9CC0 29 7F 00              and   #$007F                   Clear super ctl bit
3625 9CC3 C9 0F 00              cmp   #LastSpecial+1           Is it in range?
3626 9CC6 B0 21                 bcs   NotSpecial               no
3627 9CC8 0A                    asl   a                        Use as index into table
3628 9CC9 AA                    tax   
3629 9CCA 7C CD 9C              jmp   (WhereTable,x)
3630 9CCD
3631 9CCD              WhereTable  
3632 9CCD 15 9D                 DC W:OldBuiltIn                simpleButtonControl equ $80000000
3633 9CCF 1B 9D                 DC W:DoStatText                statTextControl     equ $81000000
3634 9CD1 15 9D                 DC W:OldBuiltIn                checkControl        equ $82000000
3635 9CD3 50 9D                 DC W:ItsALineEdit              LineEditControl     equ $83000000
3636 9CD5 15 9D                 DC W:OldBuiltIn                radioControl        equ $84000000
3637 9CD7 45 9D                 DC W:ItsATextEdit              TextEditControl     equ $85000000
3638 9CD9 15 9D                 DC W:OldBuiltIn                scrollBarControl    equ $86000000
3639 9CDB 3A 9D                 DC W:ItsAPopUp                 popUpControl        equ $87000000
3640 9CDD 15 9D                 DC W:OldBuiltIn                growControl         equ $88000000
3641 9CDF 2F 9D                 DC W:ItsAList                  listControl         equ $89000000
3642 9CE1 E9 9C                 DC W:NotSpecial                not used???
3643 9CE3 E9 9C                 DC W:NotSpecial                iconButtonControl   equ $8B000000
3644 9CE5 E9 9C                 DC W:NotSpecial                not used 
3645 9CE7 23 9D                 DC W:DoPicture                 pictureControl      equ $8D000000
3646 9CE9
3647 9CE9              LastSpecial equ   (*-WhereTable)>>1
3648 9CE9
3649 9CE9
3650 9CE9              ;-----------------------------------------------------------
3651 9CE9              ;
3652 9CE9              ; NotSpecial
3653 9CE9              ;
3654 9CE9              ; Inputs: (on stack)
3655 9CE9              ;    Msg : WORD
3656 9CE9              ;    ID : LONG
3657 9CE9              ;
3658 9CE9              ; We get here if we have to load the defProc's code resource
3659 9CE9              ;
3660 9CE9              NotSpecial  
3661 9CE9 FA                    plx                            Get ID into a & X
3662 9CEA 68                    pla   
3663 9CEB 29 FF 7F              and   #$7FFF                   Ignore super control bit
3664 9CEE 7A                    ply                            Get message into y
3665 9CEF
3666 9CEF 48                    pha                            Put four bytes on stack for use below
3667 9CF0 48                    pha   
3668 9CF1
3669 9CF1 F4 0C 80              PushWord #rCtlDefProc Push rType and ID for
3670 9CF4 48                    pha                            later
3671 9CF5 DA                    phx   
3672 9CF6
3673 9CF6 5A                    phy                            Save Message
3674 9CF7
3675 9CF7 48                    pha                            Space for result
3676 9CF8 48                    pha   
3677 9CF9 F4 0C 80              PushWord #rCtlDefProc 
3678 9CFC 48                    pha   
3679 9CFD DA                    phx   
3680 9CFE 20 BD 9D              jsr   LoadCodeResource
3681 9D01
3682 9D01 A3 02                 lda   2,s                      put middle word into x
3683 9D03 AA                    tax   
3684 9D04 68                    pla                            low word into a
3685 9D05 7A                    ply                            ignore high word
3686 9D06 7A                    ply                            message
3687 9D07 20 8C 9C              jsr   CustomDispatch
3688 9D0A
3689 9D0A 83 07                 sta   7,s                      put result back into
3690 9D0C 8A                    txa                            space on stack reserved above
3691 9D0D 83 09                 sta   9,s
3692 9D0F
3693 9D0F 20 90 9E              jsr   ReleaseResource          (inputs on stack above)
3694 9D12 68                    pla                            return result in a & x
3695 9D13 FA                    plx   
3696 9D14
3697 9D14 60                    rts   
3698 9D15
3699 9D15              ;-----------------------------------------------------------
3700 9D15              ;
3701 9D15              ; We get here if the Proc is an old style build in
3702 9D15              ; defproc.  We set up the reg and xfer to Standard Dispatch
3703 9D15              ;
3704 9D15              OldBuiltIn  
3705 9D15 68                    pla                            low word of ProcRef
3706 9D16 68                    pla                            high word of ProcRef
3707 9D17 FA                    plx                            Message
3708 9D18 82 52 FF              brl   StandardDispatch
3709 9D1B
3710 9D1B              ;-----------------------------------------------------------
3711 9D1B              ;
3712 9D1B              ; We get here if the control is a static text control.
3713 9D1B              ;
3714 9D1B              ;   Stack is     Msg
3715 9D1B              ;                id high
3716 9D1B              ;                id low
3717 9D1B              ;
3718 9D1B              ; So we setup the regs and branch to CustomDispatch.
3719 9D1B              ;
3720 9D1B              DoStatText  
3721 9D1B A2 BC FD              ldx   #>StatTextProc
3722 9D1E A9 03 BC              lda   #<StatTextProc
3723 9D21
3724 9D21 80 06                 bra   FinishUp
3725 9D23
3726 9D23
3727 9D23              ;-----------------------------------------------------------
3728 9D23              ;
3729 9D23              ; We get here if the control is a picture control
3730 9D23              ;
3731 9D23              ;   Stack is     Msg
3732 9D23              ;                id high
3733 9D23              ;                id low
3734 9D23              ;
3735 9D23              ; So we setup the regs and branch to CustomDispatch.
3736 9D23              ;
3737 9D23 A2 BE FD     DoPicture ldx   #>PicProc
3738 9D26 A9 70 BE              lda   #<PicProc
3739 9D29
3740 9D29 7A           FinishUp ply   
3741 9D2A 7A                    ply   
3742 9D2B 7A                    ply   
3743 9D2C 82 5D FF              brl   CustomDispatch
3744 9D2F
3745 9D2F
3746 9D2F
3747 9D2F              ;-----------------------------------------------------------
3748 9D2F              ;
3749 9D2F              ; ItsAList
3750 9D2F              ;
3751 9D2F              ; We get here if the Proc supposed to be in the list manager.
3752 9D2F              ;
3753 9D2F              ; Inputs: (on stack)
3754 9D2F              ;    Msg : WORD
3755 9D2F              ;    ID : LONG
3756 9D2F              ;
3757 9D2F              ;
3758 9D2F              ItsAList  
3759 9D2F
3760 9D2F 48                    pha   
3761 9D30 48                    pha   
3762 9D31 A2 1C 0E 22           _GetListDefProc 
3763 9D38 80 1F                 bra   JoinExternal
3764 9D3A
3765 9D3A              ;-----------------------------------------------------------
3766 9D3A              ;
3767 9D3A              ; ItsAPopUp
3768 9D3A              ;
3769 9D3A              ; We get here if the Proc supposed to be in the menu manager.
3770 9D3A              ;
3771 9D3A              ; Inputs: (on stack)
3772 9D3A              ;    Msg : WORD
3773 9D3A              ;    ID : LONG
3774 9D3A              ;
3775 9D3A              ;
3776 9D3A              ItsAPopUp  
3777 9D3A
3778 9D3A 48                    pha   
3779 9D3B 48                    pha   
3780 9D3C A2 0F 3B 22           _GetPopUpDefProc 
3781 9D43 80 14                 bra   JoinExternal
3782 9D45
3783 9D45              ;-----------------------------------------------------------
3784 9D45              ;
3785 9D45              ; ItsATextEdit
3786 9D45              ;
3787 9D45              ; We get here if the Proc supposed to be in text edit.
3788 9D45              ;
3789 9D45              ; Inputs: (on stack)
3790 9D45              ;    Msg : WORD
3791 9D45              ;    ID : LONG
3792 9D45              ;
3793 9D45              ;
3794 9D45              ItsATextEdit  
3795 9D45
3796 9D45 48                    pha   
3797 9D46 48                    pha   
3798 9D47 A2 22 22 22           _TEGetDefProc 
3799 9D4E 80 09                 bra   JoinExternal
3800 9D50
3801 9D50              ;-----------------------------------------------------------
3802 9D50              ;
3803 9D50              ; ItsALineEdit
3804 9D50              ;
3805 9D50              ; We get here if the Proc supposed to be the line edit
3806 9D50              ;
3807 9D50              ; Inputs: (on stack)
3808 9D50              ;    Msg : WORD
3809 9D50              ;    ID : LONG
3810 9D50              ;
3811 9D50              ;
3812 9D50              ItsALineEdit  
3813 9D50
3814 9D50 48                    pha   
3815 9D51 48                    pha   
3816 9D52 A2 14 24 22           _GetLEDefProc 
3817 9D59 A3 02        JoinExternal lda   2,s
3818 9D5B AA                    tax   
3819 9D5C A3 01                 lda   1,s
3820 9D5E 7A                    ply   
3821 9D5F 7A                    ply   
3822 9D60
3823 9D60 7A                    ply                            low word of ProcRef
3824 9D61 7A                    ply                            high word of ProcRef
3825 9D62 7A                    ply                            Message
3826 9D63 82 26 FF              brl   CustomDispatch
3827 9D66
3828 9D66
3829 9D66
3830 9D66                       ENDP 
3831 9D66
3832 9D66
3833 9D66              **********************************************************************
3834 9D66              *
3835 9D66              CMLoadResource PROC EXPORT 
3836 9D66              *
3837 9D66              * This is an external entry to the LoadResource call below.
3838 9D66              *
3839 9D66              * Inputs:
3840 9D66              *                   HandleSpace : LONG
3841 9D66              *                   Type        : WORD
3842 9D66              *                   ID          : ID
3843 9D66              *
3844 9D66              * Outputs:
3845 9D66              *                   ResourceHandle
3846 9D66              *
3847 9D66              *
3848 9D66              **********************************************************************
3849 9D66                       DefineStack 
3850 9D66              OrigD    word 
3851 9D66              RTL1     block 3 
3852 9D66              RTL2     block 3 
3853 9D66              TheID    long 
3854 9D66              TheType  word 
3855 9D66              TheHandle word 
3856 9D66
3857 9D66                       import GetAndSetPrefs 
3858 9D66
3859 9D66 0B                    phd   
3860 9D67 3B                    tsc   
3861 9D68 5B                    tcd   
3862 9D69
3863 9D69 48                    pha   
3864 9D6A 48                    pha   
3865 9D6B D4 0D                 pei   TheType
3866 9D6D D4 0B                 pei   TheID+2
3867 9D6F D4 09                 pei   TheID
3868 9D71 20 9C 9D              jsr   LoadResource
3869 9D74
3870 9D74 68                    pla   
3871 9D75 85 0F                 sta   TheHandle
3872 9D77 68                    pla   
3873 9D78 85 11                 sta   TheHandle+2
3874 9D7A
3875 9D7A 2B                    pld   
3876 9D7B A2 00 00              ldx   #0
3877 9D7E A0 06 00              ldy   #6
3878 9D81 5C 84 01 E1           jml   ToStrip
3879 9D85
3880 9D85                       EndP 
3881 9D85
3882 9D85
3883 9D85              **********************************************************************
3884 9D85              *
3885 9D85              CMReleaseResource PROC 
3886 9D85              *
3887 9D85              * This is an external entry to the ReleaseResource call below.
3888 9D85              *
3889 9D85              * Inputs:
3890 9D85              *                   Type        : WORD
3891 9D85              *                   ID          : ID
3892 9D85              *
3893 9D85              * Outputs:
3894 9D85              *                   none
3895 9D85              *
3896 9D85              *
3897 9D85              **********************************************************************
3898 9D85                       DefineStack 
3899 9D85              OrigD    word 
3900 9D85              RTL1     block 3 
3901 9D85              RTL2     block 3 
3902 9D85              TheID    long 
3903 9D85              TheType  word 
3904 9D85
3905 9D85 0B                    phd   
3906 9D86 3B                    tsc   
3907 9D87 5B                    tcd   
3908 9D88
3909 9D88 D4 0D                 pei   TheType
3910 9D8A D4 0B                 pei   TheID+2
3911 9D8C D4 09                 pei   TheID
3912 9D8E 20 90 9E              jsr   ReleaseResource
3913 9D91
3914 9D91 2B                    pld   
3915 9D92 A2 00 00              ldx   #0
3916 9D95 A0 06 00              ldy   #6
3917 9D98 5C 84 01 E1           jml   ToStrip
3918 9D9C
3919 9D9C                       ENDP 
3920 9D9C
3921 9D9C
3922 9D9C              ****************************************************************
3923 9D9C              *
3924 9D9C              LoadResource PROC EXPORT 
3925 9D9C              *
3926 9D9C              * This is the single place we call LoadResource in the control
3927 9D9C              * manager.  We use a single entry point to simplify error 
3928 9D9C              * handling.
3929 9D9C              *
3930 9D9C              * The routine that needs LoadResource, pushes space for the result
3931 9D9C              * the type and id on the stack (just like making the tool call) 
3932 9D9C              * and JSR's here.
3933 9D9C              *
3934 9D9C              * Any error results in a system death.
3935 9D9C              *
3936 9D9C              * Inputs:
3937 9D9C              *                   HandleSpace : LONG
3938 9D9C              *                   Type        : WORD
3939 9D9C              *                   ID          : ID
3940 9D9C              *
3941 9D9C              * Outputs:
3942 9D9C              *                   ResourceHandle
3943 9D9C              *
3944 9D9C              * External Refs:
3945 9D9C              *                   none
3946 9D9C              *
3947 9D9C              * Entry Points:
3948 9D9C                       EXPORT LoadCodeResource 
3949 9D9C                       ENTRY CMDieHorribly 
3950 9D9C              *
3951 9D9C                       longa on                       ; mode
3952 9D9C                       longi on 
3953 9D9C              *
3954 9D9C              ****************************************************************
3955 9D9C
3956 9D9C                       DefineStack 
3957 9D9C              TheOrigD WORD 
3958 9D9C              TheRTS   WORD 
3959 9D9C              TheID    LONG 
3960 9D9C              TheType  WORD 
3961 9D9C              TheHandle LONG 
3962 9D9C
3963 9D9C 0B                    phd   
3964 9D9D 3B                    tsc   
3965 9D9E 5B                    tcd   
3966 9D9F
3967 9D9F 48                    pha   
3968 9DA0 48                    pha   
3969 9DA1 D4 09                 pei   TheType
3970 9DA3 D4 07                 pei   TheID+2
3971 9DA5 D4 05                 pei   TheID
3972 9DA7 A2 1E 0E 22           _LoadResource 
3973 9DAE
3974 9DAE B0 35                 bcs   CMDieHorribly
3975 9DB0
3976 9DB0
3977 9DB0 68                    pla   
3978 9DB1 85 0B                 sta   TheHandle
3979 9DB3 68                    pla   
3980 9DB4 85 0D                 sta   TheHandle+2
3981 9DB6
3982 9DB6              GoodJob   
3983 9DB6 2B                    pld   
3984 9DB7 FA                    plx   
3985 9DB8 68                    pla   
3986 9DB9 68                    pla   
3987 9DBA 68                    pla   
3988 9DBB DA                    phx   
3989 9DBC 60                    rts   
3990 9DBD
3991 9DBD
3992 9DBD 0B           LoadCodeResource phd   
3993 9DBE 3B                    tsc   
3994 9DBF 5B                    tcd   
3995 9DC0
3996 9DC0 48                    pha   
3997 9DC1 48                    pha   
3998 9DC2 D4 09                 pei   TheType
3999 9DC4 D4 07                 pei   TheID+2
4000 9DC6 D4 05                 pei   TheID
4001 9DC8 A2 1E 0E 22           _LoadResource 
4002 9DCF B0 14                 bcs   CMDieHorribly
4003 9DD1
4004 9DD1 68                    pla                            ; deref the handle and return the pointer
4005 9DD2 85 0B                 sta   TheHandle
4006 9DD4 68                    pla   
4007 9DD5 85 0D                 sta   TheHandle+2
4008 9DD7
4009 9DD7 A0 02 00              ldy   #2
4010 9DDA B7 0B                 lda   [TheHandle],y
4011 9DDC AA                    tax   
4012 9DDD A7 0B                 lda   [TheHandle]
4013 9DDF 85 0B                 sta   TheHandle
4014 9DE1 86 0D                 stx   TheHandle+2
4015 9DE3 80 D1                 bra   GoodJob
4016 9DE5
4017 9DE5
4018 9DE5              ;-----------------------------------------------------------
4019 9DE5              ;
4020 9DE5              ; The load failed, so bring us all down!
4021 9DE5              ;
4022 9DE5
4023 9DE5              RamToTrash equ   $0002A0
4024 9DE5
4025 9DE5
4026 9DE5              CMDieHorribly  
4027 9DE5 85 0B                 sta   TheHandle
4028 9DE7
4029 9DE7 F4 FD 00 F4           PushLong #DeathMsg 
4030 9DED F4 00 00 F4           PushLong #RamToTrash 
4031 9DF3 AF 3E 9E FD           lda   >DeathMsg
4032 9DF7 29 FF 00              and   #$00FF
4033 9DFA F4 00 00              pea   $0000
4034 9DFD 48                    pha   
4035 9DFE A2 02 2B 22           _BlockMove 
4036 9E05
4037 9E05 A5 05                 lda   TheID
4038 9E07 20 83 9E              jsr   HexIt
4039 9E0A 8F D7 02 00           sta   >RamToTrash+IDStart-DeathMsg+4
4040 9E0E 8A                    txa   
4041 9E0F 8F D9 02 00           sta   >RamToTrash+IDStart-DeathMsg+6
4042 9E13
4043 9E13 A5 07                 lda   TheID+2
4044 9E15 20 83 9E              jsr   HexIt
4045 9E18 8F D3 02 00           sta   >RamToTrash+IDStart-DeathMsg
4046 9E1C 8A                    txa   
4047 9E1D 8F D5 02 00           sta   >RamToTrash+IDStart-DeathMsg+2
4048 9E21
4049 9E21 A5 09                 lda   TheType
4050 9E23 20 83 9E              jsr   HexIt
4051 9E26 8F C8 02 00           sta   >RamToTrash+TypeStart-DeathMsg
4052 9E2A 8A                    txa   
4053 9E2B 8F CA 02 00           sta   >RamToTrash+TypeStart-DeathMsg+2
4054 9E2F
4055 9E2F
4056 9E2F D4 0B                 pei   TheHandle
4057 9E31 F4 00 00 F4           PushLong #RamToTrash 
4058 9E37 A2 03 15 22           _SysFailMgr 
4059 9E3E
4060 9E3E 44           DeathMsg DC B:EndMsg-StartMsg
4061 9E3F 43 6F 75 6C  StartMsg DC B:'Could not load/unload resource.',13
4062 9E5F 20 20 54 79           DC B:'  Type='
4063 9E66 20 20 20 20  TypeStart DC B:'    .',13
4064 9E6C 20 20 49 44           DC B:'  ID='
4065 9E71 20 20 20 20  IDStart  DC B:'        .',13
4066 9E7B 20 20 45 72           DC B:'  Error='
4067 9E83              EndMsg    
4068 9E83
4069 9E83 48           HexIt    pha   
4070 9E84 48                    pha   
4071 9E85 48                    pha   
4072 9E86 A2 0B 2A 22           _HexIt 
4073 9E8D 68                    pla   
4074 9E8E FA                    plx   
4075 9E8F 60                    rts   
4076 9E90
4077 9E90                       ENDP 
4078 9E90
4079 9E90
4080 9E90
4081 9E90
4082 9E90              ****************************************************************
4083 9E90              *
4084 9E90              ReleaseResource PROC EXPORT 
4085 9E90              *
4086 9E90              * This is the single place we call LoadResource in the control
4087 9E90              * manager.  We use a single entry point to simplify error 
4088 9E90              * handling.
4089 9E90              *
4090 9E90              * The routine that needs LoadResource, pushes space for the result
4091 9E90              * the type and id on the stack (just like making the tool call) 
4092 9E90              * and JSR's here.
4093 9E90              *
4094 9E90              * Any error results in a system death.
4095 9E90              *
4096 9E90              * Inputs:
4097 9E90              *                   Type        : WORD
4098 9E90              *                   ID          : ID
4099 9E90              *
4100 9E90              * Outputs:
4101 9E90              *                   none
4102 9E90              *
4103 9E90              * External Refs:
4104 9E90                       import CMDieHorribly 
4105 9E90              *
4106 9E90              * Entry Points:
4107 9E90              *
4108 9E90                       longa on                       ; mode
4109 9E90                       longi on 
4110 9E90              *
4111 9E90              ****************************************************************
4112 9E90
4113 9E90                       DefineStack 
4114 9E90              TheOrigD WORD 
4115 9E90              TheRTS   WORD 
4116 9E90              TheID    LONG 
4117 9E90              TheType  WORD 
4118 9E90
4119 9E90
4120 9E90 0B                    phd   
4121 9E91 3B                    tsc   
4122 9E92 5B                    tcd   
4123 9E93
4124 9E93 F4 03 00              PushWord #$0003                ; purge level
4125 9E96 D4 09                 pei   TheType
4126 9E98 D4 07                 pei   TheID+2
4127 9E9A D4 05                 pei   TheID
4128 9E9C A2 1E 17 22           _ReleaseResource 
4129 9EA3 90 03                 bcc   GoodJob
4130 9EA5 4C E5 9D              jmp   CMDieHorribly
4131 9EA8
4132 9EA8              GoodJob   
4133 9EA8 2B                    pld   
4134 9EA9 FA                    plx   
4135 9EAA 68                    pla   
4136 9EAB 68                    pla   
4137 9EAC 68                    pla   
4138 9EAD DA                    phx   
4139 9EAE 60                    rts   
4140 9EAF
4141 9EAF
4142 9EAF                       ENDP 
4143 9EAF
4144 9EAF
4145 9EAF
4146 9EAF                       TITLE 'Control Manager Utilities' 
4147 9EAF
4148 9EAF              ;====================================================================
4149 9EAF              ;
4150 9EAF              ;          Push the contents of the current port.
4151 9EAF              ;
4152 9EAF              ;====================================================================
4153 9EAF              pushPort proc EXPORT 
4154 9EAF
4155 9EAF FA                    plx                            Get return address.
4156 9EB0 3B                    tsc                            Allocate space for port info.
4157 9EB1 38                    sec   
4158 9EB2 E9 70 00              sbc   #112
4159 9EB5 1B                    tcs   
4160 9EB6 DA                    phx                            Put return address back.
4161 9EB7              ;
4162 9EB7 20 E3 9E              jsr   getSavePtr
4163 9EBA              ;
4164 9EBA A0 6E 00              ldy   #110
4165 9EBD B7 2D        lop1     lda   [<work],y
4166 9EBF 97 31                 sta   [<work+4],y
4167 9EC1 88                    dey   
4168 9EC2 88                    dey   
4169 9EC3 10 F8                 bpl   lop1
4170 9EC5              ;
4171 9EC5 20 0D 9F              jsr   popSave
4172 9EC8
4173 9EC8 60                    rts   
4174 9EC9
4175 9EC9
4176 9EC9              ; = = = = = = = = = = = = = = = = = = = = = = = = =
4177 9EC9              ;          Put content of port off stack.
4178 9EC9              ;100= = = = = = = = = = = = = = = = = = = = = = = =
4179 9EC9              ;
4180 9EC9                       EXPORT popPort 
4181 9EC9              popPort                                 ;
4182 9EC9              ;
4183 9EC9 20 E3 9E              jsr   getSavePtr
4184 9ECC              ;
4185 9ECC A0 6E 00              ldy   #110
4186 9ECF B7 31        lop100   lda   [<work+4],y
4187 9ED1 97 2D                 sta   [<work],y
4188 9ED3 88                    dey   
4189 9ED4 88                    dey   
4190 9ED5 10 F8                 bpl   lop100
4191 9ED7              ;
4192 9ED7 20 0D 9F              jsr   popSave
4193 9EDA              ;
4194 9EDA FA                    plx                            Get return address.
4195 9EDB 3B                    tsc   
4196 9EDC 18                    clc   
4197 9EDD 69 70 00              adc   #112
4198 9EE0 1B                    tcs   
4199 9EE1 DA                    phx                            Put return address back.
4200 9EE2              ;
4201 9EE2 60                    rts   
4202 9EE3
4203 9EE3
4204 9EE3              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4205 9EE3              ;          Compute pointer to part of port to save.
4206 9EE3              ;110= = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4207 9EE3              ;
4208 9EE3 FA           getSavePtr plx   
4209 9EE4 D4 33                 pei   <work+6                  Save.
4210 9EE6 D4 31                 pei   <work+4
4211 9EE8 D4 2F                 pei   <work+2
4212 9EEA D4 2D                 pei   <work
4213 9EEC DA                    phx   
4214 9EED              ;
4215 9EED 48                    pha                            Get pointer to current port.
4216 9EEE 48                    pha   
4217 9EEF A2 04 1C 22           _GetPort 
4218 9EF6 68                    pla   
4219 9EF7 FA                    plx   
4220 9EF8 18                    clc   
4221 9EF9 69 20 00              adc   #$0020
4222 9EFC 90 01                 bcc   store110
4223 9EFE E8                    inx   
4224 9EFF 85 2D        store110 sta   <work
4225 9F01 86 2F                 stx   <work+2
4226 9F03              ;
4227 9F03 3B                    tsc                            Compute pointer into stack.
4228 9F04 18                    clc   
4229 9F05 69 0D 00              adc   #13
4230 9F08 85 31                 sta   <work+4
4231 9F0A 64 33                 stz   <work+6
4232 9F0C 60                    rts   
4233 9F0D              ;
4234 9F0D              ;
4235 9F0D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4236 9F0D              ;
4237 9F0D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4238 9F0D              ;
4239 9F0D FA           popSave  plx   
4240 9F0E 68                    pla                            Restore.
4241 9F0F 85 2D                 sta   <work
4242 9F11 68                    pla   
4243 9F12 85 2F                 sta   <work+2
4244 9F14 68                    pla   
4245 9F15 85 31                 sta   <work+4
4246 9F17 68                    pla   
4247 9F18 85 33                 sta   <work+6
4248 9F1A DA                    phx   
4249 9F1B
4250 9F1B 60                    rts   
4251 9F1C              ;
4252 9F1C                       ENDP 
4253 9F1C
4254 9F1C
4255 9F1C              ;====================================================================
4256 9F1C              ;
4257 9F1C              ;          Set text color and writing mode.
4258 9F1C              ;
4259 9F1C              ;   IN:    a = normal color index into color table.
4260 9F1C              ;          colorptr = pointer to color table.
4261 9F1C              ;          state = 0 for normal, 2 for hilited.
4262 9F1C              ;
4263 9F1C              ;====================================================================
4264 9F1C              set_textmode proc EXPORT 
4265 9F1C
4266 9F1C A0 50 00              ldy   #state
4267 9F1F 18                    clc   
4268 9F20 77 41                 adc   [<data],y
4269 9F22 A8                    tay   
4270 9F23 B7 11                 lda   [<colorptr],y
4271 9F25 48                    pha                            Save color.
4272 9F26 29 0F 00              and   #$000F                   Just text color.
4273 9F29 20 58 9F              jsr   smear                    Duplicate color in all 4 nibbles.
4274 9F2C 48                    pha                            Pass color of title.
4275 9F2D A2 04 A0 22           _SetForeColor                  Set text color.
4276 9F34              ;
4277 9F34 68                    pla                            Restore saved color.
4278 9F35 29 F0 00              and   #$00F0
4279 9F38 48                    pha   
4280 9F39 4A                    lsr   a                        Get background color.
4281 9F3A 4A                    lsr   a
4282 9F3B 4A                    lsr   a
4283 9F3C 4A                    lsr   a
4284 9F3D 03 01                 ora   1,s
4285 9F3F 83 01                 sta   1,s
4286 9F41 EB                    xba   
4287 9F42 03 01                 ora   1,s
4288 9F44 83 01                 sta   1,s
4289 9F46 A2 04 A2 22           _SetBackColor 
4290 9F4D              ;
4291 9F4D F4 00 00              pea   0                        Copy mode.
4292 9F50 A2 04 9C 22           _SetTextMode 
4293 9F57              ;
4294 9F57 60                    rts   
4295 9F58
4296 9F58                       ENDP 
4297 9F58
4298 9F58
4299 9F58              ;====================================================================
4300 9F58              ;
4301 9F58              ;          Smear color into all 4 nibbles.
4302 9F58              ;
4303 9F58              ;   IN:    a = low nibble is color.
4304 9F58              ;
4305 9F58              ;  OUT:    a = low nibble duplicated into all 4 nibbles.
4306 9F58              ;          x = trash.
4307 9F58              ;
4308 9F58              ;====================================================================
4309 9F58              smear    proc EXPORT 
4310 9F58              ;
4311 9F58 29 0F 00              and   #$000F
4312 9F5B 48                    pha   
4313 9F5C 0A                    asl   a
4314 9F5D 0A                    asl   a
4315 9F5E 0A                    asl   a
4316 9F5F 0A                    asl   a
4317 9F60 03 01                 ora   1,s
4318 9F62 83 01                 sta   1,s
4319 9F64 EB                    xba   
4320 9F65 03 01                 ora   1,s
4321 9F67 FA                    plx   
4322 9F68
4323 9F68 60                    rts   
4324 9F69
4325 9F69                       ENDP 
4326 9F69
4327 9F69
4328 9F69              ;====================================================================
4329 9F69              ;
4330 9F69              ;          New icon font.
4331 9F69              ;
4332 9F69              ;   IN:    a,x = handle of new icon font.
4333 9F69              ;
4334 9F69              ;====================================================================
4335 9F69              SetIconFont proc EXPORT 
4336 9F69
4337 9F69 A0 44 00              ldy   #ctl_font                Store new handle in global variable.
4338 9F6C 97 41                 sta   [<data],y
4339 9F6E C8                    iny   
4340 9F6F C8                    iny   
4341 9F70 8A                    txa   
4342 9F71 97 41                 sta   [<data],y
4343 9F73              ;
4344 9F73              ; --- Get parameters of new icon font -----------------------------------
4345 9F73              ;
4346 9F73 A2 08 00              ldx   #UP_ARROW                Get size of up arrow icon.
4347 9F76 DA           lop110   phx   
4348 9F77 20 93 A3              jsr   get_csize
4349 9F7A FA                    plx   
4350 9F7B              ;
4351 9F7B A0 21 00              ldy   #rect2+y2                Save height.
4352 9F7E B7 41                 lda   [<data],y
4353 9F80 48                    pha   
4354 9F81 BF 35 A4 FD           lda   >arrowMap-UP_ARROW,x
4355 9F85 A8                    tay   
4356 9F86 68                    pla   
4357 9F87 97 41                 sta   [<data],y
4358 9F89 C8                    iny   
4359 9F8A C8                    iny   
4360 9F8B 5A                    phy   
4361 9F8C A0 23 00              ldy   #rect2+x2                Save width.
4362 9F8F B7 41                 lda   [<data],y
4363 9F91 7A                    ply   
4364 9F92 97 41                 sta   [<data],y
4365 9F94              ;
4366 9F94 E8                    inx   
4367 9F95 E8                    inx   
4368 9F96 E0 10 00              cpx   #RITE_ARROW+2
4369 9F99 D0 DB                 bne   lop110
4370 9F9B              ;
4371 9F9B 60                    rts   
4372 9F9C
4373 9F9C                       ENDP 
4374 9F9C
4375 9F9C
4376 9F9C              ;====================================================================
4377 9F9C              ;
4378 9F9C              ;          Perform initialization for
4379 9F9C              ;          resolution specific values.
4380 9F9C              ;
4381 9F9C              ;====================================================================
4382 9F9C              newResGuts proc EXPORT 
4383 9F9C                       import ComputeScrollColor 
4384 9F9C
4385 9F9C 48                    pha                            Space for result.
4386 9F9D A2 04 17 22           _GetMasterSCB 
4387 9FA4 68                    pla   
4388 9FA5 A0 4A 00              ldy   #GraphicsMode
4389 9FA8 29 80 00              and   #$0080                   Mask off mode bit.
4390 9FAB 97 41                 sta   [<data],y                Remember mode.
4391 9FAD F0 0B                 beq   mode320
4392 9FAF              ;
4393 9FAF              ;
4394 9FAF              ; --- Initialize for 640 mode ------------------------------
4395 9FAF              ;
4396 9FAF A0 02 00              ldy   #2                       640 mode vertical line width = 2.
4397 9FB2 A9 07 A6              lda   #Ctl640                  640 icon font.
4398 9FB5 A2 10 00              ldx   #16                      Minimum horizontal thumb size in 640.
4399 9FB8 80 09                 bra   enter1
4400 9FBA              ;
4401 9FBA              ;
4402 9FBA              ; --- Initialize for 320 mode ------------------------------
4403 9FBA              ;
4404 9FBA              mode320   
4405 9FBA A0 01 00              ldy   #1                       320 mode vertical line width = 1.
4406 9FBD A2 08 00              ldx   #8                       Minimum horizontal thumb size in 320.
4407 9FC0 A9 BD A4              lda   #Ctl320                  320 icon font.
4408 9FC3              ;
4409 9FC3 48           enter1   pha   
4410 9FC4 98                    tya   
4411 9FC5 A0 48 00              ldy   #vert_pen                Store vertical line width to use.
4412 9FC8 97 41                 sta   [<data],y
4413 9FCA 68                    pla   
4414 9FCB              ;
4415 9FCB A0 30 00              ldy   #fontHandle              Store font pointer in fake handle.
4416 9FCE 97 41                 sta   [<data],y
4417 9FD0 C8                    iny   
4418 9FD1 C8                    iny   
4419 9FD2 A9 FD 00              lda   #Ctl320>>16
4420 9FD5 97 41                 sta   [<data],y
4421 9FD7              ;
4422 9FD7 A0 4C 00              ldy   #min_thumb               Store minimum thumb size.
4423 9FDA 8A                    txa   
4424 9FDB 97 41                 sta   [<data],y
4425 9FDD              ;
4426 9FDD 20 2B A1              jsr   pushfontHandle
4427 9FE0 68                    pla   
4428 9FE1 FA                    plx   
4429 9FE2 20 69 9F              jsr   SetIconFont              Save icon font handle, set parameters.
4430 9FE5              ;
4431 9FE5 60                    rts   
4432 9FE6
4433 9FE6                       EndP 
4434 9FE6
4435 9FE6
4436 9FE6              ;====================================================================
4437 9FE6              ;
4438 9FE6              ;          Call SetWAP.
4439 9FE6              ;
4440 9FE6              ;   IN:    a,y = value to set.
4441 9FE6              ;
4442 9FE6              ;====================================================================
4443 9FE6              setWAP   proc EXPORT 
4444 9FE6
4445 9FE6 F4 00 00              pea   0                        Pass system flag.
4446 9FE9 F4 10 00              pea   CtlToolNum               Pass Window Manager tool number.
4447 9FEC 5A                    phy                            Pass value.
4448 9FED 48                    pha   
4449 9FEE A2 01 0D 22           _SetWAP 
4450 9FF5
4451 9FF5 60                    rts                            Return error code from SetWAP.
4452 9FF6
4453 9FF6                       ENDP 
4454 9FF6
4455 9FF6
4456 9FF6              ;====================================================================
4457 9FF6              ;
4458 9FF6              ;          Allocate a block of memory.
4459 9FF6              ;
4460 9FF6              ;   IN:    a = number of bytes to allocate.
4461 9FF6              ;          MyID = ID to use.
4462 9FF6              ;
4463 9FF6              ;  OUT:    Carry clear if handle allocated, a+x = handle.
4464 9FF6              ;          Carry set if error, y = error returned by Memory Manager.
4465 9FF6              ;
4466 9FF6              ;====================================================================
4467 9FF6              allocate proc EXPORT 
4468 9FF6
4469 9FF6 48                    pha                            Save number of bytes.
4470 9FF7 A0 36 00              ldy   #MyID                    Get ID number.
4471 9FFA B7 41                 lda   [<data],y
4472 9FFC A8                    tay                            y = ID number to use to allocate.
4473 9FFD 68                    pla                            a = number of bytes to allocate.
4474 9FFE
4475 9FFE
4476 9FFE              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4477 9FFE              ;
4478 9FFE              ;          Allocate a block of memory.
4479 9FFE              ;
4480 9FFE              ;   IN:    y = ID number.
4481 9FFE              ;          a = number of bytes.
4482 9FFE              ;
4483 9FFE              ;  OUT:    Carry clear if handle allocated, a+x = handle.
4484 9FFE              ;          Carry set if error, y = error returned by Memory Manager.
4485 9FFE              ;
4486 9FFE              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4487 9FFE                       EXPORT CMAllocate2 
4488 9FFE              CMAllocate2                             ;
4489 9FFE
4490 9FFE A2 10 40              ldx   #%0100000000010000       Fixed, May not cross bank boundary.
4491 A001
4492 A001
4493 A001              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4494 A001              ;
4495 A001              ;          Allocate a block of memory.
4496 A001              ;
4497 A001              ;   IN:    y = ID number.
4498 A001              ;          x = attributes.
4499 A001              ;          a = number of bytes.
4500 A001              ;
4501 A001              ;  OUT:    Carry clear if handle allocated, a+x = handle.
4502 A001              ;          Carry set if error, y = error returned by Memory Manager.
4503 A001              ;
4504 A001              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4505 A001                       EXPORT CMAllocate3 
4506 A001              CMAllocate3                             ;
4507 A001              ;
4508 A001 48                    pha                            Space for returned handle.
4509 A002 48                    pha   
4510 A003 F4 00 00              pea   0                        High word of size.
4511 A006 48                    pha                            Pass low word of size.
4512 A007 5A                    phy                            Pass ID number.
4513 A008 DA                    phx                            Pass attributes.
4514 A009 48                    pha                            Address doesn't matter.
4515 A00A 48                    pha   
4516 A00B A2 02 09 22           _NewHandle 
4517 A012 68                    pla                            Return handle.
4518 A013 FA                    plx   
4519 A014
4520 A014 60                    rts   
4521 A015
4522 A015                       ENDP 
4523 A015
4524 A015
4525 A015              ;====================================================================
4526 A015              ;          Do setup for tool call.
4527 A015              ;
4528 A015              ;   IN:    a+y = handle to data area.
4529 A015              ;
4530 A015              ;  OUT:    Carry clear if no error.
4531 A015              ;          Carry set if null data pointer, y = error code.
4532 A015              ;
4533 A015              ;150=================================================================
4534 A015              CMstartup proc EXPORT 
4535 A015
4536 A015 FA                    plx                            Get return address.
4537 A016              ;
4538 A016 0B                    phd                            Save caller's direct page.
4539 A017 8B                    phb                            Save caller's data page.
4540 A018              ;
4541 A018 5A                    phy                            Save pointer to data area.
4542 A019 48                    pha   
4543 A01A              ;
4544 A01A DA                    phx   
4545 A01B              ;
4546 A01B 48                    pha                            Space for result.
4547 A01C 48                    pha   
4548 A01D A2 04 1C 22           _GetPort 
4549 A024 68                    pla   
4550 A025 7A                    ply   
4551 A026 FA                    plx                            Get return addess.
4552 A027 5A                    phy                            Save caller's port on stack.
4553 A028 48                    pha   
4554 A029              ;
4555 A029 3B                    tsc                            Allocate direct page on stack.
4556 A02A 38                    sec   
4557 A02B E9 3C 00              sbc   #DIRECTSIZE
4558 A02E 1B                    tcs   
4559 A02F 5B                    tcd   
4560 A030
4561 A030              ;
4562 A030 DA                    phx                            Put return address back on stack.
4563 A031              ;
4564 A031 A5 41                 lda   <data                    Valid data area pointer passed.
4565 A033 05 43                 ora   <data+2
4566 A035 18                    clc                            Clear error flag.
4567 A036 D0 39                 bne   exit
4568 A038              ;
4569 A038 F4 02 10              pea   $1002                    Control Manager not started.
4570 A03B F4 FD 00              pea   notInit>>16              Pass message.
4571 A03E F4 48 A0              pea   notInit
4572 A041 A2 03 15 22           _SysFailMgr 
4573 A048              ;
4574 A048 28           notInit  DC B:40
4575 A049 43 6F 6E 74           DC B:'Control Manager not initialized, error $'
4576 A071              ;
4577 A071 60           exit     rts   
4578 A072              ;
4579 A072              ;
4580 A072              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
4581 A072              ;          Entry points for function exits.
4582 A072              ;200= = = = = = = = = = = = = = = = = = = = = = = = = =
4583 A072              ;
4584 A072                       EXPORT CMpop0bytes 
4585 A072              CMpop0bytes                             ;
4586 A072 A2 00 00              ldx   #0
4587 A075 80 28                 bra   shutdown
4588 A077              ;
4589 A077                       EXPORT CMpop4bytes 
4590 A077              CMpop4bytes                             ;
4591 A077 A2 04 00              ldx   #4
4592 A07A 80 23                 bra   shutdown
4593 A07C              ;
4594 A07C                       EXPORT CMpop6bytes 
4595 A07C              CMpop6bytes                             ;
4596 A07C A2 06 00              ldx   #6
4597 A07F 80 1E                 bra   shutdown
4598 A081              ;
4599 A081                       EXPORT CMpop8bytes 
4600 A081              CMpop8bytes                             ;
4601 A081 A2 08 00              ldx   #8
4602 A084 80 19                 bra   shutdown
4603 A086              ;
4604 A086                       EXPORT CMpop10bytes 
4605 A086              CMpop10bytes                            ;
4606 A086 A2 0A 00              ldx   #10
4607 A089 80 14                 bra   shutdown
4608 A08B              ;
4609 A08B                       EXPORT CMpop12bytes 
4610 A08B              CMpop12bytes                            ;
4611 A08B A2 0C 00              ldx   #12
4612 A08E 80 0F                 bra   shutdown
4613 A090              ;
4614 A090                       EXPORT CMpop18bytes 
4615 A090              CMpop18bytes                            ;
4616 A090 A2 12 00              ldx   #18
4617 A093 80 0A                 bra   shutdown
4618 A095              ;
4619 A095                       EXPORT CMpop26bytes 
4620 A095              CMpop26bytes                            ;
4621 A095 A2 1A 00              ldx   #26
4622 A098 80 05                 bra   shutdown
4623 A09A              ;
4624 A09A                       EXPORT CMpop32bytes 
4625 A09A              CMpop32bytes                            ;
4626 A09A A2 20 00              ldx   #32
4627 A09D 80 00                 bra   shutdown
4628 A09F
4629 A09F              ;
4630 A09F              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4631 A09F              ;
4632 A09F              ;          Undo setup for tool call.
4633 A09F              ;
4634 A09F              ;  IN:     y = error code, zero if no error.
4635 A09F              ;          x = number of bytes to pop.
4636 A09F              ;          Startup must have been called.
4637 A09F              ;
4638 A09F              ;250= = = = = = = = = = = = = = = = = = = = = = = = = = =
4639 A09F              shutdown                                ; 
4640 A09F              ;
4641 A09F 5A                    phy                            Save error code.
4642 A0A0 DA                    phx                            Save number of byte to pop.
4643 A0A1 D4 3F                 pei   <savePort+2              Restore caller's port.
4644 A0A3 D4 3D                 pei   <savePort
4645 A0A5 A2 04 1B 22           _SetPort 
4646 A0AC FA                    plx                            Restore number of bytes to pop.
4647 A0AD 7A                    ply                            Restore error code.
4648 A0AE              ;
4649 A0AE              ;
4650 A0AE              ; --- Restore saved parameters from startupCall --------------------------
4651 A0AE              ;
4652 A0AE 3B                    tsc                            Free direct page allocated on stack.
4653 A0AF 18                    clc   
4654 A0B0 69 44 00              adc   #DIRECTSIZE+8            (Get rid of data area pointer and port).
4655 A0B3 1B                    tcs   
4656 A0B4              ;
4657 A0B4 AB                    plb                            Restore original data bank.
4658 A0B5              ;
4659 A0B5              ;
4660 A0B5              ; --- Move return addresses over top of input parameters -----------------
4661 A0B5              ;
4662 A0B5 3B                    tsc   
4663 A0B6 5B                    tcd   
4664 A0B7 A3 07                 lda   7,s
4665 A0B9 95 07                 sta   7,x
4666 A0BB A3 05                 lda   5,s
4667 A0BD 95 05                 sta   5,x
4668 A0BF A3 03                 lda   3,s
4669 A0C1 95 03                 sta   3,x
4670 A0C3              ;
4671 A0C3              ;
4672 A0C3              ; --- Adjust stact for popped parameters ---
4673 A0C3              ;
4674 A0C3 2B                    pld                            Get original direct page pointer.
4675 A0C4              ;
4676 A0C4 3B                    tsc                            Current stack,
4677 A0C5 DA                    phx   
4678 A0C6 18                    clc   
4679 A0C7 63 01                 adc   1,s                      plus number of bytes popped,
4680 A0C9 1B                    tcs                            equals new stack.
4681 A0CA              ;
4682 A0CA 98                    tya                            Return error code in Y.
4683 A0CB C9 01 00              cmp   #1                       Set carry if error.
4684 A0CE
4685 A0CE 6B                    rtl   
4686 A0CF              ;
4687 A0CF              ;
4688 A0CF              ;====================================================================
4689 A0CF              ;        ( op1 * op2 ) / op3
4690 A0CF              ;
4691 A0CF              ;   IN:  x = op1.
4692 A0CF              ;        y = op2.
4693 A0CF              ;        a = op3.
4694 A0CF              ;
4695 A0CF              ;  OUT:  x = result.
4696 A0CF              ;300=================================================================
4697 A0CF              ;        EXPORT fraction
4698 A0CF              fraction proc export 
4699 A0CF              ;
4700 A0CF 48                    pha                            Save op3.
4701 A0D0              ;
4702 A0D0 48                    pha                            Space for LongDivide remainder high.
4703 A0D1 48                    pha                            Space for LongDivide remainder low.
4704 A0D2              ;
4705 A0D2 48                    pha                            Space for LongDivide quotient high.
4706 A0D3 48                    pha                            Space for LongDivide quotient low.
4707 A0D4              ;
4708 A0D4              ;
4709 A0D4              ; --- ( op1 * op2 ) ------------------------------
4710 A0D4              ;
4711 A0D4 48                    pha                            Space for Multiply result.
4712 A0D5 48                    pha                            Space for Multiply result.
4713 A0D6              ;
4714 A0D6 DA                    phx                            Pass op1.
4715 A0D7 5A                    phy                            Pass op2.
4716 A0D8 A2 0B 09 22           _Multiply 
4717 A0DF              ;
4718 A0DF              ;
4719 A0DF              ; --- ( Result ) / op3 ---------------------------
4720 A0DF              ;
4721 A0DF              ;                                       Space for result already on stack.
4722 A0DF              ;                                       Numerator is multiply result on stack.
4723 A0DF F4 00 00              pea   0                        Pass high word of op3 as denominator.
4724 A0E2 A3 0B                 lda   11,s
4725 A0E4 48                    pha                            Pass low word of op3 as denominator.
4726 A0E5 A2 0B 0D 22           _LongDivide 
4727 A0EC              ;
4728 A0EC              ;
4729 A0EC              ; --- Round off quotient --------------------------
4730 A0EC              ;
4731 A0EC FA                    plx                            Quotient.
4732 A0ED A3 07                 lda   7,s                      Get op3.
4733 A0EF 4A                    lsr   a                        Halve of that.
4734 A0F0 C3 03                 cmp   3,s                      Is it greater that the remainder?
4735 A0F2 B0 01                 bcs   skip300
4736 A0F4 E8                    inx                            Round up.
4737 A0F5              ;
4738 A0F5              ;
4739 A0F5              ; --- Fix up stack and exit ------------------------
4740 A0F5              ;
4741 A0F5 68           skip300  pla                            Pull quotient high word.
4742 A0F6 68                    pla                            Pull remainder low word.
4743 A0F7 68                    pla                            Pull remainder high word.
4744 A0F8              ;
4745 A0F8 68                    pla                            Pull op3.
4746 A0F9
4747 A0F9 60                    rts                            x = result.
4748 A0FA              ;
4749 A0FA              ;
4750 A0FA              ;====================================================================
4751 A0FA              ;
4752 A0FA              ;          Set pen color.
4753 A0FA              ;
4754 A0FA              ;   IN:    <colorptr = pointer to a color table.
4755 A0FA              ;          y = offset into the color table.
4756 A0FA              ;
4757 A0FA              ;350=================================================================
4758 A0FA              ;        EXPORT pen_color
4759 A0FA              pen_color proc export 
4760 A0FA              ;
4761 A0FA 20 05 A1              jsr   pushcolor
4762 A0FD A2 04 30 22           _SetPenPat 
4763 A104
4764 A104 60                    rts   
4765 A105
4766 A105
4767 A105              ;====================================================================
4768 A105              ;
4769 A105              ;          Push a pointer to a color patteren.
4770 A105              ;
4771 A105              ;   IN:    colorptr = pointer to a color table.
4772 A105              ;          y = offset into the color table.
4773 A105              ;
4774 A105              ;400=================================================================
4775 A105                       EXPORT pushcolor 
4776 A105              pushcolor  
4777 A105
4778 A105 B7 11                 lda   [<colorptr],y
4779 A107 29 F0 00              and   #$00F0
4780 A10A A8                    tay   
4781 A10B 20 5D A2              jsr   set_patt
4782 A10E              ;
4783 A10E 68                    pla                            Get return address.
4784 A10F              ;
4785 A10F DA                    phx                            Push pointer to pattern on stack.
4786 A110 5A                    phy   
4787 A111              ;
4788 A111 48                    pha                            Restore return address.
4789 A112
4790 A112 60                    rts   
4791 A113
4792 A113
4793 A113              ;====================================================================
4794 A113              ;
4795 A113              ;          Push long value in data area.
4796 A113              ;
4797 A113              ;460=================================================================
4798 A113                       EXPORT pushVdrag_patt 
4799 A113              pushVdrag_patt                          ;
4800 A113 A0 7A 00              ldy   #drag_patt+2
4801 A116 80 03                 bra   enter460
4802 A118              ;
4803 A118              ;        EXPORT pushVctl_font
4804 A118              pushVctl_font proc export 
4805 A118 A0 46 00              ldy   #ctl_font+2
4806 A11B              ;
4807 A11B                       export enter460 
4808 A11B FA           enter460 plx   
4809 A11C B7 41                 lda   [<data],y
4810 A11E 48                    pha   
4811 A11F 88                    dey   
4812 A120 88                    dey   
4813 A121 B7 41                 lda   [<data],y
4814 A123 48                    pha   
4815 A124 DA                    phx   
4816 A125
4817 A125 60                    rts   
4818 A126
4819 A126
4820 A126              ;====================================================================
4821 A126              ;
4822 A126              ;          Push address of variable in data area.
4823 A126              ;
4824 A126              ;470=================================================================
4825 A126              ;        EXPORT pushrect2
4826 A126              pushrect2 proc export 
4827 A126 A9 1D 00              lda   #rect2
4828 A129 80 26                 bra   enter470
4829 A12B              ;
4830 A12B              ;        EXPORT pushfontHandle
4831 A12B              pushfontHandle proc export 
4832 A12B A9 30 00              lda   #fontHandle
4833 A12E 80 21                 bra   enter470
4834 A130              ;
4835 A130                       EXPORT pushfontInfo 
4836 A130              pushfontInfo                            ;
4837 A130 A9 84 00              lda   #fontInfo
4838 A133 80 1C                 bra   enter470
4839 A135              ;
4840 A135                       EXPORT pushmyevent 
4841 A135              pushmyevent                             ;
4842 A135 A9 20 00              lda   #myevent
4843 A138 80 17                 bra   enter470
4844 A13A                       EXPORT pushmyeventpos 
4845 A13A              pushmyeventpos                          ;
4846 A13A A9 2A 00              lda   #myevent+where
4847 A13D 80 12                 bra   enter470
4848 A13F              ;
4849 A13F                       EXPORT pushdrag_rect 
4850 A13F              pushdrag_rect                           ;
4851 A13F A9 7C 00              lda   #drag_rect
4852 A142 80 0D                 bra   enter470
4853 A144              ;
4854 A144                       EXPORT pushbound_rect 
4855 A144              pushbound_rect                          ;
4856 A144 A9 66 00              lda   #bound_rect
4857 A147 80 08                 bra   enter470
4858 A149              ;
4859 A149                       EXPORT pushslop_rect 
4860 A149              pushslop_rect                           ;
4861 A149 A9 6E 00              lda   #slop_rect
4862 A14C 80 03                 bra   enter470
4863 A14E              ;
4864 A14E                       EXPORT pushlimit_blk 
4865 A14E              pushlimit_blk                           ;
4866 A14E A9 62 00              lda   #limit_blk
4867 A151              ;
4868 A151              enter470 proc export 
4869 A151 FA                    plx   
4870 A152              ;
4871 A152 18                    clc   
4872 A153 65 41                 adc   <data
4873 A155 A8                    tay   
4874 A156 A9 00 00              lda   #0
4875 A159 65 43                 adc   <data+2
4876 A15B 48                    pha   
4877 A15C 5A                    phy   
4878 A15D              ;
4879 A15D DA                    phx   
4880 A15E
4881 A15E 60                    rts   
4882 A15F
4883 A15F
4884 A15F              ;====================================================================
4885 A15F              ;
4886 A15F              ;          Push word value from data area.
4887 A15F              ;
4888 A15F              ;480=================================================================
4889 A15F              ;        EXPORT pushVaxis_param
4890 A15F              pushVaxis_param proc export 
4891 A15F A0 76 00              ldy   #axis_param
4892 A162 80 03                 bra   enter480
4893 A164              ;
4894 A164              ;        EXPORT pushVvert_pen
4895 A164              pushVvert_pen proc export 
4896 A164 A0 48 00              ldy   #vert_pen
4897 A167              ;
4898 A167                       export enter480 
4899 A167 FA           enter480 plx   
4900 A168 B7 41                 lda   [<data],y
4901 A16A 48                    pha   
4902 A16B DA                    phx   
4903 A16C
4904 A16C 60                    rts   
4905 A16D
4906 A16D
4907 A16D              ;====================================================================
4908 A16D              ;
4909 A16D              ;          Push zero page addresses.
4910 A16D              ;
4911 A16D              ;  OUT:    Y = same as in.
4912 A16D              ;
4913 A16D              ;500=================================================================
4914 A16D                       EXPORT pushyrat 
4915 A16D              pushyrat  
4916 A16D              ;
4917 A16D A9 25 00              lda   #yrat
4918 A170 80 03                 bra   pushzpage
4919 A172              ;
4920 A172                       EXPORT pushrect 
4921 A172              pushrect                                ;
4922 A172              ;
4923 A172 A9 15 00              lda   #rect
4924 A175              ;
4925 A175                       EXPORT pushzpage 
4926 A175              pushzpage                               ;
4927 A175              ;
4928 A175 FA                    plx                            Get return address.
4929 A176              ;
4930 A176 F4 00 00              pea   0
4931 A179 48                    pha   
4932 A17A 7B                    tdc   
4933 A17B 18                    clc   
4934 A17C 63 01                 adc   1,s
4935 A17E 83 01                 sta   1,s
4936 A180              ;
4937 A180 DA                    phx                            Put return address back.
4938 A181
4939 A181 60                    rts   
4940 A182
4941 A182
4942 A182              ;====================================================================
4943 A182              ;
4944 A182              ;          Get given window pointer.
4945 A182              ;
4946 A182              ;   IN:    Window pointer must be last parameter passed to tool function.
4947 A182              ;
4948 A182              ;  OUT:    windptr = pointer to given window.
4949 A182              ;          ctlhand = handle of first control in window.
4950 A182              ;          ctlptr = (ctlptr)
4951 A182              ;          Carry set if error, y = 0.
4952 A182              ;
4953 A182              ;550=================================================================
4954 A182              ;        EXPORT getWindPtr
4955 A182              getWindPtr proc export 
4956 A182              ;
4957 A182 A6 50                 ldx   <inputs+2                Get last input parameter.
4958 A184 A5 4E                 lda   <inputs
4959 A186 D0 08                 bne   ok550
4960 A188 9B                    txy   
4961 A189 D0 05                 bne   ok550
4962 A18B              ;
4963 A18B A0 00 00              ldy   #0                       Don't return an error.
4964 A18E 38                    sec   
4965 A18F
4966 A18F 60                    rts   
4967 A190              ;
4968 A190 20 C1 A1     ok550    jsr   makeWptr                 windptr = window pointer.
4969 A193
4970 A193              ;
4971 A193              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
4972 A193              ;
4973 A193              ;          Get first control in window.
4974 A193              ;
4975 A193              ;   IN:    windptr = pointer to window record.
4976 A193              ;
4977 A193              ;  OUT:    ctlhand = handle of first control in window.
4978 A193              ;          ctlptr = (ctlptr)
4979 A193              ;          Carry set if no first control found, y = 0.
4980 A193              ;
4981 A193              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
4982 A193                       EXPORT getFirstCtl 
4983 A193              getFirstCtl                             ;
4984 A193              ;
4985 A193 A0 CC 00              ldy   #owControls+2            Get pointer to first control.
4986 A196 B7 09                 lda   [<windptr],y
4987 A198 AA                    tax   
4988 A199 88                    dey   
4989 A19A 88                    dey   
4990 A19B B7 09                 lda   [<windptr],y
4991 A19D 80 04                 bra   store550
4992 A19F              ;
4993 A19F              ;
4994 A19F              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
4995 A19F              ;
4996 A19F              ;          Get given control handle.
4997 A19F              ;
4998 A19F              ;   IN:    Control handle must be last parameter passed to tool function.
4999 A19F              ;
5000 A19F              ;  OUT:    ctlhand = handle of first control in window.
5001 A19F              ;          ctlptr = (ctlptr)
5002 A19F              ;          Carry set if null handle passed, y = 0.
5003 A19F              ;
5004 A19F              ;550= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = 
5005 A19F                       EXPORT getCtlHand 
5006 A19F              getCtlHand                              ;
5007 A19F              ;
5008 A19F A5 4E                 lda   <inputs
5009 A1A1 A6 50                 ldx   <inputs+2
5010 A1A3              ;
5011 A1A3 85 01        store550 sta   <Ctlhand
5012 A1A5 86 03                 stx   <Ctlhand+2
5013 A1A7              ;
5014 A1A7 A0 00 00              ldy   #0                       No first control found flag, just in case.
5015 A1AA 38                    sec   
5016 A1AB 05 03                 ora   <Ctlhand+2               Is there a first control?
5017 A1AD F0 04                 beq   exit550
5018 A1AF              ;
5019 A1AF 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
5020 A1B2 18                    clc                            OK flag.
5021 A1B3              ;
5022 A1B3 60           exit550  rts   
5023 A1B4
5024 A1B4
5025 A1B4              ;====================================================================
5026 A1B4              ;
5027 A1B4              ;          Get window pointer from control.
5028 A1B4              ;
5029 A1B4              ;   IN:    Ctlptr = pointer to control.
5030 A1B4              ;
5031 A1B4              ;  OUT:    windptr = pointer to control's window.
5032 A1B4              ;          a = low word of window pointer.
5033 A1B4              ;          x = high word of window pointer.
5034 A1B4              ;
5035 A1B4              ;600=================================================================
5036 A1B4                       ENTRY get_wptr 
5037 A1B4              get_wptr                                ;
5038 A1B4              ;
5039 A1B4 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
5040 A1B7 A0 06 00              ldy   #CtlOwner+2
5041 A1BA B7 05                 lda   [<Ctlptr],y
5042 A1BC AA                    tax   
5043 A1BD 88                    dey   
5044 A1BE 88                    dey   
5045 A1BF B7 05                 lda   [<Ctlptr],y
5046 A1C1
5047 A1C1              ;
5048 A1C1              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5049 A1C1              ;
5050 A1C1              ;          Compute window pointer
5051 A1C1              ;          from grafPort pointer.
5052 A1C1              ;
5053 A1C1              ;   IN:    a,x = pointer to grafPort.
5054 A1C1              ;
5055 A1C1              ;  OUT:    a,x = pointer to window record.
5056 A1C1              ;          windptr = pointer to window record.
5057 A1C1              ;
5058 A1C1              ;650= = = = = = = = = = = = = = = = = = = = = = = = = = =
5059 A1C1                       EXPORT makeWptr 
5060 A1C1              makeWptr                                ;
5061 A1C1
5062 A1C1 38                    sec   
5063 A1C2 E9 04 00              sbc   #oport
5064 A1C5 B0 01                 bcs   store650
5065 A1C7 CA                    dex   
5066 A1C8 85 09        store650 sta   <windptr
5067 A1CA 86 0B                 stx   <windptr+2
5068 A1CC
5069 A1CC 60                    rts   
5070 A1CD
5071 A1CD
5072 A1CD              ;====================================================================
5073 A1CD              ;
5074 A1CD              ;          Switch to window's port.
5075 A1CD              ;
5076 A1CD              ;   IN:    Ctlptr = pointer to control.
5077 A1CD              ;
5078 A1CD              ;  OUT:    current port = Ctlptr's owner (window).
5079 A1CD              ;          global_y = window's Y offset.
5080 A1CD              ;          global_x = window's X offset.
5081 A1CD              ;
5082 A1CD              ;700=================================================================
5083 A1CD                       EXPORT to_wport 
5084 A1CD              to_wport                                ;       
5085 A1CD
5086 A1CD              ;
5087 A1CD              ; --- Move relevant data from window port to Control Mgr's port -------------
5088 A1CD              ;
5089 A1CD 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
5090 A1D0 A0 06 00              ldy   #CtlOwner+2              Get pointer to window's port.
5091 A1D3 B7 05                 lda   [<Ctlptr],y
5092 A1D5 48                    pha   
5093 A1D6 88                    dey   
5094 A1D7 88                    dey   
5095 A1D8 B7 05                 lda   [<Ctlptr],y
5096 A1DA 48                    pha   
5097 A1DB A2 04 1B 22           _SetPort 
5098 A1E2              ;
5099 A1E2              ;                                       Fall through to dereference.
5100 A1E2              ;
5101 A1E2              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
5102 A1E2              ;
5103 A1E2              ;          Dereference Ctlhand.
5104 A1E2              ;
5105 A1E2              ;   IN:    Ctlhand = handle.
5106 A1E2              ;
5107 A1E2              ;  OUT:    a,x = (Ctlhand)
5108 A1E2              ;          Ctlptr = (Ctlhand)
5109 A1E2              ;
5110 A1E2              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
5111 A1E2              ;;;        EXPORT dereference
5112 A1E2              dereference proc export 
5113 A1E2              ;
5114 A1E2 A0 02 00              ldy   #2
5115 A1E5 B7 01                 lda   [<Ctlhand],y
5116 A1E7 85 07                 sta   <Ctlptr+2
5117 A1E9 AA                    tax   
5118 A1EA A7 01                 lda   [<Ctlhand]
5119 A1EC 85 05                 sta   <Ctlptr
5120 A1EE
5121 A1EE 60                    rts   
5122 A1EF
5123 A1EF
5124 A1EF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
5125 A1EF              ;
5126 A1EF              ;          Push pointer to string.
5127 A1EF              ;
5128 A1EF              ;   IN:    Ctlhand = handle
5129 A1EF              ;          CtlPtr  = ptr
5130 A1EF              ;
5131 A1EF              ;  OUT:    pointer on stack
5132 A1EF              ;
5133 A1EF              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
5134 A1EF              ;;;        EXPORT PushStringPtr
5135 A1EF              PushStringPtr proc export 
5136 A1EF 20 52 A2              jsr   CtlDataToAX              ; start by putting value in Ctldata on stack
5137 A1F2 7A                    ply   
5138 A1F3 DA                    phx   
5139 A1F4 48                    pha   
5140 A1F5 5A                    phy   
5141 A1F6
5142 A1F6              ;
5143 A1F6              ; If the control is not a super control, we are done.
5144 A1F6              ;
5145 A1F6 A0 16 00              ldy   #NewCtlRecord.ctlProc+2
5146 A1F9 B7 05                 lda   [ctlPtr],y
5147 A1FB 10 34                 bpl   @Done
5148 A1FD
5149 A1FD              ;
5150 A1FD              ; It is a super control.  See what the verb is.
5151 A1FD              ;
5152 A1FD 20 32 A2              jsr   ReadMoreFlags
5153 A200 29 03 00              and   #TitleVerbMask
5154 A203 F0 2C                 beq   @Done                    0 is pointer so all done
5155 A205
5156 A205 C9 01 00              cmp   #TitleIsHandle
5157 A208 F0 17                 beq   @IsHandle
5158 A20A
5159 A20A              @IsResource  
5160 A20A 48                    pha   
5161 A20B 48                    pha   
5162 A20C F4 06 80              PushWord #rString 
5163 A20F 20 52 A2              jsr   CtlDataToAX
5164 A212 DA                    phx   
5165 A213 48                    pha   
5166 A214 20 9C 9D              jsr   LoadResource
5167 A217 68                    pla   
5168 A218 FA                    plx   
5169 A219 83 03                 sta   3,s
5170 A21B 8A                    txa   
5171 A21C 83 05                 sta   5,s
5172 A21E
5173 A21E              ; memory may have moved, so reset ctlPtr
5174 A21E              ;
5175 A21E 20 E2 A1              jsr   Dereference
5176 A221
5177 A221              @IsHandle  
5178 A221 0B                    phd   
5179 A222 3B                    tsc   
5180 A223 5B                    tcd   
5181 A224
5182 A224 A0 02 00              ldy   #2
5183 A227 B7 05                 lda   [5],y
5184 A229 AA                    tax   
5185 A22A A7 05                 lda   [5]
5186 A22C 85 05                 sta   5
5187 A22E 86 07                 stx   7
5188 A230
5189 A230 2B                    pld   
5190 A231
5191 A231
5192 A231              @Done     
5193 A231
5194 A231 60                    rts   
5195 A232
5196 A232
5197 A232
5198 A232              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
5199 A232              ;
5200 A232              ;          ReadMoreFlags
5201 A232              ;
5202 A232              ;   IN:    Ctlhand = handle
5203 A232              ;          CtlPtr  = ptr
5204 A232              ;
5205 A232              ;  OUT:    a-reg = MoreFlags
5206 A232              ;
5207 A232              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
5208 A232              ;        EXPORT ReadMoreFlags
5209 A232              ReadMoreFlags proc export 
5210 A232 A0 3C 00              ldy   #NewCtlRecord.ctlMoreFlags
5211 A235 B7 05                 lda   [<Ctlptr],y
5212 A237 60                    rts   
5213 A238
5214 A238
5215 A238              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
5216 A238              ;
5217 A238              ;          GetColorTableRefFromTemplate
5218 A238              ;
5219 A238              ;   IN:    param = ptrToTemplate
5220 A238              ;
5221 A238              ;  OUT:    a-reg = offset in template of color table
5222 A238              ;
5223 A238              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
5224 A238              ;        EXPORT GetColorTableRefFromTemplate
5225 A238              GetColorTableRefFromTemplate proc export  
5226 A238 A0 11 00              ldy   #simpleButtonTemplate.ProcRef+3
5227 A23B B7 29                 lda   [param],y
5228 A23D 29 7F 00              and   #$007F
5229 A240 F0 05                 beq   @IsButton
5230 A242
5231 A242              ; is check or radio
5232 A242 A0 22 00              ldy   #checkTemplate.ColorTableRef+2
5233 A245 80 03                 bra   @join
5234 A247
5235 A247
5236 A247 A0 20 00     @IsButton ldy   #simpleButtonTemplate.ColorTableRef+2
5237 A24A B7 29        @join    lda   [param],y
5238 A24C AA                    tax   
5239 A24D 88                    dey   
5240 A24E 88                    dey   
5241 A24F B7 29                 lda   [param],y
5242 A251 60                    rts   
5243 A252
5244 A252
5245 A252
5246 A252              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
5247 A252              ;
5248 A252              ;          CtlDataToAX
5249 A252              ;
5250 A252              ;   IN:    Ctlhand = handle
5251 A252              ;          CtlPtr  = ptr
5252 A252              ;
5253 A252              ;  OUT:    a-reg & x-reg get value in ctlData 
5254 A252              ;
5255 A252              ;750= = = = = = = = = = = = = = = = = = = = = = = = = =
5256 A252                       EXPORT CtlDataToAX 
5257 A252              CtlDataToAX  
5258 A252 A0 1E 00              ldy   #NewCtlRecord.ctlData+2
5259 A255 B7 05                 lda   [ctlPtr],y
5260 A257 AA                    tax   
5261 A258 88                    dey   
5262 A259 88                    dey   
5263 A25A B7 05                 lda   [ctlPtr],y
5264 A25C 60                    rts   
5265 A25D
5266 A25D
5267 A25D
5268 A25D
5269 A25D              ;====================================================================
5270 A25D              ;
5271 A25D              ;        Smear a mono bit image into color.
5272 A25D              ;
5273 A25D              ;  IN:   y = pattern type in high byte,
5274 A25D              ;            pattern color number in high nybble of low byte,
5275 A25D              ;            background color in low nibble of low byte.
5276 A25D              ;
5277 A25D              ; OUT:   x = high word address of pattern.
5278 A25D              ;        y = low word address of pattern.
5279 A25D              ;
5280 A25D              ;800=================================================================
5281 A25D              set_patt proc EXPORT 
5282 A25D
5283 A25D 98                    tya                            Special case, solid pattern.
5284 A25E 29 00 FF              and   #$FF00
5285 A261 D0 17                 bne   begin800
5286 A263
5287 A263              ;
5288 A263              ; --- Special case black and white --------------------------------
5289 A263              ;
5290 A263 98                    tya   
5291 A264 29 F0 00              and   #$00F0
5292 A267 F0 0A                 beq   @black
5293 A269 C9 F0 00              cmp   #$00F0
5294 A26C D0 0C                 bne   begin800
5295 A26E              ;
5296 A26E A0 75 A4              ldy   #clrWhite
5297 A271 80 03                 bra   exit801
5298 A273              ;
5299 A273 A0 55 A4     @black   ldy   #clrBlack
5300 A276 A2 FD 00     exit801  ldx   #clrBlack>>16
5301 A279
5302 A279 60                    rts   
5303 A27A
5304 A27A              ;
5305 A27A              ; --- Fill pattern buffer with pattern color ----------
5306 A27A              ;
5307 A27A              ;  y = color/pattern
5308 A27A              ;
5309 A27A D4 2F        begin800 pei   <work+2                  Save work.
5310 A27C D4 2D                 pei   <work
5311 A27E              ;
5312 A27E A6 43                 ldx   <data+2
5313 A280 A5 41                 lda   <data
5314 A282 18                    clc   
5315 A283 69 00 00              adc   #pattern
5316 A286 90 01                 bcc   store800
5317 A288 E8                    inx   
5318 A289 85 2D        store800 sta   <work
5319 A28B 86 2F                 stx   <work+2
5320 A28D              ;
5321 A28D              ;
5322 A28D 98                    tya                            Get pattern color.
5323 A28E 4A                    lsr   a
5324 A28F 4A                    lsr   a
5325 A290 4A                    lsr   a
5326 A291 4A                    lsr   a
5327 A292 20 05 A3              jsr   getcolor                 Smear color into all four nibbles.
5328 A295              ;
5329 A295 87 2D                 sta   [<work]
5330 A297 C0 00 01              cpy   #$0100
5331 A29A B0 0B                 bcs   dither800
5332 A29C              ;
5333 A29C A0 1E 00              ldy   #30
5334 A29F 97 2D        lop800   sta   [<work],y
5335 A2A1 88                    dey   
5336 A2A2 88                    dey   
5337 A2A3 D0 FA                 bne   lop800
5338 A2A5 80 48                 bra   exit800
5339 A2A7              ;
5340 A2A7              ;
5341 A2A7              ; --- Special dither pattern -------------------------------------------
5342 A2A7              ;
5343 A2A7 98           dither800 tya   
5344 A2A8 20 05 A3              jsr   getcolor
5345 A2AB A8                    tay   
5346 A2AC 29 F0 F0              and   #$F0F0
5347 A2AF 48                    pha   
5348 A2B0 A7 2D                 lda   [<work]
5349 A2B2 29 0F 0F              and   #$0F0F
5350 A2B5 03 01                 ora   1,s
5351 A2B7 83 01                 sta   1,s
5352 A2B9              ;
5353 A2B9 98                    tya   
5354 A2BA 29 0F 0F              and   #$0F0F
5355 A2BD 48                    pha   
5356 A2BE A7 2D                 lda   [<work]
5357 A2C0 29 F0 F0              and   #$F0F0
5358 A2C3 03 01                 ora   1,s
5359 A2C5 83 01                 sta   1,s
5360 A2C7              ;
5361 A2C7 A0 49 00              ldy   #GraphicsMode-1
5362 A2CA B7 41                 lda   [<data],y
5363 A2CC AA                    tax                            Keep mode in X.
5364 A2CD 10 05                 bpl   mode320                  What's the mode, 320 or 640?
5365 A2CF              ;
5366 A2CF A0 0E 00              ldy   #14                      640 mode index.
5367 A2D2 80 03                 bra   lop801
5368 A2D4              ;
5369 A2D4 A0 1E 00     mode320  ldy   #30                      320 mode index.
5370 A2D7              ;
5371 A2D7 20 FA A2     lop801   jsr   set1
5372 A2DA 8A                    txa   
5373 A2DB 30 03                 bmi   skip800
5374 A2DD 20 FA A2              jsr   set1
5375 A2E0              ;
5376 A2E0 20 FE A2     skip800  jsr   set2
5377 A2E3 30 08                 bmi   done800
5378 A2E5 8A                    txa   
5379 A2E6 30 EF                 bmi   lop801
5380 A2E8 20 FE A2              jsr   set2
5381 A2EB 10 EA                 bpl   lop801
5382 A2ED              ;
5383 A2ED              ;
5384 A2ED 68           done800  pla   
5385 A2EE 68                    pla   
5386 A2EF              ;
5387 A2EF              ;
5388 A2EF A4 2D        exit800  ldy   <work                    Return pointer to pattern.
5389 A2F1 A6 2F                 ldx   <work+2
5390 A2F3              ;
5391 A2F3 68                    pla                            Restore work.
5392 A2F4 85 2D                 sta   <work
5393 A2F6 68                    pla   
5394 A2F7 85 2F                 sta   <work+2
5395 A2F9
5396 A2F9 60                    rts   
5397 A2FA              ;
5398 A2FA              ;
5399 A2FA A3 05        set1     lda   5,s
5400 A2FC 80 02                 bra   enter2
5401 A2FE              ;
5402 A2FE              ;
5403 A2FE A3 03        set2     lda   3,s
5404 A300 97 2D        enter2   sta   [<work],y
5405 A302 88                    dey   
5406 A303 88                    dey   
5407 A304
5408 A304 60                    rts   
5409 A305
5410 A305              ;====================================================================
5411 A305              ;
5412 A305              ;   IN:    a = color in low nibble.
5413 A305              ;
5414 A305              ;  OUT:    a = color in all four nibbles.
5415 A305              ;
5416 A305              ;====================================================================
5417 A305 29 0F 00     getcolor and   #$000F
5418 A308 48                    pha   
5419 A309 0A                    asl   a
5420 A30A 0A                    asl   a
5421 A30B 0A                    asl   a
5422 A30C 0A                    asl   a
5423 A30D 03 01                 ora   1,s
5424 A30F 83 01                 sta   1,s
5425 A311 EB                    xba   
5426 A312 03 01                 ora   1,s
5427 A314 FA                    plx   
5428 A315
5429 A315 60                    rts   
5430 A316              ;
5431 A316                       ENDP 
5432 A316
5433 A316
5434 A316              ;====================================================================
5435 A316              ;
5436 A316              ;        Draw a solid rectangle with border.
5437 A316              ;
5438 A316              ;  IN:     <rect = RECT to draw.
5439 A316              ;          <colorptr = pointer to color table.
5440 A316              ;          y = color of fill in bits 4-7.
5441 A316              ;          a = color of outline in bits 4-7.
5442 A316              ;
5443 A316              ;====================================================================
5444 A316              drawrect proc EXPORT 
5445 A316
5446 A316              fillColor equ   1
5447 A316              frameColor equ   fillColor+2
5448 A316
5449 A316              ;
5450 A316              ; --- Use special fill & frame RECT call ---------------------
5451 A316              ;
5452 A316 48                    pha                            Save outline color.
5453 A317 5A                    phy                            Save fill color.
5454 A318              ;
5455 A318 20 72 A1              jsr   pushrect                 Pass pointer to RECT to draw.
5456 A31B A3 07                 lda   frameColor+4,s           Get color of frame,
5457 A31D 20 6B A3              jsr   pushSmear                smear into 4 nibbles and push.
5458 A320 A3 07                 lda   fillColor+6,s            Get fill color,
5459 A322 20 6B A3              jsr   pushSmear                smear into 4 nibbles and push.
5460 A325 A2 12 0C 22           _SpecialRect 
5461 A32C 90 3A                 bcc   exit                     No error?
5462 A32E              ;
5463 A32E 3B                    tsc                            Fix stack from SpecialRect call.
5464 A32F 18                    clc   
5465 A330 69 08 00              adc   #8
5466 A333 1B                    tcs   
5467 A334              ;
5468 A334              ;
5469 A334              ; --- Use slower separate fill & frame calls -----------------
5470 A334              ;
5471 A334 A2 04 36 22           _PenNormal 
5472 A33B              ;
5473 A33B 20 E8 97              jsr   setvertpen               Set line size.
5474 A33E              ;
5475 A33E A3 03                 lda   frameColor,s             Set pen color.
5476 A340 F0 0A                 beq   skip1                    Color already set?
5477 A342 20 6B A3              jsr   pushSmear
5478 A345 A2 04 37 22           _SetSolidPenPat 
5479 A34C              ;
5480 A34C 20 72 A1     skip1    jsr   pushrect                 Pass RECT to fill.
5481 A34F A3 05                 lda   fillColor+4,s
5482 A351 A8                    tay   
5483 A352 20 5D A2              jsr   set_patt
5484 A355 DA                    phx                            Push pointer to pattern.
5485 A356 5A                    phy   
5486 A357 A2 04 57 22           _FillRect 
5487 A35E              ;
5488 A35E 20 72 A1              jsr   pushrect                 Pass RECT to frame.
5489 A361 A2 04 53 22           _FrameRect 
5490 A368              ;
5491 A368 7A           exit     ply                            Get rid of fill color.
5492 A369 68                    pla                            Get rid of outline color.
5493 A36A
5494 A36A 60                    rts   
5495 A36B
5496 A36B
5497 A36B              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5498 A36B              ;
5499 A36B              ;          Smear color and push.
5500 A36B              ;
5501 A36B              ;   IN:    a = color to smear in bits 4-7.
5502 A36B              ;
5503 A36B              ;  OUT:    Color smeared into all 4 nibbles and left on stack.
5504 A36B              ;
5505 A36B              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = =
5506 A36B FA           pushSmear plx                           Get return address.
5507 A36C              ;
5508 A36C 48                    pha   
5509 A36D 4A                    lsr   a
5510 A36E 4A                    lsr   a
5511 A36F 4A                    lsr   a
5512 A370 4A                    lsr   a
5513 A371 03 01                 ora   1,s
5514 A373 83 01                 sta   1,s
5515 A375 EB                    xba   
5516 A376 03 01                 ora   1,s
5517 A378 83 01                 sta   1,s
5518 A37A              ;
5519 A37A DA                    phx   
5520 A37B
5521 A37B 60                    rts   
5522 A37C
5523 A37C
5524 A37C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5525 A37C              ;
5526 A37C              ;        Get pointer to next control.
5527 A37C              ;
5528 A37C              ;   IN:  Ctlptr = pointer to a control.
5529 A37C              ;
5530 A37C              ;  OUT:  Equal flag = FALSE if ok, else no more controls.
5531 A37C              ;
5532 A37C              ;860= = = = = = = = = = = = = = = = = = = = = = = = = = =
5533 A37C                       EXPORT next_Ctl 
5534 A37C              next_Ctl                                ;
5535 A37C              ;
5536 A37C A7 05                 lda   [<Ctlptr]
5537 A37E AA                    tax   
5538 A37F A0 02 00              ldy   #2
5539 A382 B7 05                 lda   [<Ctlptr],y
5540 A384 D0 03                 bne   store860
5541 A386 9B                    txy   
5542 A387 F0 09                 beq   exit860
5543 A389              ;
5544 A389 85 03        store860 sta   <Ctlhand+2
5545 A38B 86 01                 stx   <Ctlhand
5546 A38D 20 E2 A1              jsr   dereference              Ctlptr = (Ctlhand).
5547 A390 A5 06                 lda   <ctlptr+1                Set not equal flag.
5548 A392 60           exit860  rts   
5549 A393
5550 A393
5551 A393              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5552 A393              ;
5553 A393              ;          Get bounds RECT of icon.
5554 A393              ;
5555 A393              ;   IN:    x = icon number.
5556 A393              ;
5557 A393              ;  OUT:    rect2+y2 = height of character.
5558 A393              ;          rect2+x2 = width of character.
5559 A393              ;
5560 A393              ;870= = = = = = = = = = = = = = = = = = = = = = = = = = =
5561 A393                       EXPORT get_csize 
5562 A393              get_csize                               ;
5563 A393              ;
5564 A393 86 2D                 stx   <work                    Pass character to test.
5565 A395
5566 A395              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5567 A395              ;
5568 A395              ;   IN:    work = character to get bounds of.
5569 A395              ;
5570 A395              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5571 A395                       EXPORT get_csize2 
5572 A395              get_csize2  
5573 A395 A9 FF A3              lda   #getCharBounds
5574 A398              ;                                       Fall through to doIconFunc.
5575 A398              ;
5576 A398              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5577 A398              ;
5578 A398              ;          Perform a task that needs the
5579 A398              ;          icon font as the current font.
5580 A398              ;
5581 A398              ;   IN:    a = address of function to perform.
5582 A398              ;
5583 A398              ;880= = = = = = = = = = = = = = = = = = = = = = = = = = =
5584 A398                       EXPORT doIconFunc 
5585 A398              doIconFunc                              ;
5586 A398
5587 A398 48                    pha                            Save function to call.
5588 A399              ;
5589 A399              ;
5590 A399              ; --- Save state of grafPort ---------------------------------
5591 A399              ;
5592 A399 48                    pha                            Save original text face.
5593 A39A A2 04 9B 22           _GetTextFace 
5594 A3A1              ;
5595 A3A1 48                    pha                            Save original font flags.
5596 A3A2 A2 04 99 22           _GetFontFlags 
5597 A3A9              ;
5598 A3A9 48                    pha                            Save original font ID.
5599 A3AA 48                    pha   
5600 A3AB A2 04 D1 22           _GetFontID 
5601 A3B2              ;
5602 A3B2 48                    pha                            Save original font
5603 A3B3 48                    pha   
5604 A3B4 A2 04 95 22           _GetFont 
5605 A3BB              ;
5606 A3BB              ;
5607 A3BB              ; --- Clear text face, switch to icon font and call function ------------------
5608 A3BB              ;
5609 A3BB F4 00 00              pea   0000
5610 A3BE A2 04 9A 22           _SetTextFace 
5611 A3C5              ;
5612 A3C5 20 18 A1              jsr   pushVctl_font            Swicth to icon font.
5613 A3C8 A2 04 94 22           _SetFont 
5614 A3CF              ;
5615 A3CF F4 04 00              pea   4                        Use word of color.
5616 A3D2 A2 04 98 22           _SetFontFlags 
5617 A3D9
5618 A3D9 F4 E0 A3              pea   returnAddr-1             Put return address on stack.
5619 A3DC
5620 A3DC              ;
5621 A3DC              ; The stack at this point is
5622 A3DC              ;
5623 A3DC                       DefineStack 
5624 A3DC              TheRetAddr word                         ; 1
5625 A3DC              OrigFont long                           ; 3
5626 A3DC              OrigFontID long                         ; 7
5627 A3DC              OrigFontFlags word                      ; 11
5628 A3DC              OrigTextFace word                       ; 13
5629 A3DC              FuncToCall word                         ; 15
5630 A3DC
5631 A3DC A3 0F                 lda   FuncToCall,s             Put address of function on stack,
5632 A3DE 3A                    dec   a
5633 A3DF 48                    pha   
5634 A3E0
5635 A3E0 60                    rts                            and dispatch to it.
5636 A3E1              returnAddr                              ; 
5637 A3E1
5638 A3E1              ;
5639 A3E1              ; --- Restore state of grafPort ------------------------------
5640 A3E1              ;
5641 A3E1 A2 04 94 22           _SetFont                       Restore original font.
5642 A3E8 A2 04 D0 22           _SetFontID                     Restore original font ID.
5643 A3EF A2 04 98 22           _SetFontFlags                  Restore original font flags.
5644 A3F6 A2 04 9A 22           _SetTextFace                   Restore original text face.
5645 A3FD              ;
5646 A3FD 68                    pla                            Address of function.
5647 A3FE
5648 A3FE 60                    rts   
5649 A3FF              ;
5650 A3FF              ;
5651 A3FF              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5652 A3FF              ;
5653 A3FF              ;          Get size of character.
5654 A3FF              ;
5655 A3FF              ;   IN:    work = character to get size of.
5656 A3FF              ;
5657 A3FF              ;  OUT:    rect2+y2 = height of character.
5658 A3FF              ;          rect2+x2 = width of character.
5659 A3FF              ;
5660 A3FF              ;890= = = = = = = = = = = = = = = = = = = = = = = = = = =
5661 A3FF              getCharBounds                           ; 
5662 A3FF              ;
5663 A3FF D4 2D                 pei   <work                    Pass character to get bounds of.
5664 A401 20 26 A1              jsr   pushrect2                Store the bounds in 'rect2'.
5665 A404 A2 04 AC 22           _CharBounds 
5666 A40B              ;
5667 A40B A0 21 00              ldy   #rect2+y2                Compute icon's heigth.
5668 A40E B7 41                 lda   [<data],y
5669 A410 38                    sec   
5670 A411 A0 1D 00              ldy   #rect2+y1
5671 A414 F7 41                 sbc   [<data],y
5672 A416 A0 21 00              ldy   #rect2+y2
5673 A419 97 41                 sta   [<data],y
5674 A41B              ;
5675 A41B A0 23 00              ldy   #rect2+x2                Compute icon's width.
5676 A41E B7 41                 lda   [<data],y
5677 A420 38                    sec   
5678 A421 A0 1F 00              ldy   #rect2+x1
5679 A424 F7 41                 sbc   [<data],y
5680 A426 A0 23 00              ldy   #rect2+x2
5681 A429 97 41                 sta   [<data],y
5682 A42B
5683 A42B 60                    rts   
5684 A42C
5685 A42C
5686 A42C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
5687 A42C              ;
5688 A42C              ;        Move control's CtlRect into 'rect'.
5689 A42C              ;
5690 A42C              ;   IN:  Ctlptr = control pointer.
5691 A42C              ;
5692 A42C              ;  OUT:  rect = CtlRect of part.
5693 A42C              ;
5694 A42C              ;900= = = = = = = = = = = = = = = = = = = = = = = = = = =
5695 A42C                       EXPORT CMsetrect 
5696 A42C              CMsetrect                               ;       
5697 A42C A0 0E 00              ldy   #CtlRect+x2              Put CtlRect into rect.
5698 A42F
5699 A42F
5700 A42F                       EXPORT CMsetrect2 
5701 A42F              CMsetrect2                              ;
5702 A42F A2 06 00              ldx   #x2
5703 A432 B7 05        lop900   lda   [<Ctlptr],y
5704 A434 95 15                 sta   <rect,x
5705 A436 88                    dey   
5706 A437 88                    dey   
5707 A438 CA                    dex   
5708 A439 CA                    dex   
5709 A43A 10 F6                 bpl   lop900
5710 A43C
5711 A43C 60                    rts   
5712 A43D              ;
5713 A43D                       ENDP 
5714 A43D
5715 A43D
5716 A43D              ;            APPEND                     CSTATIC.ASM
5717 A43D              ;
5718 A43D              ;====================================================================
5719 A43D              ;
5720 A43D              ;          Static data area.
5721 A43D              ;
5722 A43D              ;====================================================================
5723 A43D              staticRAM PROC 
5724 A43D              ;
5725 A43D              ;
5726 A43D                       EXPORT arrowMap 
5727 A43D 52 00 56 00  arrowMap DC W:uArrowH,dArrowH,lArrowH,rArrowH
5728 A445              ;
5729 A445                       EXPORT Dimmed 
5730 A445 55 AA 55 AA  dimmed   DC B:$55,$AA,$55,$AA,$55,$AA,$55,$AA Dithered mask for pen.
5731 A44D                       EXPORT Nor_Mask 
5732 A44D FF FF FF FF  nor_mask DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF Normal mask for pen.
5733 A455              ;
5734 A455                       EXPORT clrBlack 
5735 A455 00 00        clrBlack DC W:$0000                     Solid black pattern.
5736 A457 00 00                 DC W:$0000
5737 A459 00 00                 DC W:$0000
5738 A45B 00 00                 DC W:$0000
5739 A45D 00 00                 DC W:$0000
5740 A45F 00 00                 DC W:$0000
5741 A461 00 00                 DC W:$0000
5742 A463 00 00                 DC W:$0000
5743 A465 00 00                 DC W:$0000
5744 A467 00 00                 DC W:$0000
5745 A469 00 00                 DC W:$0000
5746 A46B 00 00                 DC W:$0000
5747 A46D 00 00                 DC W:$0000
5748 A46F 00 00                 DC W:$0000
5749 A471 00 00                 DC W:$0000
5750 A473 00 00                 DC W:$0000
5751 A475
5752 A475                       EXPORT clrWhite 
5753 A475 FF FF        clrWhite DC W:$FFFF                     Solid white pattern.
5754 A477 FF FF                 DC W:$FFFF
5755 A479 FF FF                 DC W:$FFFF
5756 A47B FF FF                 DC W:$FFFF
5757 A47D FF FF                 DC W:$FFFF
5758 A47F FF FF                 DC W:$FFFF
5759 A481 FF FF                 DC W:$FFFF
5760 A483 FF FF                 DC W:$FFFF
5761 A485 FF FF                 DC W:$FFFF
5762 A487 FF FF                 DC W:$FFFF
5763 A489 FF FF                 DC W:$FFFF
5764 A48B FF FF                 DC W:$FFFF
5765 A48D FF FF                 DC W:$FFFF
5766 A48F FF FF                 DC W:$FFFF
5767 A491 FF FF                 DC W:$FFFF
5768 A493 FF FF                 DC W:$FFFF
5769 A495              ;
5770 A495              ;
5771 A495              ; --- Default color table for simple buttons -----------------
5772 A495              ;
5773 A495                       EXPORT butt_color 
5774 A495 00 00        butt_color DC W:$0000                   Outline.
5775 A497 F0 00                 DC W:$00F0                     Interior when normal.
5776 A499 00 00                 DC W:$0000                     Interior when selected.
5777 A49B F0 00                 DC W:$00F0                     Text when normal.
5778 A49D 0F 00                 DC W:$000F                     Text when selected.
5779 A49F              ;
5780 A49F              ;
5781 A49F              ; --- Default color table for check boxes and radio buttons --
5782 A49F              ;
5783 A49F                       EXPORT check_color 
5784 A49F 00 00        check_color DC W:$0000                  Outline.
5785 A4A1 F0 00                 DC W:$00F0                     Icon when unhilited.
5786 A4A3 F0 00                 DC W:$00F0                     Icon when hilited.
5787 A4A5 F0 00                 DC W:$00F0                     Title color.
5788 A4A7              ;
5789 A4A7              ;
5790 A4A7              ; --- Default color table for scroll bars --------------------
5791 A4A7              ;
5792 A4A7                       EXPORT scroll_color 
5793 A4A7 00 00        scroll_color DC W:$0000                 Outline.
5794 A4A9 F0 00                 DC W:$00F0                     Arrow when normal.
5795 A4AB F0 00                 DC W:$00F0                     Arrow when selected.
5796 A4AD F0 00                 DC W:$00F0                     Arrow's box interior.
5797 A4AF F0 00                 DC W:$00F0                     Thumber when normal.
5798 A4B1 00 00                 DC W:$0000                     Not used and should never be used.
5799 A4B3 0F 01                 DC W:$010F                     Page region interior.
5800 A4B5 F0 00                 DC W:$00F0                     Interior color of inactive bar.
5801 A4B7              ;
5802 A4B7              ;
5803 A4B7              ; --- Default color table for grow box -----------------------
5804 A4B7              ;
5805 A4B7                       EXPORT grow_color 
5806 A4B7 00 00        grow_color DC W:$0000                   Outline.
5807 A4B9 F0 00                 DC W:$00F0                     Interior when normal.
5808 A4BB 0F 00                 DC W:$000F                     Interior when selected.
5809 A4BD              ;
5810 A4BD              ;
5811 A4BD              ; --- Control Manager icon font -------------------------------
5812 A4BD              ;
5813 A4BD                       EXPORT ctl320 
5814 A4BD              ctl320                                  ; 
5815 A4BD              ;
5816 A4BD 06 00                 DC W:$0006                     {offset word}
5817 A4BF D1 00                 DC W:$00D1                     {FontID}
5818 A4C1 00 00                 DC W:$0000                     {style}
5819 A4C3 0A 00                 DC W:$000A                     {size}
5820 A4C5 00 01                 DC W:$0100                     {version}
5821 A4C7 0D 00                 DC W:$000D                     {FBRext}
5822 A4C9              ;
5823 A4C9 01 90                 DC W:$9001                     {FontType}
5824 A4CB 00 00                 DC W:$0000                     {FirstChar}
5825 A4CD 10 00                 DC W:$0010                     {LastChar}
5826 A4CF 0D 00                 DC W:$000D                     {WidMax}
5827 A4D1 00 00                 DC W:$0000                     {KernMax}
5828 A4D3 F7 FF                 DC W:$FFF7                     {nDescent}
5829 A4D5 0D 00                 DC W:$000D                     {fRectWidth}
5830 A4D7 09 00                 DC W:$0009                     {FrectHeight}
5831 A4D9 84 00                 DC W:132                       {owTLoc}
5832 A4DB 00 00                 DC W:$0000                     {ascent}
5833 A4DD 09 00                 DC W:$0009                     {descent}
5834 A4DF 00 00                 DC W:$0000                     {leading}
5835 A4E1 0C 00                 DC W:12                        {RowWords}
5836 A4E3              ;
5837 A4E3              ; BitImage:
5838 A4E3 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$0F,$00,$F0,$0F,$00,$80,$40,$F8,$7C,$08,$04,$02,$01,$0F,$80,$00
5839 A4FB 80 0F FF F0           DC B:$80,$0F,$FF,$F0,$07,$FF,$F3,$0C,$39,$C3,$0C,$39,$C1,$40,$E0,$88,$7C,$18,$0C,$03,$01,$88,$80,$00
5840 A513 80 0F 01 EC           DC B:$80,$0F,$01,$EC,$1B,$E0,$F4,$02,$60,$64,$F2,$6F,$62,$21,$F0,$88,$7C,$2F,$9F,$FE,$9F,$C8,$F8,$00
5841 A52B 80 0F 01 E3           DC B:$80,$0F,$01,$E3,$63,$DB,$78,$01,$C0,$39,$F9,$DF,$B4,$13,$F8,$88,$7C,$40,$BF,$E0,$5F,$E8,$88,$00
5842 A543 80 0F 01 E0           DC B:$80,$0F,$01,$E0,$83,$C4,$78,$01,$C0,$3B,$FD,$DF,$BE,$3F,$FF,$8F,$FF,$80,$FF,$E0,$3F,$FF,$88,$00
5843 A55B 80 0F 01 E3           DC B:$80,$0F,$01,$E3,$63,$DB,$78,$01,$C0,$39,$F9,$DF,$B2,$21,$F1,$04,$FE,$40,$BF,$E0,$5F,$E2,$08,$00
5844 A573 80 0F 01 EC           DC B:$80,$0F,$01,$EC,$1B,$E0,$F4,$02,$60,$64,$F2,$6F,$62,$21,$F0,$88,$7C,$2F,$9F,$FE,$9F,$C2,$08,$00
5845 A58B 80 0F FF F0           DC B:$80,$0F,$FF,$F0,$07,$FF,$F3,$0C,$39,$C3,$0C,$39,$C2,$21,$F0,$50,$38,$18,$0C,$03,$01,$82,$08,$00
5846 A5A3 FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$F0,$F0,$0F,$00,$F0,$0F,$03,$E1,$F0,$20,$10,$08,$04,$02,$01,$03,$F8,$00
5847 A5BB              ;
5848 A5BB              ; LocTable:
5849 A5BB 00 00                 DC W:0                         0   Unchecked box normal.
5850 A5BD 0D 00                 DC W:13                        1   Unchecked box hilited.
5851 A5BF 1A 00                 DC W:26                        2   Checked box normal.
5852 A5C1 27 00                 DC W:39                        3   Checked box hilited.
5853 A5C3 34 00                 DC W:52                        4   Off radio button normal.
5854 A5C5 40 00                 DC W:64                        5   Off radio button hilited.
5855 A5C7 4C 00                 DC W:76                        6   On radio button normal.
5856 A5C9 58 00                 DC W:88                        7   On radio button hilited.
5857 A5CB 64 00                 DC W:100                       8   Up arrow normal.
5858 A5CD 6D 00                 DC W:109                       9   Up arrow hilited.
5859 A5CF 76 00                 DC W:118                       10  Down arrow normal.
5860 A5D1 7F 00                 DC W:127                       11  Down arrow hilited.
5861 A5D3 88 00                 DC W:136                       12  Left arrow normal.
5862 A5D5 91 00                 DC W:145                       13  Left arrow hilited.
5863 A5D7 9A 00                 DC W:154                       14  Right arrow normal.
5864 A5D9 A3 00                 DC W:163                       15  Right arrow hilited.
5865 A5DB AC 00                 DC W:172                       16  Grow icon.
5866 A5DD B5 00                 DC W:181                       17  End of table.
5867 A5DF B5 00                 DC W:181                       18
5868 A5E1              ;
5869 A5E1              ; OWTable:
5870 A5E1 0D 00                 DC W:13                        0   Unchecked box normal.
5871 A5E3 0D 00                 DC W:13                        1   Unchecked box hilited.
5872 A5E5 0D 00                 DC W:13                        2   Checked box normal.
5873 A5E7 0D 00                 DC W:13                        3   Checked box hilited.
5874 A5E9 0B 00                 DC W:11                        4   Off radio button normal.
5875 A5EB 0B 00                 DC W:11                        5   Off radio button hilited.
5876 A5ED 0B 00                 DC W:11                        6   On radio button normal.
5877 A5EF 0B 00                 DC W:11                        7   On radio button hilited.
5878 A5F1 09 00                 DC W:9                         8   Up arrow normal.
5879 A5F3 09 00                 DC W:9                         9   Up arrow hilited.
5880 A5F5 09 00                 DC W:9                         10  Down arrow normal.
5881 A5F7 09 00                 DC W:9                         11  Down arrow hilited.
5882 A5F9 09 00                 DC W:9                         12  Left arrow normal.
5883 A5FB 09 00                 DC W:9                         13  Left arrow hilited.
5884 A5FD 09 00                 DC W:9                         14  Right arrow normal.
5885 A5FF 09 00                 DC W:9                         15  Right arrow hilited.
5886 A601 09 00                 DC W:9                         16  Grow icon.
5887 A603 04 04                 DC W:$0404                     17  End of table.
5888 A605 00 00                 DC W:0                         18
5889 A607              ;
5890 A607              ;
5891 A607              ;
5892 A607              ;
5893 A607                       EXPORT ctl640 
5894 A607              ctl640                                  ; 
5895 A607              ;
5896 A607 06 00                 DC W:$0006                     ; {offset word}
5897 A609 D2 00                 DC W:$00D2                     ; {FontID}
5898 A60B 00 00                 DC W:$0000                     ; {style}
5899 A60D 0A 00                 DC W:$000A                     ; {size}
5900 A60F 00 01                 DC W:$0100                     ; {version}
5901 A611 17 00                 DC W:$0017                     ; {FBRext}
5902 A613
5903 A613 01 90                 DC W:$9001                     ; {FontType}
5904 A615 00 00                 DC W:$0000                     ; {FirstChar}
5905 A617 10 00                 DC W:$0010                     ; {LastChar}
5906 A619 17 00                 DC W:$0017                     ; {WidMax}
5907 A61B 00 00                 DC W:$0000                     ; {KernMax}
5908 A61D F7 FF                 DC W:$FFF7                     ; {nDescent}
5909 A61F 17 00                 DC W:$0017                     ; {fRectWidth}
5910 A621 09 00                 DC W:$0009                     ; {FrectHeight}
5911 A623 DE 00                 DC W:$00DE                     ; {owTLoc}
5912 A625 00 00                 DC W:$0000                     ; {ascent}
5913 A627 09 00                 DC W:$0009                     ; {descent}
5914 A629 00 00                 DC W:$0000                     ; {leading}
5915 A62B 16 00                 DC W:$0016                     ; {RowWords}
5916 A62D              ;
5917 A62D              ; BitImage:
5918 A62D FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$3F,$E0,$01,$FF
5919 A63D 00 0F F8 00           DC B:$00,$0F,$F8,$00,$7F,$C0,$00,$C0,$00,$30,$00,$FF,$C0,$3F,$F0,$00
5920 A64D E0 00 38 00           DC B:$E0,$00,$38,$00,$1C,$00,$07,$00,$FF,$C0,$00,$00,$C0,$00,$07,$FF
5921 A65D FF FF C0 00           DC B:$FF,$FF,$C0,$00,$7F,$FF,$FF,$F1,$C0,$1C,$0F,$FF,$E0,$70,$07,$03
5922 A66D FF F8 03 30           DC B:$FF,$F8,$03,$30,$00,$FC,$00,$C0,$C0,$3F,$F0,$03,$60,$00,$F8,$00
5923 A67D 1B 00 07 C0           DC B:$1B,$00,$07,$C0,$C0,$C0,$07,$F0,$C0,$00,$07,$F0,$00,$7F,$38,$03
5924 A68D 9F F0 07 F6           DC B:$9F,$F0,$07,$F6,$00,$03,$3F,$01,$F9,$87,$F0,$CF,$C0,$7E,$0C,$0C
5925 A69D 03 FF 00 C0           DC B:$03,$FF,$00,$C0,$C0,$3F,$F0,$0C,$7F,$C3,$FF,$FF,$F8,$C3,$FF,$F0
5926 A6AD C0 FF C0 7F           DC B:$C0,$FF,$C0,$7F,$C0,$00,$07,$F0,$00,$7F,$07,$1C,$1F,$CE,$39,$FC
5927 A6BD 00 01 FC 00           DC B:$00,$01,$FC,$00,$7F,$1F,$FC,$7F,$1F,$1F,$30,$03,$0F,$FF,$C0,$C0
5928 A6CD C0 3F F0 30           DC B:$C0,$3F,$F0,$30,$00,$CF,$FF,$FC,$00,$33,$FF,$FC,$C0,$C0,$C3,$03
5929 A6DD C0 00 07 F0           DC B:$C0,$00,$07,$F0,$00,$7F,$00,$E0,$1F,$C1,$C1,$FC,$00,$01,$F8,$00
5930 A6ED 3F 3F FE 7E           DC B:$3F,$3F,$FE,$7E,$3F,$8F,$FC,$0F,$FF,$FF,$FF,$C0,$FF,$FF,$FF,$C0
5931 A6FD 00 FF FF FC           DC B:$00,$FF,$FF,$FC,$00,$0F,$FF,$FF,$FF,$C0,$C7,$0C,$C0,$00,$07,$F0
5932 A70D 00 7F 07 1C           DC B:$00,$7F,$07,$1C,$1F,$CE,$39,$FC,$00,$01,$FC,$00,$7F,$1F,$FC,$7F
5933 A71D 1F 1F 0C 0C           DC B:$1F,$1F,$0C,$0C,$03,$FF,$03,$00,$30,$FF,$FC,$30,$00,$CF,$FF,$FC
5934 A72D 00 33 FF FC           DC B:$00,$33,$FF,$FC,$18,$00,$C3,$D8,$C0,$00,$07,$F0,$00,$7F,$38,$03
5935 A73D 9F F0 07 F6           DC B:$9F,$F0,$07,$F6,$00,$03,$3F,$01,$F9,$87,$F0,$CF,$C0,$7E,$0C,$0C
5936 A74D 03 FF 00 C0           DC B:$03,$FF,$00,$C0,$C0,$3F,$F0,$0C,$7F,$C3,$FF,$FF,$F8,$C3,$FF,$F0
5937 A75D 18 00 C0 C0           DC B:$18,$00,$C0,$C0,$C0,$00,$07,$FF,$FF,$FF,$C0,$00,$7F,$FF,$FF,$F1
5938 A76D C0 1C 0F FF           DC B:$C0,$1C,$0F,$FF,$E0,$70,$07,$03,$FF,$F8,$0C,$0C,$03,$FF,$00,$33
5939 A77D 00 0F C0 03           DC B:$00,$0F,$C0,$03,$60,$00,$F8,$00,$1B,$00,$07,$C0,$18,$00,$C7,$FE
5940 A78D FF FF FF FF           DC B:$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF,$F0,$3F,$E0,$01,$FF
5941 A79D 00 0F F8 00           DC B:$00,$0F,$F8,$00,$7F,$C0,$0F,$FC,$03,$FF,$00,$0C,$00,$03,$00,$00
5942 A7AD E0 00 38 00           DC B:$E0,$00,$38,$00,$1C,$00,$07,$00,$1F,$FF,$C0,$AF
5943 A7B9              ;
5944 A7B9              ; LocTable:
5945 A7B9 00 00                 DC W:$0000                     ; Char (00)
5946 A7BB 17 00                 DC W:$0017                     ; Char (01)
5947 A7BD 2E 00                 DC W:$002E                     ; Char (02)
5948 A7BF 45 00                 DC W:$0045                     ; Char (03)
5949 A7C1 5C 00                 DC W:$005C                     ; Char (04)
5950 A7C3 71 00                 DC W:$0071                     ; Char (05)
5951 A7C5 86 00                 DC W:$0086                     ; Char (06)
5952 A7C7 9B 00                 DC W:$009B                     ; Char (07)
5953 A7C9 B0 00                 DC W:$00B0                     ; Char (08)
5954 A7CB C2 00                 DC W:$00C2                     ; Char (09)
5955 A7CD D4 00                 DC W:$00D4                     ; Char (0A)
5956 A7CF E6 00                 DC W:$00E6                     ; Char (0B)
5957 A7D1 F8 00                 DC W:$00F8                     ; Char (0C)
5958 A7D3 0A 01                 DC W:$010A                     ; Char (0D)
5959 A7D5 1C 01                 DC W:$011C                     ; Char (0E)
5960 A7D7 2E 01                 DC W:$012E                     ; Char (0F)
5961 A7D9 40 01                 DC W:$0140                     ; Char (10)
5962 A7DB 52 01                 DC W:$0152                     ; Char (11)
5963 A7DD 52 01                 DC W:$0152                     ; Char (12)
5964 A7DF              ;
5965 A7DF              ; OWTable:
5966 A7DF 17 00                 DC W:$0017                     ; Char (00)
5967 A7E1 17 00                 DC W:$0017                     ; Char (01)
5968 A7E3 17 00                 DC W:$0017                     ; Char (02)
5969 A7E5 17 00                 DC W:$0017                     ; Char (03)
5970 A7E7 15 00                 DC W:$0015                     ; Char (04)
5971 A7E9 15 00                 DC W:$0015                     ; Char (05)
5972 A7EB 15 00                 DC W:$0015                     ; Char (06)
5973 A7ED 15 00                 DC W:$0015                     ; Char (07)
5974 A7EF 12 00                 DC W:$0012                     ; Char (08)
5975 A7F1 12 00                 DC W:$0012                     ; Char (09)
5976 A7F3 12 00                 DC W:$0012                     ; Char (0A)
5977 A7F5 12 00                 DC W:$0012                     ; Char (0B)
5978 A7F7 12 00                 DC W:$0012                     ; Char (0C)
5979 A7F9 12 00                 DC W:$0012                     ; Char (0D)
5980 A7FB 12 00                 DC W:$0012                     ; Char (0E)
5981 A7FD 12 00                 DC W:$0012                     ; Char (0F)
5982 A7FF 12 00                 DC W:$0012                     ; Char (10)
5983 A801 04 04                 DC W:$0404                     ; Char 'H'
5984 A803 00 00                 DC W:$0000                     ; Char 'I'
5985 A805              ;
5986 A805                       ENDP 
5987 A805
5988 A805
5989 A805
5990 A805
5991 A805                       END   
5992 A805
